/*
 * Decompiled with CFR 0.152.
 */
package org.cogchar.api.animoid.protocol;

import java.util.List;
import java.util.Map;
import org.cogchar.api.animoid.protocol.Frame;
import org.cogchar.api.animoid.protocol.Joint;
import org.cogchar.api.animoid.protocol.JointPosition;
import org.cogchar.api.animoid.protocol.JointStateCoordinateType;
import org.cogchar.api.animoid.protocol.Robot;
import org.cogchar.platform.util.TimeUtils;

public class JointPositionSnapshot
extends Frame<JointPosition> {
    private long mySnapshotTimestamp;

    public JointPositionSnapshot() {
    }

    public JointPositionSnapshot(Robot r, JointStateCoordinateType coordType, Map<Integer, Double> positionValuesByJointID) {
        for (Integer jid : positionValuesByJointID.keySet()) {
            Joint j = r.getJointForOldLogicalNumber(jid);
            JointPosition jp = new JointPosition(j);
            Double absPos = positionValuesByJointID.get(jid);
            jp.setCoordinateFloat(coordType, absPos);
            this.addPosition(jp);
        }
        this.setSnapshotTimestamp(TimeUtils.currentTimeMillis());
    }

    public JointPositionSnapshot(List<JointPosition> jps) {
        for (JointPosition jp : jps) {
            this.addPosition(jp);
        }
        this.setSnapshotTimestamp(TimeUtils.currentTimeMillis());
    }

    public long getSnapshotTimestamp() {
        return this.mySnapshotTimestamp;
    }

    public void setSnapshotTimestamp(long mySnapshotTimestamp) {
        this.mySnapshotTimestamp = mySnapshotTimestamp;
    }
}

