/*
 * Decompiled with CFR 0.152.
 */
package org.cogchar.api.animoid.protocol;

import java.io.Serializable;
import java.util.List;
import org.cogchar.api.animoid.protocol.Joint;
import org.cogchar.api.animoid.protocol.JointStateCoordinateType;
import org.cogchar.api.animoid.protocol.JointVelocityAROMPS;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class JointStateItem
implements Serializable {
    private static Logger theLogger = LoggerFactory.getLogger((String)JointStateItem.class.getName());
    private JointStateCoordinateType myCoordinateType;
    private Double myFloatCoordinate;
    private Integer myIntCoordinate;
    private Joint myJoint;

    public JointStateItem(Joint j) {
        this.myJoint = j;
    }

    public abstract JointStateItem copy();

    public void copyStateFrom(JointStateItem sourceJSI) {
        if (!sourceJSI.getJoint().equals(this.myJoint)) {
            throw new RuntimeException("Can't copy values across different joints");
        }
        this.myCoordinateType = sourceJSI.myCoordinateType;
        this.myFloatCoordinate = sourceJSI.myFloatCoordinate;
        this.myIntCoordinate = sourceJSI.myIntCoordinate;
    }

    public Double getCoordinateFloat(JointStateCoordinateType type) {
        if (type != this.myCoordinateType) {
            throw new RuntimeException("Unsupported:  Tried to fetch coordinate of " + (Object)((Object)this.myCoordinateType) + " as " + (Object)((Object)type));
        }
        return this.myFloatCoordinate;
    }

    public JointStateCoordinateType getCoordinateType() {
        return this.myCoordinateType;
    }

    public Joint getJoint() {
        return this.myJoint;
    }

    public void multiplyByScalar(double scalar) {
        JointStateCoordinateType ct = this.getCoordinateType();
        switch (ct) {
            case FLOAT_VEL_RANGE_OF_MOTION_PER_SEC: 
            case FLOAT_ACC_RANGE_OF_MOTION_PSPS: 
            case FLOAT_REL_RANGE_OF_MOTION: {
                double val = this.getCoordinateFloat(ct);
                double updated = val * scalar;
                this.setCoordinateFloat(ct, updated);
                break;
            }
            default: {
                throw new RuntimeException("Can't multiply scalar to joint position of type " + (Object)((Object)ct) + " on " + this.getJoint());
            }
        }
    }

    public void setCoordinateFloat(JointStateCoordinateType type, Double value) {
        this.myCoordinateType = type;
        this.myFloatCoordinate = value;
    }

    public void verifyCoordinateTypeCompatibility(JointStateCoordinateType queryCT) {
        JointStateCoordinateType ct = this.getCoordinateType();
        if (!ct.equals((Object)queryCT)) {
            throw new RuntimeException("Joint " + this.getJoint() + " ctype=" + (Object)((Object)ct) + ", which is incompatible with " + (Object)((Object)queryCT));
        }
    }

    public boolean isZero() {
        return this.myFloatCoordinate < 0.001 && this.myFloatCoordinate > -0.001;
    }

    public static <JSI extends JointStateItem> String dumpStateList(List<JSI> jsil) {
        StringBuffer result = new StringBuffer("[");
        boolean first = true;
        for (JointStateItem jsi : jsil) {
            if (first) {
                first = false;
            } else {
                result.append(", ");
            }
            result.append(jsi.toString());
        }
        result.append("]");
        return result.toString();
    }

    public void truncate() {
        JointStateCoordinateType ct = this.getCoordinateType();
        if (ct.equals((Object)JointStateCoordinateType.FLOAT_ABS_RANGE_OF_MOTION)) {
            double val = this.getCoordinateFloat(ct);
            if (val < 0.0) {
                this.setCoordinateFloat(ct, 1.0E-6);
            } else if (val > 1.0) {
                this.setCoordinateFloat(ct, 0.999999);
            }
        } else {
            throw new RuntimeException("Can't truncate value type " + (Object)((Object)ct) + " on " + this.getJoint());
        }
    }

    public static double computeRateOfChange(JointStateCoordinateType inType, JointStateItem prevState, JointStateItem currState, double timeSec) {
        double prevVal = prevState.getCoordinateFloat(inType);
        double currVal = currState.getCoordinateFloat(inType);
        double deltaVal = currVal - prevVal;
        double rate = deltaVal / timeSec;
        return rate;
    }

    public JointVelocityAROMPS asJointVelocity() {
        if (this.myCoordinateType == JointStateCoordinateType.FLOAT_VEL_RANGE_OF_MOTION_PER_SEC) {
            return new JointVelocityAROMPS(this.myJoint, this.myFloatCoordinate);
        }
        throw new RuntimeException("Can't repackage as JointVelocity: " + this.toString());
    }
}

