/*
 * Decompiled with CFR 0.152.
 */
package org.cogchar.api.animoid.world;

import org.cogchar.api.animoid.protocol.Joint;
import org.cogchar.api.animoid.protocol.JointPosition;
import org.cogchar.api.animoid.protocol.JointStateCoordinateType;
import org.cogchar.api.animoid.protocol.JointVelocityAROMPS;

public abstract class WorldJoint {
    protected Double rangeOfMotionDegrees;
    protected Joint myJoint;
    protected Integer logicalJointID;

    public abstract boolean isWorldSenseInverted();

    public Joint getJoint() {
        return this.myJoint;
    }

    public void setJoint(Joint j) {
        this.myJoint = j;
    }

    public Integer getLogicalJointID() {
        return this.logicalJointID;
    }

    public Double getRangeOfMotionDegrees() {
        return this.rangeOfMotionDegrees;
    }

    protected double getCenterPosROM() {
        JointPosition centerPos = this.myJoint.getCenterPosition();
        return centerPos.getCoordinateFloat(JointStateCoordinateType.FLOAT_ABS_RANGE_OF_MOTION);
    }

    protected double getRawMaxDegreesOffset() {
        double centerValROM = this.getCenterPosROM();
        double highSideRangeROM = 1.0 - centerValROM;
        return highSideRangeROM * this.rangeOfMotionDegrees;
    }

    protected double getRawMinDegreesOffset() {
        double centerValROM = this.getCenterPosROM();
        return -1.0 * centerValROM * this.rangeOfMotionDegrees;
    }

    public double getTruncatedInternalDegreesOffset(double wildOffsetDeg) {
        double rawMax = this.getRawMaxDegreesOffset();
        double rawMin = this.getRawMinDegreesOffset();
        if (wildOffsetDeg > rawMax) {
            return rawMax;
        }
        if (wildOffsetDeg < rawMin) {
            return rawMin;
        }
        return wildOffsetDeg;
    }

    public double getWorldMaxDegreesOffset() {
        double worldMaxDeg = this.isWorldSenseInverted() ? -1.0 * this.getRawMinDegreesOffset() : this.getRawMaxDegreesOffset();
        return worldMaxDeg;
    }

    public double getWorldMinDegreesOffset() {
        return this.isWorldSenseInverted() ? -1.0 * this.getRawMaxDegreesOffset() : this.getRawMinDegreesOffset();
    }

    public double getWorldInversionMultiplier() {
        return this.isWorldSenseInverted() ? -1.0 : 1.0;
    }

    public double getTruncatedWorldDegreesOffset(double wildWorldAngleDeg) {
        double mult = this.getWorldInversionMultiplier();
        return mult * this.getTruncatedInternalDegreesOffset(mult * wildWorldAngleDeg);
    }

    public double getROM_posForWorldAngleDeg(double worldAngleDeg) {
        double romOffset = this.getWorldInversionMultiplier() * worldAngleDeg / this.rangeOfMotionDegrees;
        double centerVal = this.getCenterPosROM();
        double romPos = centerVal + romOffset;
        return romPos;
    }

    public double getROM_velForWorldAngleSpeed(double worldAngleSpeedDegPS) {
        double romSpeed = this.getWorldInversionMultiplier() * worldAngleSpeedDegPS / this.rangeOfMotionDegrees;
        return romSpeed;
    }

    public double getInternalAngleDegForROMJP(JointPosition jp) {
        double posAbsRom = jp.getCoordinateFloat(JointStateCoordinateType.FLOAT_ABS_RANGE_OF_MOTION);
        JointPosition centerJP = this.myJoint.getCenterPosition();
        double centerAbsRom = centerJP.getCoordinateFloat(JointStateCoordinateType.FLOAT_ABS_RANGE_OF_MOTION);
        return (posAbsRom - centerAbsRom) * this.rangeOfMotionDegrees;
    }

    public double getWorldAngleDegForROMJP(JointPosition jp) {
        double internalAngleDeg = this.getInternalAngleDegForROMJP(jp);
        return this.getWorldInversionMultiplier() * internalAngleDeg;
    }

    public double getInternalAngleSpeedDegPS_forVelAROMPS(JointPosition velJP) {
        double velRom = velJP.getCoordinateFloat(JointStateCoordinateType.FLOAT_VEL_RANGE_OF_MOTION_PER_SEC);
        return velRom * this.rangeOfMotionDegrees;
    }

    public double getWorldAngleSpeedDegPS_forVelAROMPS(JointPosition velJP) {
        double internalAngleSpeed = this.getInternalAngleSpeedDegPS_forVelAROMPS(velJP);
        return this.getWorldInversionMultiplier() * internalAngleSpeed;
    }

    public double getRoomAboveWorldAngleDeg(double worldAngleDeg, boolean exceptionIfNeg) {
        double room = this.getWorldMaxDegreesOffset() - worldAngleDeg;
        if (room < 0.0) {
            throw new RuntimeException("Negative room above worldAngle=" + worldAngleDeg + ", because max=" + this.getWorldMaxDegreesOffset() + ", worldJoint=" + this);
        }
        return room;
    }

    public double getRoomBelowWorldAngleDeg(double worldAngleDeg, boolean exceptionIfNeg) {
        double room = worldAngleDeg - this.getWorldMinDegreesOffset();
        if (room < 0.0) {
            throw new RuntimeException("Negative room below worldAngle=" + worldAngleDeg + ", because min=" + this.getWorldMaxDegreesOffset() + ", worldJoint=" + this);
        }
        return room;
    }

    public JointVelocityAROMPS computeVelForJumpToTruncWorldDeg(double currWorldDeg, double targetWorldDeg, double jumpDurSec) {
        double truncTargetWorldDeg = this.getTruncatedWorldDegreesOffset(targetWorldDeg);
        double deltaWorldDeg = truncTargetWorldDeg - currWorldDeg;
        double worldDegVelPS = deltaWorldDeg / jumpDurSec;
        double romVelPS = this.getROM_velForWorldAngleSpeed(worldDegVelPS);
        JointVelocityAROMPS jvel = new JointVelocityAROMPS(this.getJoint(), romVelPS);
        return jvel;
    }

    public String toString() {
        return "\nWorldJoint[\nlogicalJointID=" + this.getLogicalJointID() + "\nworldSenseInverted=" + this.isWorldSenseInverted() + "\nrangeDegrees=" + this.getRangeOfMotionDegrees() + "\nworldMaxDeg=" + this.getWorldMaxDegreesOffset() + "\nworldMinDeg=" + this.getWorldMinDegreesOffset() + "\njoint=" + this.getJoint() + "]";
    }
}

