/*
 * Decompiled with CFR 0.152.
 */
package org.cogchar.api.animoid.world;

import org.cogchar.api.animoid.protocol.Frame;
import org.cogchar.api.animoid.protocol.Joint;
import org.cogchar.api.animoid.protocol.JointPosition;
import org.cogchar.api.animoid.protocol.JointStateCoordinateType;
import org.cogchar.api.animoid.world.WorldJoint;

public class WorldJointStateSnap {
    private WorldJoint myWorldJoint;
    private JointPosition myPositionJP;
    private JointPosition myVelocityJP;

    public WorldJointStateSnap(WorldJoint wj, JointPosition posJP, JointPosition velJP) {
        this.myWorldJoint = wj;
        this.setPositionJP(posJP);
        this.setVelocityJP(velJP);
    }

    public WorldJointStateSnap(WorldJoint wj, Frame posFrame, Frame velFrame) {
        this(wj, (JointPosition)posFrame.getJointPositionForJoint(wj.getJoint()), (JointPosition)velFrame.getJointPositionForJoint(wj.getJoint()));
    }

    public Joint getJoint() {
        WorldJoint wj = this.getWorldJoint();
        return wj != null ? wj.getJoint() : null;
    }

    public WorldJoint getWorldJoint() {
        return this.myWorldJoint;
    }

    public void setPositionJP(JointPosition posJP) {
        this.myPositionJP = posJP;
        double posAbsRom = this.myPositionJP.getCoordinateFloat(JointStateCoordinateType.FLOAT_ABS_RANGE_OF_MOTION);
        JointPosition centerJP = this.getJoint().getCenterPosition();
        double centerAbsRom = centerJP.getCoordinateFloat(JointStateCoordinateType.FLOAT_ABS_RANGE_OF_MOTION);
    }

    public void setVelocityJP(JointPosition velJP) {
        this.myVelocityJP = velJP;
    }

    public double getPosAbsRom() {
        return this.myPositionJP.getCoordinateFloat(JointStateCoordinateType.FLOAT_ABS_RANGE_OF_MOTION);
    }

    public double getPosInternalDegOffCenter() {
        return this.getWorldJoint().getInternalAngleDegForROMJP(this.myPositionJP);
    }

    public double getWorldPosDeg() {
        return this.getWorldJoint().getWorldAngleDegForROMJP(this.myPositionJP);
    }

    public JointPosition getPositionJP() {
        return this.myPositionJP;
    }

    public double getTotalRomDegrees() {
        return this.getWorldJoint().getRangeOfMotionDegrees();
    }

    public double getInternalVelDegPerSec() {
        return this.getWorldJoint().getInternalAngleSpeedDegPS_forVelAROMPS(this.myVelocityJP);
    }

    public double getWorldVelDegPerSec() {
        return this.getWorldJoint().getWorldAngleSpeedDegPS_forVelAROMPS(this.myVelocityJP);
    }

    public double getVelRomPerSec() {
        return this.myVelocityJP.getCoordinateFloat(JointStateCoordinateType.FLOAT_VEL_RANGE_OF_MOTION_PER_SEC);
    }

    public JointPosition getVelocityJP() {
        return this.myVelocityJP;
    }

    public double getRoomAbovePosInWorldDeg() {
        return this.getWorldJoint().getRoomAboveWorldAngleDeg(this.getWorldPosDeg(), true);
    }

    public double getRoomBelowPosInWorldDeg() {
        return this.getWorldJoint().getRoomBelowWorldAngleDeg(this.getWorldPosDeg(), true);
    }

    public String toString() {
        return "GJLS[joint=" + this.getJoint() + ", romTotalDeg=" + this.getTotalRomDegrees() + ", posAbsRom=" + this.getPosAbsRom() + ", posDegOffCenter=" + this.getPosInternalDegOffCenter() + ", velRomPS=" + this.getVelRomPerSec() + ", velDegPS=" + this.getInternalVelDegPerSec() + "]";
    }

    public String getShortDescriptiveName() {
        Joint j = this.getJoint();
        if (j != null) {
            return j.getJointName();
        }
        if (this.myWorldJoint != null) {
            return "J" + this.myWorldJoint.getLogicalJointID();
        }
        return String.valueOf(this.hashCode());
    }
}

