/*
 * Decompiled with CFR 0.152.
 */
package org.cogchar.api.cinema;

import java.util.HashMap;
import java.util.Map;
import org.appdapter.core.name.Ident;
import org.appdapter.help.repo.RepoClient;
import org.appdapter.help.repo.Solution;
import org.appdapter.help.repo.SolutionList;
import org.cogchar.api.cinema.RotationConfig;
import org.cogchar.api.cinema.VectorScaleConfig;
import org.cogchar.api.cinema.WaypointConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AnimWaypointsConfig {
    private static Logger theLogger = LoggerFactory.getLogger(AnimWaypointsConfig.class);
    public Map<Ident, WaypointConfig> myWCs = new HashMap<Ident, WaypointConfig>();
    public Map<Ident, RotationConfig> myRCs = new HashMap<Ident, RotationConfig>();
    public Map<Ident, VectorScaleConfig> myVSCs = new HashMap<Ident, VectorScaleConfig>();
    private static AnimWaypointsConfig mainConfig;

    public static void setMainConfig(AnimWaypointsConfig config) {
        mainConfig = config;
        theLogger.info("Main AnimWaypointsConfig set: " + mainConfig);
    }

    public static AnimWaypointsConfig getMainConfig() {
        return mainConfig;
    }

    public String toString() {
        return "[AnimWaypointsConfig: " + this.myWCs.size() + " positions, " + this.myRCs.size() + " rotations, " + this.myVSCs.size() + " vector scalings]";
    }

    public AnimWaypointsConfig(RepoClient qi, Ident qGraph) {
        Object newConfig;
        SolutionList waypointSolList = qi.queryIndirectForAllSolutions("ccrt:find_waypoints_99", qGraph);
        for (Solution waypointSol : waypointSolList.javaList()) {
            newConfig = new WaypointConfig(qi, waypointSol);
            this.myWCs.put(((WaypointConfig)newConfig).myUri, (WaypointConfig)newConfig);
        }
        waypointSolList = qi.queryIndirectForAllSolutions("ccrt:find_rotations_99", qGraph);
        for (Solution waypointSol : waypointSolList.javaList()) {
            newConfig = new RotationConfig(qi, waypointSol);
            this.myRCs.put(((RotationConfig)newConfig).myUri, (RotationConfig)newConfig);
        }
        waypointSolList = qi.queryIndirectForAllSolutions("ccrt:find_vector_scalings_99", qGraph);
        for (Solution waypointSol : waypointSolList.javaList()) {
            newConfig = new VectorScaleConfig(qi, waypointSol);
            this.myVSCs.put(((VectorScaleConfig)newConfig).myUri, (VectorScaleConfig)newConfig);
        }
    }
}

