/*
 * Decompiled with CFR 0.152.
 */
package org.cogchar.api.cinema;

import java.util.Arrays;
import org.appdapter.core.name.Ident;
import org.appdapter.help.repo.Solution;
import org.appdapter.help.repo.SolutionHelper;
import org.cogchar.name.cinema.LightsCameraCN;

public class CameraConfig {
    public Ident myCamID;
    public float[] myCamPos = new float[3];
    public float[] myCamPointDir = new float[3];
    public float[] myDisplayRect = new float[4];
    public Ident myAttachedRobotID;
    public String myAttachedBoneName;
    public boolean myBoneAttachmentFlag = false;

    public String toString() {
        return "CameraConfig[id=" + this.myCamID + ", pos=" + Arrays.toString(this.myCamPos) + ", dir=" + Arrays.toString(this.myCamPointDir) + ", viewport=" + Arrays.toString(this.myDisplayRect) + "]";
    }

    public CameraConfig(Solution qSoln) {
        int index;
        SolutionHelper sh = new SolutionHelper();
        this.myCamID = sh.pullIdent(qSoln, "camera");
        for (index = 0; index < 3; ++index) {
            this.myCamPos[index] = sh.pullFloat(qSoln, LightsCameraCN.POSITION_VAR_NAME[index], 0.0f);
            this.myCamPointDir[index] = sh.pullFloat(qSoln, LightsCameraCN.DIRECTION_VAR_NAME[index], 0.0f);
        }
        for (index = 0; index < this.myDisplayRect.length; ++index) {
            this.myDisplayRect[index] = sh.pullFloat(qSoln, LightsCameraCN.VIEWPORT_VAR_NAME[index], Float.NaN);
        }
        this.myAttachedRobotID = sh.pullIdent(qSoln, "robot");
        this.myAttachedBoneName = sh.pullString(qSoln, "bone");
        if (this.myAttachedRobotID != null && this.myAttachedBoneName != null) {
            this.myBoneAttachmentFlag = true;
        }
    }

    public CameraConfig(Ident camID, float[] camPos, float[] camPointDir, float[] displayRect) {
        this.myCamID = camID;
        this.myCamPos = camPos;
        this.myCamPointDir = camPointDir;
        this.myDisplayRect = displayRect;
    }

    public void setAttachmentNodeParams(Ident attachedRobotID, String attachedBoneName) {
        this.myAttachedRobotID = attachedRobotID;
        this.myAttachedBoneName = attachedBoneName;
        this.myBoneAttachmentFlag = true;
    }
}

