/*
 * Decompiled with CFR 0.152.
 */
package org.cogchar.api.cinema;

import java.util.Arrays;
import org.appdapter.core.item.Item;
import org.appdapter.core.item.ItemFuncs;
import org.appdapter.core.name.Ident;
import org.appdapter.help.repo.RepoClient;
import org.appdapter.help.repo.Solution;
import org.appdapter.help.repo.SolutionHelper;
import org.cogchar.name.cinema.LightsCameraAN;
import org.cogchar.name.cinema.LightsCameraCN;

public class LightConfig {
    public String lightName;
    public LightType lightType;
    public float[] lightDirection = new float[3];
    public float[] lightColor = new float[4];

    public String toString() {
        return "LightConfig[name=" + this.lightName + ", type=" + this.lightType.name() + ", dir=" + Arrays.toString(this.lightDirection) + ", color=" + Arrays.toString(this.lightColor) + "]";
    }

    public LightConfig(RepoClient queryEmitter, Solution querySolution) {
        int index;
        SolutionHelper sh = new SolutionHelper();
        this.lightName = sh.pullIdent(querySolution, "light").getLocalName();
        this.lightType = LightType.AMBIENT;
        Ident typeIdent = sh.pullIdent(querySolution, "lightType");
        if (typeIdent.getLocalName().equals("DIRECTIONAL")) {
            this.lightType = LightType.DIRECTIONAL;
        }
        for (index = 0; index < this.lightDirection.length; ++index) {
            this.lightDirection[index] = sh.pullFloat(querySolution, LightsCameraCN.DIRECTION_VAR_NAME[index], 0.0f);
        }
        for (index = 0; index < this.lightColor.length; ++index) {
            this.lightColor[index] = sh.pullFloat(querySolution, LightsCameraCN.COLOR_VAR_NAME[index], Float.NaN);
        }
    }

    public LightConfig(Item configItem) {
        int index;
        this.lightName = configItem.getIdent().getLocalName();
        this.lightType = LightType.AMBIENT;
        String typeString = ItemFuncs.getString((Item)configItem, (String)LightsCameraAN.P_lightType, null);
        if (typeString.equals("DIRECTIONAL")) {
            this.lightType = LightType.DIRECTIONAL;
        }
        for (index = 0; index < this.lightDirection.length; ++index) {
            this.lightDirection[index] = ItemFuncs.getDouble((Item)configItem, (String)LightsCameraAN.P_direction[index], (Double)0.0).floatValue();
        }
        for (index = 0; index < this.lightColor.length; ++index) {
            this.lightColor[index] = ItemFuncs.getDouble((Item)configItem, (String)LightsCameraAN.P_color[index], null).floatValue();
        }
    }

    public static enum LightType {
        DIRECTIONAL,
        AMBIENT;

    }
}

