/*
 * Decompiled with CFR 0.152.
 */
package org.cogchar.api.cinema;

import java.util.ArrayList;
import java.util.List;
import org.appdapter.bind.rdf.jena.assembly.KnownComponentImpl;
import org.appdapter.core.name.Ident;
import org.appdapter.help.repo.RepoClient;
import org.appdapter.help.repo.Solution;
import org.appdapter.help.repo.SolutionHelper;
import org.appdapter.help.repo.SolutionList;
import org.cogchar.api.cinema.CameraConfig;
import org.cogchar.api.cinema.LightConfig;
import org.cogchar.name.cinema.LightsCameraCN;
import org.slf4j.Logger;

public class LightsCameraConfig
extends KnownComponentImpl {
    private Logger myLogger = LightsCameraConfig.getLoggerForClass(((Object)((Object)this)).getClass());
    public List<CameraConfig> myCCs = new ArrayList<CameraConfig>();
    public List<LightConfig> myLCs = new ArrayList<LightConfig>();
    public float[] backgroundColor = new float[]{0.8f, 0.8f, 0.8f, 1.0f};

    public LightsCameraConfig(RepoClient queryEmitter, Ident qGraph) {
        SolutionList solutionList = queryEmitter.queryIndirectForAllSolutions("ccrt:find_cameras_99", qGraph);
        for (Solution cameraSolution : solutionList.javaList()) {
            this.myCCs.add(new CameraConfig(cameraSolution));
        }
        solutionList = queryEmitter.queryIndirectForAllSolutions("ccrt:find_lights_99", qGraph);
        for (Solution lightSolution : solutionList.javaList()) {
            this.myLCs.add(new LightConfig(queryEmitter, lightSolution));
        }
        try {
            solutionList = queryEmitter.queryIndirectForAllSolutions("ccrt:find_background_color_99", qGraph);
            List javaSolnList = solutionList.javaList();
            int listSize = javaSolnList.size();
            if (listSize == 0) {
                this.myLogger.info("No background color specified, using default");
            } else {
                if (listSize > 1) {
                    this.myLogger.warn("Found multiple background color specifications; ignoring all but one!");
                }
                Solution bgColorSoln = (Solution)javaSolnList.get(listSize - 1);
                SolutionHelper sh = new SolutionHelper();
                for (int i = 0; i < this.backgroundColor.length; ++i) {
                    this.backgroundColor[i] = sh.pullFloat(bgColorSoln, LightsCameraCN.COLOR_VAR_NAME[i], this.backgroundColor[i]);
                }
            }
        }
        catch (Exception e) {
            this.myLogger.warn("Problem querying for background color; using default", (Throwable)e);
        }
    }
}

