/*
 * Decompiled with CFR 0.152.
 */
package org.cogchar.api.cinema;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.appdapter.core.name.Ident;
import org.appdapter.help.repo.RepoClient;
import org.appdapter.help.repo.Solution;
import org.appdapter.help.repo.SolutionHelper;
import org.appdapter.help.repo.SolutionList;
import org.cogchar.api.cinema.AttachedItemType;
import org.cogchar.api.cinema.SpatialActionConfig;
import org.cogchar.api.cinema.WaypointConfig;
import org.cogchar.name.cinema.CinemaCN;

public class PathInstanceConfig
extends SpatialActionConfig {
    public float duration;
    public String directionType;
    public float[] lookAtDirection = new float[3];
    public float tension;
    public boolean cycle;
    public String loopMode;
    public List<WaypointConfig> waypoints = new ArrayList<WaypointConfig>();

    public String toString() {
        return "PathInstanceConfig[uriFrag = " + this.myUri.getAbsUriString() + ", duration = " + Float.toString(this.duration);
    }

    public PathInstanceConfig(RepoClient qi, Solution solution, Ident qGraph) {
        SolutionHelper sh = new SolutionHelper();
        this.myUri = sh.pullIdent(solution, "path");
        this.duration = sh.pullFloat(solution, "duration", Float.NaN);
        this.pullAttachedItemAndType(sh, solution);
        this.directionType = sh.pullIdent(solution, "directionType").getLocalName();
        for (int index = 0; index < this.lookAtDirection.length; ++index) {
            this.lookAtDirection[index] = sh.pullFloat(solution, CinemaCN.DIRECTION_VAR_NAME[index], 0.0f);
        }
        this.tension = sh.pullFloat(solution, "tension", 0.0f);
        this.cycle = sh.pullBoolean(solution, "cycle");
        this.loopMode = sh.pullIdent(solution, "loop").getLocalName();
        SolutionList solutionList = qi.queryIndirectForAllSolutions("ccrt:template_waypoint_99", qGraph, "path", this.myUri);
        Map<Integer, Solution> wpMap = this.pullOrderedStatesFromList(sh, solutionList);
        for (Solution waypointSoln : wpMap.values()) {
            this.waypoints.add(new WaypointConfig(qi, waypointSoln));
        }
    }

    public PathInstanceConfig(Ident item, AttachedItemType itemType, float newDuration, float[] newDirection, List<WaypointConfig> theWaypoints, Ident pathUri) {
        this.duration = newDuration;
        this.directionType = "Rotation";
        this.lookAtDirection = newDirection;
        this.tension = 0.83f;
        this.cycle = false;
        this.loopMode = "DontLoop";
        this.waypoints = theWaypoints;
        this.attachedItem = item;
        this.attachedItemType = itemType;
        this.myUri = pathUri;
    }

    final Map<Integer, Solution> pullOrderedStatesFromList(SolutionHelper sh, SolutionList solutionList) {
        TreeMap<Integer, Solution> stateMap = new TreeMap<Integer, Solution>();
        for (Solution wpSolution : solutionList.javaList()) {
            int index = (int)sh.pullFloat(wpSolution, "order", 0.0f);
            stateMap.put(index, wpSolution);
        }
        return stateMap;
    }
}

