/*
 * Decompiled with CFR 0.152.
 */
package org.cogchar.api.cinema;

import java.util.ArrayList;
import java.util.List;
import org.appdapter.core.name.Ident;
import org.appdapter.help.repo.RepoClient;
import org.appdapter.help.repo.Solution;
import org.appdapter.help.repo.SolutionHelper;
import org.appdapter.help.repo.SolutionList;
import org.cogchar.api.cinema.SpatialActionConfig;

public class ThingAnimInstanceConfig
extends SpatialActionConfig {
    public float duration;
    public List<KeyFrameConfig> myKeyFrameDefinitions = new ArrayList<KeyFrameConfig>();

    public String toString() {
        return "ThingAnimInstanceConfig[uriFrag = " + this.myUri.getAbsUriString() + ", duration = " + Float.toString(this.duration) + ", # of keyframes: " + this.myKeyFrameDefinitions.size();
    }

    public ThingAnimInstanceConfig(RepoClient qi, Solution solution, Ident qGraph) {
        SolutionHelper sh = new SolutionHelper();
        this.myUri = sh.pullIdent(solution, "anim");
        this.duration = sh.pullFloat(solution, "duration", Float.NaN);
        this.pullAttachedItemAndType(sh, solution);
        SolutionList keyFrameSolutionList = qi.queryIndirectForAllSolutions("ccrt:template_key_frames_99", qGraph, "anim", this.myUri);
        for (Solution waypointSoln : keyFrameSolutionList.javaList()) {
            float time = sh.pullFloat(waypointSoln, "time", Float.NaN);
            Ident locationIdent = sh.pullIdent(waypointSoln, "locationRef");
            Ident orientationIdent = sh.pullIdent(waypointSoln, "orientationRef");
            Ident scaleIdent = sh.pullIdent(waypointSoln, "scaleRef");
            float scale = sh.pullFloat(waypointSoln, "scale", Float.NaN);
            this.myKeyFrameDefinitions.add(new KeyFrameConfig(time, locationIdent, orientationIdent, scaleIdent, scale));
        }
    }

    public class KeyFrameConfig {
        public float myTime;
        public Ident myLocation;
        public Ident myOrientation;
        public Ident myScale;
        public float myScalarScale;

        KeyFrameConfig(float time, Ident locationIdent, Ident orientationIdent, Ident scaleIdent, float scale) {
            this.myTime = time;
            this.myLocation = locationIdent;
            this.myOrientation = orientationIdent;
            this.myScale = scaleIdent;
            this.myScalarScale = scale;
        }
    }
}

