/*
 * Decompiled with CFR 0.152.
 */
package org.cogchar.api.cinema;

import java.util.Arrays;
import org.appdapter.core.name.Ident;
import org.appdapter.help.repo.RepoClient;
import org.appdapter.help.repo.Solution;
import org.appdapter.help.repo.SolutionHelper;
import org.cogchar.name.cinema.CinemaCN;

public class WaypointConfig {
    public Ident myUri;
    public float[] myCoordinates = new float[]{Float.NaN, Float.NaN, Float.NaN};

    public String toString() {
        return "WaypointConfig = " + this.myUri.getAbsUriString() + ", position = " + Arrays.toString(this.myCoordinates);
    }

    public WaypointConfig(RepoClient qi, Solution solution) {
        SolutionHelper sh = new SolutionHelper();
        this.myUri = sh.pullIdent(solution, "waypoint");
        for (int index = 0; index < this.myCoordinates.length; ++index) {
            this.myCoordinates[index] = sh.pullFloat(solution, CinemaCN.POSITION_VAR_NAME[index], Float.NaN);
        }
    }

    public WaypointConfig(Ident newIdent, float[] position) {
        this.myUri = newIdent;
        this.myCoordinates = position;
    }

    public String getName() {
        return this.myUri.getLocalName();
    }
}

