/*
 * Decompiled with CFR 0.152.
 */
package org.cogchar.api.humanoid;

import org.appdapter.core.name.Ident;
import org.appdapter.help.repo.RepoClient;
import org.appdapter.help.repo.SolutionHelper;
import org.appdapter.help.repo.SolutionList;
import org.appdapter.help.repo.SolutionMap;
import org.cogchar.api.humanoid.HumanoidCN;

public class HumanoidConfig {
    public Ident myCharIdent;
    public String myNickname = "";
    public String myMeshPath;
    public String myJointConfigPath;
    public Float[] myInitialPosition = new Float[3];
    public float myScale;
    public boolean myPhysicsFlag;

    public HumanoidConfig(RepoClient qi, Ident charIdent, Ident graphIdent) {
        SolutionHelper sh = new SolutionHelper();
        this.myCharIdent = charIdent;
        SolutionList sList = qi.queryIndirectForAllSolutions("ccrt:find_humanoids_99", graphIdent);
        SolutionMap solutionMap = sList.makeSolutionMap("humInd");
        this.myNickname = sh.pullString(solutionMap, charIdent, "rkRobotID");
        this.myMeshPath = sh.pullString(solutionMap, charIdent, "meshPath");
        this.myJointConfigPath = sh.pullString(solutionMap, charIdent, "jointConfigPath");
        for (int i = 0; i < this.myInitialPosition.length; ++i) {
            this.myInitialPosition[i] = Float.valueOf(sh.pullFloat(solutionMap, charIdent, HumanoidCN.INITIAL_POSITION_VAR_NAMES[i]));
        }
        this.myScale = sh.pullFloat(solutionMap, charIdent, "scale");
        this.myPhysicsFlag = sh.pullBoolean(solutionMap, charIdent, "physics");
    }

    public String toString() {
        return "HumanoidConfig[charId=" + this.myCharIdent + ", nickname=" + this.myNickname + ", meshPath=" + this.myMeshPath + ", jointConfigPath=" + this.myJointConfigPath + ", initialPos=" + this.myInitialPosition + ", physics=" + this.myPhysicsFlag + "]";
    }
}

