/*
 * Decompiled with CFR 0.152.
 */
package org.cogchar.api.humanoid;

import java.util.List;
import org.appdapter.core.name.Ident;
import org.appdapter.help.repo.RepoClient;
import org.appdapter.help.repo.SolutionHelper;
import org.appdapter.help.repo.SolutionList;
import org.cogchar.api.humanoid.HumanoidBoneConfig;
import org.cogchar.api.humanoid.HumanoidConfig;

public class HumanoidFigureConfig {
    public Ident myCharIdent;
    public String myNickname;
    public String myMeshPath;
    public String myDebugSkelMatPath;
    public boolean myPhysicsFlag;
    public HumanoidBoneConfig myBoneConfig;
    public float myInitX;
    public float myInitY;
    public float myInitZ;
    public float myScale;

    public HumanoidFigureConfig(RepoClient qi, HumanoidConfig hc, String matPath, Ident bonyGraphIdent) {
        this.myCharIdent = hc.myCharIdent;
        this.myNickname = hc.myNickname;
        this.myMeshPath = hc.myMeshPath;
        this.myDebugSkelMatPath = matPath;
        this.myBoneConfig = new HumanoidBoneConfig();
        this.myInitX = hc.myInitialPosition[0].floatValue();
        this.myInitY = hc.myInitialPosition[1].floatValue();
        this.myInitZ = hc.myInitialPosition[2].floatValue();
        this.myScale = hc.myScale;
        this.myPhysicsFlag = hc.myPhysicsFlag;
        this.addBoneDescsFromBoneRobotConfig(qi, this.myCharIdent, bonyGraphIdent, this);
    }

    private void addBoneDescsFromBoneRobotConfig(RepoClient qi, Ident charIdent, Ident bonyGraphIdent, HumanoidFigureConfig hfc) {
        SolutionHelper sh = new SolutionHelper();
        SolutionList solutionList = qi.queryIndirectForAllSolutions("ccrt:template_boneNames_99", bonyGraphIdent, "robotUri", charIdent);
        List boneNames = sh.pullStringsAsJava(solutionList, "boneName");
        for (String boneName : boneNames) {
            this.myBoneConfig.addBoneDesc(boneName);
        }
    }

    public boolean isComplete() {
        return this.myMeshPath != null;
    }
}

