/*
 * Decompiled with CFR 0.152.
 */
package org.cogchar.api.skeleton.config;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.appdapter.bind.rdf.jena.assembly.KnownComponentImpl;
import org.appdapter.core.item.Item;
import org.appdapter.core.item.ItemFuncs;
import org.appdapter.core.name.Ident;
import org.appdapter.help.repo.RepoClient;
import org.appdapter.help.repo.Solution;
import org.appdapter.help.repo.SolutionHelper;
import org.appdapter.help.repo.SolutionList;
import org.appdapter.help.repo.SolutionMap;
import org.cogchar.api.skeleton.config.BoneProjectionRange;
import org.cogchar.api.skeleton.config.BoneRotationAxis;
import org.cogchar.name.skeleton.BoneAN;

public class BoneJointConfig
extends KnownComponentImpl {
    public String myURI_Fragment;
    public Integer myJointNum;
    public String myJointName;
    public String myBoneName;
    public Double myNormalDefaultPos;
    public List<BoneProjectionRange> myProjectionRanges = new ArrayList<BoneProjectionRange>();

    public BoneJointConfig(Item configItem) {
        this.myURI_Fragment = configItem.getIdent().getLocalName();
        this.myJointNum = ItemFuncs.getInteger((Item)configItem, (String)BoneAN.P_jointNum, null);
        this.myJointName = ItemFuncs.getString((Item)configItem, (String)BoneAN.P_jointName, null);
        this.myNormalDefaultPos = ItemFuncs.getDouble((Item)configItem, (String)BoneAN.P_defaultPosNorm, null);
        Set bprItems = ItemFuncs.getLinkedItemSet((Item)configItem, (String)BoneAN.P_projectionRange);
        for (Item bpri : bprItems) {
            BoneProjectionRange bpr = BoneProjectionRange.makeOne(this, bpri);
            this.myProjectionRanges.add(bpr);
        }
    }

    public BoneJointConfig(RepoClient qi, Ident jointIdent, SolutionMap<Ident> solutionMap, Ident graphIdent) {
        SolutionHelper sh = new SolutionHelper();
        this.myURI_Fragment = jointIdent.getLocalName();
        this.myJointNum = sh.pullInteger(solutionMap, jointIdent, "jointNum");
        this.myJointName = sh.pullString(solutionMap, jointIdent, "jointName");
        this.myNormalDefaultPos = sh.pullDouble(solutionMap, jointIdent, "defaultPos");
        SolutionList solutionList = qi.queryIndirectForAllSolutions("ccrt:template_boneProjectionRanges_99", graphIdent, "boneJointUri", jointIdent);
        if (solutionList.javaList().size() == 1) {
            Solution projRangeSoln = (Solution)solutionList.javaList().get(0);
            String boneName = sh.pullString(projRangeSoln, "boneName");
            String rotationAxisName = sh.pullString(projRangeSoln, "rotationAxis");
            Double minAngle = sh.pullDouble(projRangeSoln, "minAngle", 0.0);
            Double maxAngle = sh.pullDouble(projRangeSoln, "maxAngle", 0.0);
            BoneRotationAxis rotationAxis = BoneRotationAxis.valueOf(rotationAxisName);
            this.myProjectionRanges.add(new BoneProjectionRange(this, boneName, rotationAxis, Math.toRadians(minAngle), Math.toRadians(maxAngle)));
            solutionList = qi.queryIndirectForAllSolutions("ccrt:template_additionalBones_99", graphIdent, "boneJointUri", jointIdent);
            for (Solution solution : solutionList.javaList()) {
                boneName = sh.pullString(solution, "boneName", "");
                rotationAxisName = sh.pullString(solution, "rotationAxis", "");
                minAngle = sh.pullDouble(solution, "minAngle", 0.0);
                maxAngle = sh.pullDouble(solution, "maxAngle", 0.0);
                rotationAxis = BoneRotationAxis.valueOf(rotationAxisName);
                this.myProjectionRanges.add(new BoneProjectionRange(this, boneName, rotationAxis, Math.toRadians(minAngle), Math.toRadians(maxAngle)));
            }
        } else {
            this.logWarning("More than one bone projection range definition in primary bone joint config declaration for " + this.myURI_Fragment + " -- not initializing projection ranges for this bone joint config");
        }
    }

    public String toString() {
        return "BJC[uriFrag=" + this.myURI_Fragment + ", num=" + this.myJointNum + ", name=" + this.myJointName + ", defPos=" + this.myNormalDefaultPos + ", projs=" + this.myProjectionRanges + "]";
    }
}

