/*
 * Decompiled with CFR 0.152.
 */
package org.cogchar.api.skeleton.config;

import org.appdapter.core.item.Item;
import org.appdapter.core.item.ItemFuncs;
import org.cogchar.api.skeleton.config.BoneJointConfig;
import org.cogchar.api.skeleton.config.BoneProjectionPosition;
import org.cogchar.api.skeleton.config.BoneRotationAxis;
import org.cogchar.name.skeleton.BoneAN;

public class BoneProjectionRange {
    private BoneJointConfig myBJC;
    public String myBoneName;
    private BoneRotationAxis myRotationAxis;
    private double myMinPosAngRad;
    private double myMaxPosAngRad;

    public BoneProjectionRange(BoneJointConfig bjc, String boneName, BoneRotationAxis axis, double minAngRad, double maxAngRad) {
        if (bjc == null || axis == null) {
            throw new RuntimeException("Null joint or axis passed to constructor");
        }
        this.myBJC = bjc;
        this.myBoneName = boneName;
        this.myRotationAxis = axis;
        this.myMinPosAngRad = minAngRad;
        this.myMaxPosAngRad = maxAngRad;
    }

    public static BoneProjectionRange makeOne(BoneJointConfig bjc, Item configItem) {
        String boneName = ItemFuncs.getString((Item)configItem, (String)BoneAN.P_boneName, null);
        String rotAxisName = ItemFuncs.getString((Item)configItem, (String)BoneAN.P_rotationAxis, null);
        Double minAngDeg = ItemFuncs.getDouble((Item)configItem, (String)BoneAN.P_minAngleDeg, null);
        Double maxAngDeg = ItemFuncs.getDouble((Item)configItem, (String)BoneAN.P_maxAngleDeg, null);
        double minAngRad = Math.toRadians(minAngDeg);
        double maxAngRad = Math.toRadians(maxAngDeg);
        BoneRotationAxis rax = BoneRotationAxis.valueOf(rotAxisName);
        BoneProjectionRange bpr = new BoneProjectionRange(bjc, boneName, rax, minAngRad, maxAngRad);
        return bpr;
    }

    public String getBoneName() {
        return this.myBoneName;
    }

    public BoneRotationAxis getRotationAxis() {
        return this.myRotationAxis;
    }

    public double getMinPosAngRad() {
        return this.myMinPosAngRad;
    }

    public double getMaxPosAngRad() {
        return this.myMaxPosAngRad;
    }

    public BoneJointConfig getJointConfig() {
        return this.myBJC;
    }

    public BoneProjectionPosition makePositionForNormalizedFraction(double normVal) {
        double rangeRad = this.myMaxPosAngRad - this.myMinPosAngRad;
        double boneProjAngleRad = rangeRad * normVal + this.myMinPosAngRad;
        return new BoneProjectionPosition(this, boneProjAngleRad);
    }

    protected String getFieldSummary() {
        return "boneName=[" + this.myBoneName + "], rotAxis=[" + (Object)((Object)this.myRotationAxis) + "], minRotRad=[" + this.myMinPosAngRad + "], maxRotRad=[" + this.myMaxPosAngRad + "]";
    }

    public String toString() {
        return "BPR[" + this.getFieldSummary() + "]";
    }
}

