/*
 * Decompiled with CFR 0.152.
 */
package org.cogchar.api.skeleton.config;

import com.hp.hpl.jena.assembler.Assembler;
import com.hp.hpl.jena.assembler.Mode;
import com.hp.hpl.jena.rdf.model.Resource;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import org.appdapter.bind.rdf.jena.assembly.AssemblerUtils;
import org.appdapter.bind.rdf.jena.assembly.DynamicCachingComponentAssembler;
import org.appdapter.bind.rdf.jena.assembly.KnownComponentImpl;
import org.appdapter.core.item.Item;
import org.appdapter.core.item.ItemFuncs;
import org.appdapter.core.log.BasicDebugger;
import org.appdapter.core.log.Debuggable;
import org.appdapter.core.name.Ident;
import org.appdapter.help.repo.RepoClient;
import org.appdapter.help.repo.SolutionHelper;
import org.appdapter.help.repo.SolutionList;
import org.appdapter.help.repo.SolutionMap;
import org.cogchar.api.skeleton.config.BoneJointConfig;
import org.cogchar.name.skeleton.BoneAN;
import org.cogchar.name.skeleton.BoneCN;

public class BoneRobotConfig
extends KnownComponentImpl {
    public String myRobotName;
    public List<BoneJointConfig> myBJCs = new ArrayList<BoneJointConfig>();
    private static String UNIT_TEST_RDF_PATH = "../org.cogchar.bundle.render.resources/src/main/resources/rk_bind_config/motion/bonyRobot_ZenoR50.ttl";

    public String getFieldSummary() {
        return super.getFieldSummary() + ", robotName=" + this.myRobotName + ", joints=[" + this.myBJCs + "]";
    }

    public BoneRobotConfig() {
    }

    public BoneRobotConfig(RepoClient rc, Ident bonyConfigIdent, Ident graphIdent, BoneCN bqn) {
        SolutionHelper sh = new SolutionHelper();
        this.getLogger().info("Building BoneRobotConfig via queries for {} using graph {} ", (Object)bonyConfigIdent, (Object)graphIdent);
        SolutionList robotSL = rc.queryIndirectForAllSolutions("ccrt:find_robotName_99", graphIdent);
        SolutionMap robotSolMap = robotSL.makeSolutionMap("humInd");
        this.myRobotName = sh.pullString(robotSolMap, bonyConfigIdent, "robotName");
        SolutionList bjConfSL = rc.queryIndirectForAllSolutions("ccrt:template_boneJointConfigs_99", graphIdent, "robotUri", bonyConfigIdent);
        List boneJointConfigIdents = sh.pullIdentsAsJava(bjConfSL, "jointConfigInstance");
        SolutionList bjPropSL = rc.queryIndirectForAllSolutions("ccrt:template_basicJointProperties_99", graphIdent, "robotUri", bonyConfigIdent);
        SolutionMap bjPropSM = bjPropSL.makeSolutionMap("joint");
        for (Ident jointIdent : boneJointConfigIdents) {
            this.myBJCs.add(new BoneJointConfig(rc, jointIdent, (SolutionMap<Ident>)bjPropSM, graphIdent));
        }
    }

    public static void main(String[] args) {
        BasicDebugger bd = new BasicDebugger();
        bd.logInfo("starting boneRobotConfig test");
        String triplesPath = UNIT_TEST_RDF_PATH;
        bd.logInfo("Loading triples from path: " + triplesPath);
        Set loadedStuff = AssemblerUtils.buildAllObjectsInRdfFile((String)triplesPath);
        bd.logInfo("Loaded " + loadedStuff.size() + " objects");
        for (Object o : loadedStuff) {
            bd.logInfo("Loaded: " + o);
        }
        bd.logInfo("=====================================================================");
    }

    public static class Builder
    extends DynamicCachingComponentAssembler<BoneRobotConfig> {
        public Builder(Resource builderConfRes) {
            super(builderConfRes);
        }

        protected void initExtendedFieldsAndLinks(BoneRobotConfig mrc, Item configItem, Assembler assmblr, Mode mode) {
            this.getLogger().debug("BoneRobotConfig.initExtendedFieldsAndLinks()-BEGIN");
            mrc.myRobotName = ItemFuncs.getString((Item)configItem, (String)BoneAN.P_robotName, null);
            Set jointItems = ItemFuncs.getLinkedItemSet((Item)configItem, (String)BoneAN.P_joint);
            for (Item ji : jointItems) {
                BoneJointConfig bjc = new BoneJointConfig(ji);
                mrc.myBJCs.add(bjc);
            }
            Collections.sort(mrc.myBJCs, new Comparator(){

                public int compare(Object o1, Object o2) {
                    int jointNum1 = ((BoneJointConfig)((Object)o1)).myJointNum;
                    int jointNum2 = ((BoneJointConfig)((Object)o2)).myJointNum;
                    return jointNum1 - jointNum2;
                }
            });
        }

        public void clearCacheForThisAssemblerType() {
            Debuggable.notImplemented((Object[])new Object[]{"AssemblerUtils.clearCacheForAssemblerSubclassForSession(Builder.class, getSession());"});
        }
    }
}

