/*
 * Decompiled with CFR 0.152.
 */
package org.cogchar.api.vworld;

import org.appdapter.core.name.Ident;
import org.cogchar.api.thing.TypedValueMap;
import org.cogchar.name.goody.GoodyNames;

public class GoodyActionParamReader {
    private TypedValueMap myTVM;

    public GoodyActionParamReader(TypedValueMap tvm) {
        this.myTVM = tvm;
    }

    public Float[] getVec2D(Ident xName, Ident yName) {
        Float[] resultVec = new Float[2];
        try {
            resultVec[0] = this.myTVM.getAsFloat(xName);
            resultVec[1] = this.myTVM.getAsFloat(yName);
        }
        catch (Exception e) {
            // empty catch block
        }
        return resultVec;
    }

    public Float[] getVec3D(Ident xName, Ident yName, Ident zName) {
        Float[] resultVec = new Float[3];
        try {
            resultVec[0] = this.myTVM.getAsFloat(xName);
            resultVec[1] = this.myTVM.getAsFloat(yName);
            resultVec[2] = this.myTVM.getAsFloat(zName);
        }
        catch (Exception e) {
            // empty catch block
        }
        return resultVec;
    }

    public Float[] getVec4D(Ident aName, Ident bName, Ident cName, Ident dName) {
        Float[] resultVec = new Float[4];
        try {
            resultVec[0] = this.myTVM.getAsFloat(aName);
            resultVec[1] = this.myTVM.getAsFloat(bName);
            resultVec[2] = this.myTVM.getAsFloat(cName);
            resultVec[3] = this.myTVM.getAsFloat(dName);
        }
        catch (Exception e) {
            // empty catch block
        }
        return resultVec;
    }

    public Float[] getLocationVec3D() {
        Float[] result = this.getVec3D(GoodyNames.LOCATION_X, GoodyNames.LOCATION_Y, GoodyNames.LOCATION_Z);
        if (result[2] == null) {
            result[2] = Float.valueOf(0.0f);
        }
        return result;
    }

    public Float[] getSizeVec3D() {
        return this.getVec3D(GoodyNames.SIZE_X, GoodyNames.SIZE_Y, GoodyNames.SIZE_Z);
    }

    public Float[] getScaleVec3D() {
        return this.getVec3D(GoodyNames.SCALE_X, GoodyNames.SCALE_Y, GoodyNames.SCALE_Z);
    }

    public Float[] getColorVec4D() {
        Float[] result = this.getVec4D(GoodyNames.COLOR_RED, GoodyNames.COLOR_GREEN, GoodyNames.COLOR_BLUE, GoodyNames.COLOR_ALPHA);
        if (result[3] == null) {
            result[3] = Float.valueOf(1.0f);
        }
        return result;
    }

    public Float getScaleUniform() {
        return this.myTVM.getAsFloat(GoodyNames.SCALE_UNIFORM);
    }

    public Float[] getRotAxisVec3D() {
        return this.getVec3D(GoodyNames.ROTATION_AXIS_X, GoodyNames.ROTATION_AXIS_Y, GoodyNames.ROTATION_AXIS_Z);
    }

    public Float getRotMagRadians() {
        Float rot = this.myTVM.getAsFloat(GoodyNames.ROTATION_MAG_DEG);
        if (rot == null) {
            return Float.valueOf(0.0f);
        }
        return Float.valueOf(rot.floatValue() * (float)Math.PI / 180.0f);
    }

    public String getText() {
        return this.myTVM.getAsString(GoodyNames.TEXT);
    }

    public Float getTravelTime() {
        return this.myTVM.getAsFloat(GoodyNames.TRAVEL_TIME);
    }

    public String getSpecialString(Ident paramIdent) {
        return this.myTVM.getAsString(paramIdent);
    }

    public Boolean getSpecialBoolean(Ident paramIdent) {
        return this.myTVM.getAsBoolean(paramIdent);
    }

    public Integer getSpecialInteger(Ident paramIdent) {
        return this.myTVM.getAsInteger(paramIdent);
    }
}

