/*
 * Decompiled with CFR 0.152.
 */
package org.cognitor.cassandra.migration.spring;

import com.datastax.driver.core.Cluster;
import org.cognitor.cassandra.migration.Database;
import org.cognitor.cassandra.migration.MigrationRepository;
import org.cognitor.cassandra.migration.MigrationTask;
import org.cognitor.cassandra.migration.collector.FailOnDuplicatesCollector;
import org.cognitor.cassandra.migration.collector.IgnoreDuplicatesCollector;
import org.cognitor.cassandra.migration.collector.ScriptCollector;
import org.cognitor.cassandra.migration.scanner.LocationScanner;
import org.cognitor.cassandra.migration.scanner.ScannerRegistry;
import org.cognitor.cassandra.migration.spring.CassandraMigrationConfigurationProperties;
import org.cognitor.cassandra.migration.spring.ScriptCollectorStrategy;
import org.cognitor.cassandra.migration.spring.scanner.SpringBootLocationScanner;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.cassandra.CassandraAutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@EnableConfigurationProperties(value={CassandraMigrationConfigurationProperties.class})
@AutoConfigureAfter(value={CassandraAutoConfiguration.class})
@ConditionalOnClass(value={Cluster.class})
public class CassandraMigrationAutoConfiguration {
    private final CassandraMigrationConfigurationProperties properties;

    @Autowired
    public CassandraMigrationAutoConfiguration(CassandraMigrationConfigurationProperties properties) {
        this.properties = properties;
    }

    @Bean(initMethod="migrate")
    @ConditionalOnBean(value={Cluster.class})
    @ConditionalOnMissingBean(value={MigrationTask.class})
    public MigrationTask migrationTask(Cluster cluster) {
        if (!this.properties.hasKeyspaceName()) {
            throw new IllegalStateException("Please specify ['cassandra.migration.keyspace-name'] in order to migrate your database");
        }
        MigrationRepository migrationRepository = this.createRepository();
        return new MigrationTask(new Database(cluster, this.properties.getKeyspaceName()).setConsistencyLevel(this.properties.getConsistencyLevel()), migrationRepository);
    }

    private MigrationRepository createRepository() {
        ScannerRegistry registry = new ScannerRegistry();
        registry.register("jar", (LocationScanner)new SpringBootLocationScanner());
        if (this.properties.getStrategy() == ScriptCollectorStrategy.FAIL_ON_DUPLICATES) {
            return new MigrationRepository(this.properties.getScriptLocation(), (ScriptCollector)new FailOnDuplicatesCollector(), registry);
        }
        return new MigrationRepository(this.properties.getScriptLocation(), (ScriptCollector)new IgnoreDuplicatesCollector(), registry);
    }
}

