/*
 * Decompiled with CFR 0.152.
 */
package org.cognitor.cassandra.migration.spring;

import com.datastax.driver.core.ConsistencyLevel;
import org.cognitor.cassandra.migration.spring.ScriptCollectorStrategy;
import org.springframework.boot.context.properties.ConfigurationProperties;

@ConfigurationProperties(prefix="cassandra.migration")
public class CassandraMigrationConfigurationProperties {
    private ScriptCollectorStrategy strategy = ScriptCollectorStrategy.FAIL_ON_DUPLICATES;
    private String scriptLocation = "cassandra/migration";
    private String keyspaceName;
    private ConsistencyLevel consistencyLevel = ConsistencyLevel.QUORUM;

    public String getScriptLocation() {
        return this.scriptLocation;
    }

    public void setScriptLocation(String scriptLocation) {
        if (scriptLocation == null || scriptLocation.isEmpty()) {
            throw new IllegalArgumentException("Script location cannot be unset.");
        }
        this.scriptLocation = scriptLocation;
    }

    public String getKeyspaceName() {
        return this.keyspaceName;
    }

    public void setKeyspaceName(String keyspaceName) {
        this.keyspaceName = keyspaceName;
    }

    public ScriptCollectorStrategy getStrategy() {
        return this.strategy;
    }

    public void setStrategy(ScriptCollectorStrategy strategy) {
        this.strategy = strategy;
    }

    public boolean hasKeyspaceName() {
        return this.keyspaceName != null && !this.keyspaceName.isEmpty();
    }

    public ConsistencyLevel getConsistencyLevel() {
        return this.consistencyLevel;
    }

    public void setConsistencyLevel(ConsistencyLevel consistencyLevel) {
        this.consistencyLevel = consistencyLevel;
    }
}

