/*
 * Decompiled with CFR 0.152.
 */
package org.cognitor.cassandra.migration.collector;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.cognitor.cassandra.migration.MigrationException;
import org.cognitor.cassandra.migration.collector.ScriptCollector;
import org.cognitor.cassandra.migration.collector.ScriptFile;

public class FailOnDuplicatesCollector
implements ScriptCollector {
    private final List<ScriptFile> scripts = new ArrayList<ScriptFile>();
    private final Set<Integer> versions = new HashSet<Integer>();

    @Override
    public void collect(ScriptFile scriptFile) {
        if (this.versions.contains(scriptFile.getVersion())) {
            throw new MigrationException(String.format("Found two different files for version %d", scriptFile.getVersion()), scriptFile.getScriptName());
        }
        this.scripts.add(scriptFile);
        this.versions.add(scriptFile.getVersion());
    }

    @Override
    public Collection<ScriptFile> getScriptFiles() {
        return this.scripts;
    }
}

