/*
 * Decompiled with CFR 0.152.
 */
package org.cognitor.cassandra.migration.keyspace;

import org.cognitor.cassandra.migration.keyspace.ReplicationStrategy;

public class SimpleStrategy
implements ReplicationStrategy {
    private int replicationFactor;

    public SimpleStrategy(int replicationFactor) {
        if (replicationFactor < 1) {
            throw new IllegalArgumentException("Replication Factor must be greater than zero");
        }
        this.replicationFactor = replicationFactor;
    }

    public SimpleStrategy() {
        this(1);
    }

    @Override
    public String getName() {
        return "SimpleStrategy";
    }

    public int getReplicationFactor() {
        return this.replicationFactor;
    }

    @Override
    public String createCqlStatement() {
        return "{'class':'" + this.getName() + "','replication_factor':" + this.getReplicationFactor() + "}";
    }
}

