/*
 * Decompiled with CFR 0.152.
 */
package org.cognitor.cassandra.migration.cql;

import java.util.ArrayList;
import java.util.List;

public class SimpleCQLLexer {
    private final String text;
    private LexState state = LexState.DEFAULT;
    private int pos;

    public SimpleCQLLexer(String scriptText) {
        this.text = scriptText;
        this.pos = 0;
    }

    public List<String> getCqlQueries() {
        char c;
        ArrayList<String> statements = new ArrayList<String>();
        StringBuilder statementUnderConstruction = new StringBuilder();
        while ((c = this.getChar()) != '\u0000') {
            switch (this.state) {
                case DEFAULT: {
                    if (c == '/' && this.peekAhead() == '/') {
                        this.state = LexState.IN_SINGLE_LINE_COMMENT;
                        this.advance();
                        break;
                    }
                    if (c == '-' && this.peekAhead() == '-') {
                        this.state = LexState.IN_SINGLE_LINE_COMMENT;
                        this.advance();
                        break;
                    }
                    if (c == '/' && this.peekAhead() == '*') {
                        this.state = LexState.IN_MULTI_LINE_COMMENT;
                        this.advance();
                        break;
                    }
                    if (c == '\n') {
                        statementUnderConstruction.append(' ');
                        break;
                    }
                    statementUnderConstruction.append(c);
                    if (c == '\"') {
                        this.state = LexState.IN_QUOTE_STRING;
                        break;
                    }
                    if (c == '\'') {
                        this.state = LexState.IN_SQUOTE_STRING;
                        break;
                    }
                    if (c != ';') break;
                    statements.add(statementUnderConstruction.toString().trim());
                    statementUnderConstruction.setLength(0);
                    break;
                }
                case IN_SINGLE_LINE_COMMENT: {
                    if (c != '\n') break;
                    this.state = LexState.DEFAULT;
                    break;
                }
                case IN_MULTI_LINE_COMMENT: {
                    if (c != '*' || this.peekAhead() != '/') break;
                    this.state = LexState.DEFAULT;
                    this.advance();
                    break;
                }
                case IN_QUOTE_STRING: {
                    statementUnderConstruction.append(c);
                    if (c != '\"') break;
                    if (this.peekAhead() == '\"') {
                        statementUnderConstruction.append(this.getChar());
                        break;
                    }
                    this.state = LexState.DEFAULT;
                    break;
                }
                case IN_SQUOTE_STRING: {
                    statementUnderConstruction.append(c);
                    if (c != '\'') break;
                    if (this.peekAhead() == '\'') {
                        statementUnderConstruction.append(this.getChar());
                        break;
                    }
                    this.state = LexState.DEFAULT;
                }
            }
        }
        String tmp = statementUnderConstruction.toString().trim();
        if (tmp.length() > 0) {
            statements.add(tmp);
        }
        return statements;
    }

    private char getChar() {
        if (this.pos < this.text.length()) {
            return this.text.charAt(this.pos++);
        }
        return '\u0000';
    }

    private char peekAhead() {
        if (this.pos < this.text.length()) {
            return this.text.charAt(this.pos);
        }
        return '\u0000';
    }

    private void advance() {
        ++this.pos;
    }

    private static enum LexState {
        DEFAULT,
        IN_SINGLE_LINE_COMMENT,
        IN_MULTI_LINE_COMMENT,
        IN_QUOTE_STRING,
        IN_SQUOTE_STRING;

    }
}

