/*
 * Decompiled with CFR 0.152.
 */
package org.cognitor.cassandra.migration.keyspace;

import org.cognitor.cassandra.migration.keyspace.ReplicationStrategy;
import org.cognitor.cassandra.migration.keyspace.SimpleStrategy;
import org.cognitor.cassandra.migration.util.Ensure;

public class Keyspace {
    private final String keyspaceName;
    private boolean durableWrites;
    private ReplicationStrategy replicationStrategy;

    public Keyspace(String keyspaceName) {
        this.keyspaceName = Ensure.notNullOrEmpty(keyspaceName, "keyspaceName");
        this.replicationStrategy = new SimpleStrategy();
        this.durableWrites = true;
    }

    public String getKeyspaceName() {
        return this.keyspaceName;
    }

    public Keyspace withoutDurableWrites() {
        this.durableWrites = false;
        return this;
    }

    public Keyspace with(ReplicationStrategy replicationStrategy) {
        this.replicationStrategy = Ensure.notNull(replicationStrategy, "replicationStrategy");
        return this;
    }

    public boolean isDurableWrites() {
        return this.durableWrites;
    }

    public ReplicationStrategy getReplicationStrategy() {
        return this.replicationStrategy;
    }

    public String getCqlStatement() {
        StringBuilder builder = new StringBuilder(60);
        builder.append("CREATE KEYSPACE IF NOT EXISTS ").append(this.getKeyspaceName()).append(" WITH REPLICATION = ").append(this.getReplicationStrategy().createCqlStatement()).append(" AND DURABLE_WRITES = ").append(Boolean.toString(this.isDurableWrites()));
        return builder.toString();
    }
}

