/*
 * Decompiled with CFR 0.152.
 */
package org.cognitor.cassandra.migration.scanner;

import java.util.HashMap;
import java.util.Map;
import org.cognitor.cassandra.migration.scanner.FileSystemLocationScanner;
import org.cognitor.cassandra.migration.scanner.JarLocationScanner;
import org.cognitor.cassandra.migration.scanner.LocationScanner;
import org.cognitor.cassandra.migration.util.Ensure;

public class ScannerRegistry {
    public static final String JAR_SCHEME = "jar";
    public static final String FILE_SCHEME = "file";
    private final Map<String, LocationScanner> scanners = new HashMap<String, LocationScanner>();

    public ScannerRegistry() {
        this.scanners.put(JAR_SCHEME, new JarLocationScanner());
        this.scanners.put(FILE_SCHEME, new FileSystemLocationScanner());
    }

    public LocationScanner getScanner(String scheme) {
        Ensure.notNullOrEmpty(scheme, "scheme");
        return this.scanners.get(scheme.toLowerCase());
    }

    public boolean supports(String scheme) {
        Ensure.notNullOrEmpty(scheme, "scheme");
        return this.scanners.containsKey(scheme.toLowerCase());
    }

    public void register(String scheme, LocationScanner scanner) {
        Ensure.notNullOrEmpty(scheme, "scheme");
        Ensure.notNull(scanner, "scanner");
        this.scanners.put(scheme.toLowerCase(), scanner);
    }

    public void unregister(String scheme) {
        Ensure.notNullOrEmpty(scheme, "scheme");
        this.scanners.remove(scheme);
    }
}

