/*
 * Decompiled with CFR 0.152.
 */
package org.cogroo.ruta.uima;

import org.apache.commons.lang.StringUtils;
import org.apache.uima.analysis_engine.AnalysisEngineProcessException;
import org.apache.uima.cas.CAS;
import org.apache.uima.cas.CASRuntimeException;
import org.apache.uima.cas.Feature;
import org.apache.uima.cas.FeatureStructure;
import org.apache.uima.cas.Type;
import org.apache.uima.cas.TypeSystem;
import org.apache.uima.cas.text.AnnotationFS;
import org.cogroo.ruta.uima.AnnotatorUtil;
import org.cogroo.text.Chunk;
import org.cogroo.text.Sentence;
import org.cogroo.text.SyntacticChunk;
import org.cogroo.text.Token;

public class UimaCasAdapter {
    public static final String CHUNK_TYPE_PARAMETER = "opennlp.uima.ChunkType";
    public static final String CHUNK_TAG_FEATURE_PARAMETER = "opennlp.uima.ChunkTagFeature";
    private Type mSentenceType;
    private Type mTokenType;
    private Type mChunkType;
    private Feature mPosFeature;
    private Feature mChunkFeature;
    private Feature mLemmaFeature;
    private Feature mFeaturesFeature;
    private Feature mLexemeFeature;
    private Feature mChunkHead;
    private Type mSyntacticChunkType;
    private Feature mSyntacticChunkFeature;
    private boolean typesystemInitialized = false;

    private void typeSystemInit(TypeSystem typeSystem) throws AnalysisEngineProcessException {
        if (this.typesystemInitialized) {
            return;
        }
        this.mSentenceType = AnnotatorUtil.getType(typeSystem, "opennlp.uima.Sentence");
        this.mTokenType = AnnotatorUtil.getType(typeSystem, "opennlp.uima.Token");
        this.mPosFeature = AnnotatorUtil.getRequiredFeature(this.mTokenType, "pos", "uima.cas.String");
        this.mLexemeFeature = AnnotatorUtil.getRequiredFeature(this.mTokenType, "lexeme", "uima.cas.String");
        this.mLemmaFeature = AnnotatorUtil.getRequiredFeature(this.mTokenType, "lemma", "uima.cas.String");
        this.mFeaturesFeature = AnnotatorUtil.getRequiredFeature(this.mTokenType, "features", "uima.cas.String");
        this.mChunkType = AnnotatorUtil.getType(typeSystem, "opennlp.uima.Chunk");
        this.mChunkFeature = AnnotatorUtil.getRequiredFeature(this.mChunkType, "chunkType", "uima.cas.String");
        this.mChunkHead = AnnotatorUtil.getRequiredFeature(this.mChunkType, "head", "opennlp.uima.Token");
        this.mSyntacticChunkType = AnnotatorUtil.getType(typeSystem, "opennlp.uima.SyntacticChunk");
        this.mSyntacticChunkFeature = AnnotatorUtil.getRequiredFeature(this.mSyntacticChunkType, "syntChunkType", "uima.cas.String");
        this.typesystemInitialized = true;
    }

    public void populateCas(Sentence sentence, CAS tcas) throws AnalysisEngineProcessException, CASRuntimeException {
        this.typeSystemInit(tcas.getTypeSystem());
        AnnotationFS sentenceAnn = tcas.createAnnotation(this.mSentenceType, sentence.getStart(), sentence.getEnd());
        tcas.getIndexRepository().addFS((FeatureStructure)sentenceAnn);
        int sentenceOffset = sentence.getStart();
        AnnotationFS[] tokenAnnotationArr = new AnnotationFS[sentence.getTokens().size()];
        int i = 0;
        for (Token token : sentence.getTokens()) {
            tokenAnnotationArr[i] = tcas.createAnnotation(this.mTokenType, sentenceOffset + token.getStart(), sentenceOffset + token.getEnd());
            tokenAnnotationArr[i].setStringValue(this.mPosFeature, token.getPOSTag());
            tokenAnnotationArr[i].setStringValue(this.mLexemeFeature, token.getLexeme());
            Object[] lemmas = token.getLemmas();
            String lemma = StringUtils.join((Object[])lemmas, (String)" ");
            tokenAnnotationArr[i].setStringValue(this.mLemmaFeature, lemma);
            tokenAnnotationArr[i].setStringValue(this.mFeaturesFeature, token.getFeatures());
            tcas.getIndexRepository().addFS((FeatureStructure)tokenAnnotationArr[i]);
            ++i;
        }
        for (Chunk chunk : sentence.getChunks()) {
            int start = ((Token)sentence.getTokens().get(chunk.getStart())).getStart() + sentenceOffset;
            int end = ((Token)sentence.getTokens().get(chunk.getEnd() - 1)).getEnd() + sentenceOffset;
            AnnotationFS chunkAnn = tcas.createAnnotation(this.mChunkType, start, end);
            chunkAnn.setStringValue(this.mChunkFeature, chunk.getTag());
            if (chunk.getHeadIndex() >= 0) {
                chunkAnn.setFeatureValue(this.mChunkHead, (FeatureStructure)tokenAnnotationArr[chunk.getHeadIndex()]);
            }
            tcas.getIndexRepository().addFS((FeatureStructure)chunkAnn);
        }
        for (SyntacticChunk sc : sentence.getSyntacticChunks()) {
            int start = ((Token)sentence.getTokens().get(sc.getStart())).getStart() + sentenceOffset;
            int end = ((Token)sentence.getTokens().get(sc.getEnd() - 1)).getEnd() + sentenceOffset;
            AnnotationFS syntChunkAnn = tcas.createAnnotation(this.mSyntacticChunkType, start, end);
            syntChunkAnn.setStringValue(this.mSyntacticChunkFeature, sc.getTag());
            tcas.getIndexRepository().addFS((FeatureStructure)syntChunkAnn);
        }
    }

    public Type getSentenceType() {
        return this.mSentenceType;
    }

    public Type getTokenType() {
        return this.mTokenType;
    }

    public Type getChunkType() {
        return this.mChunkType;
    }

    public Feature getPosFeature() {
        return this.mPosFeature;
    }

    public Feature getChunkFeature() {
        return this.mChunkFeature;
    }

    public Feature getLemmaFeature() {
        return this.mLemmaFeature;
    }

    public Feature getFeaturesFeature() {
        return this.mFeaturesFeature;
    }

    public Feature getLexemeFeature() {
        return this.mLexemeFeature;
    }

    public Feature getChunkHead() {
        return this.mChunkHead;
    }

    public Type getSyntacticChunkType() {
        return this.mSyntacticChunkType;
    }

    public Feature getSyntacticChunkFeature() {
        return this.mSyntacticChunkFeature;
    }
}

