/*
 * Decompiled with CFR 0.152.
 */
package org.cojen.dirmi;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketAddress;
import java.nio.channels.Channels;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.util.Objects;
import java.util.concurrent.Executor;
import java.util.function.BiConsumer;
import java.util.function.Predicate;
import org.cojen.dirmi.ClassResolver;
import org.cojen.dirmi.Connector;
import org.cojen.dirmi.Serializer;
import org.cojen.dirmi.Session;
import org.cojen.dirmi.core.ClassLoaderResolver;
import org.cojen.dirmi.core.CoreUtils;
import org.cojen.dirmi.core.Engine;

public interface Environment
extends Closeable,
Executor {
    public static Environment create() {
        return new Engine();
    }

    public static Environment create(Executor executor) {
        Objects.requireNonNull(executor);
        return new Engine(executor);
    }

    public Object export(Object var1, Object var2) throws IOException;

    default public Closeable acceptAll(ServerSocket ss) throws IOException {
        return this.acceptAll(ss, null);
    }

    public Closeable acceptAll(ServerSocket var1, Predicate<Socket> var2) throws IOException;

    default public Closeable acceptAll(ServerSocketChannel ss) throws IOException {
        return this.acceptAll(ss, null);
    }

    public Closeable acceptAll(ServerSocketChannel var1, Predicate<SocketChannel> var2) throws IOException;

    default public Session<?> accepted(Socket s) throws IOException {
        CoreUtils.setOptions(s);
        return this.accepted(s.getLocalSocketAddress(), s.getRemoteSocketAddress(), s.getInputStream(), s.getOutputStream());
    }

    default public Session<?> accepted(SocketChannel s) throws IOException {
        CoreUtils.setOptions(s);
        return this.accepted(s.getLocalAddress(), s.getRemoteAddress(), Channels.newInputStream(s), Channels.newOutputStream(s));
    }

    public Session<?> accepted(SocketAddress var1, SocketAddress var2, InputStream var3, OutputStream var4) throws IOException;

    public <R> Session<R> connect(Class<R> var1, Object var2, SocketAddress var3) throws IOException;

    default public <R> Session<R> connect(Class<R> type, Object name, String host, int port) throws IOException {
        return this.connect(type, name, new InetSocketAddress(host, port));
    }

    public Connector connector(Connector var1) throws IOException;

    public void customSerializers(Serializer ... var1);

    public void reconnectDelayMillis(int var1);

    public void pingTimeoutMillis(int var1);

    public void idleConnectionMillis(int var1);

    public void classResolver(ClassResolver var1);

    default public void classLoader(ClassLoader loader) {
        this.classResolver(loader == null ? null : new ClassLoaderResolver(loader));
    }

    public void uncaughtExceptionHandler(BiConsumer<Session<?>, Throwable> var1);

    @Override
    public void close();
}

