/*
 * Decompiled with CFR 0.152.
 */
package org.cojen.dirmi;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.net.SocketAddress;
import java.nio.channels.Channels;
import java.nio.channels.SocketChannel;
import java.util.concurrent.Executor;
import java.util.function.BiConsumer;
import java.util.function.BiPredicate;
import org.cojen.dirmi.Link;
import org.cojen.dirmi.core.CoreUtils;

public interface Session<R>
extends Closeable,
Link,
Executor {
    public R root();

    public static Session<?> access(Object obj) {
        return CoreUtils.accessSession(obj);
    }

    public static Session<?> current() {
        return CoreUtils.currentSession();
    }

    public static boolean dispose(Object obj) {
        return CoreUtils.dispose(obj);
    }

    public static boolean disposeServer(Object server) {
        return CoreUtils.disposeServer(server);
    }

    default public void connected(Socket s) throws IOException {
        CoreUtils.setOptions(s);
        this.connected(s.getLocalSocketAddress(), s.getRemoteSocketAddress(), s.getInputStream(), s.getOutputStream());
    }

    default public void connected(SocketChannel s) throws IOException {
        CoreUtils.setOptions(s);
        this.connected(s.getLocalAddress(), s.getRemoteAddress(), Channels.newInputStream(s), Channels.newOutputStream(s));
    }

    public void connected(SocketAddress var1, SocketAddress var2, InputStream var3, OutputStream var4) throws IOException;

    public Class<?> resolveClass(String var1) throws IOException, ClassNotFoundException;

    public void uncaughtExceptionHandler(BiConsumer<Session<?>, Throwable> var1);

    public void uncaught(Throwable var1);

    public State state();

    public void addStateListener(BiPredicate<Session<?>, Throwable> var1);

    @Override
    public void close();

    public static enum State {
        CONNECTED,
        DISCONNECTED,
        RECONNECTING,
        RECONNECTED,
        CLOSED;

    }
}

