/*
 * Decompiled with CFR 0.152.
 */
package org.cojen.dirmi.core;

import java.io.IOException;
import java.io.InputStream;
import java.io.InvalidObjectException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.OutputStream;
import java.io.StreamCorruptedException;
import java.io.UTFDataFormatException;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.TypeDescriptor;
import java.lang.invoke.VarHandle;
import java.lang.reflect.Array;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.SocketAddress;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.cojen.dirmi.ClosedException;
import org.cojen.dirmi.NoSuchObjectException;
import org.cojen.dirmi.Pipe;
import org.cojen.dirmi.core.CoreUtils;
import org.cojen.dirmi.core.ReferenceLookup;
import org.cojen.dirmi.core.ReferenceMap;
import org.cojen.dirmi.core.RemoteInfo;
import org.cojen.dirmi.core.Stub;
import org.cojen.dirmi.core.TypeCodeMap;

class BufferedPipe
implements Pipe {
    private static final int MAX_BUFFER_SIZE = 8192;
    static final VarHandle cShortArrayBEHandle;
    static final VarHandle cIntArrayBEHandle;
    static final VarHandle cLongArrayBEHandle;
    private final SocketAddress mLocalAddress;
    private final SocketAddress mRemoteAddress;
    private final InputStream mSourceIn;
    private final OutputStream mSourceOut;
    private byte[] mInBuffer;
    private int mInPos;
    private int mInEnd;
    private ReferenceLookup mInRefLookup;
    protected byte[] mOutBuffer;
    protected int mOutEnd;
    private ReferenceMap mOutRefMap;
    private In mIn;
    private Out mOut;
    private TypeCodeMap mTypeCodeMap;

    BufferedPipe(InputStream in, OutputStream out) {
        this(null, null, in, out);
    }

    BufferedPipe(SocketAddress localAddr, SocketAddress remoteAttr, InputStream in, OutputStream out) {
        this.mLocalAddress = localAddr;
        this.mRemoteAddress = remoteAttr;
        Objects.requireNonNull(in);
        Objects.requireNonNull(out);
        this.mSourceIn = in;
        this.mSourceOut = out;
        this.mInBuffer = new byte[32];
        this.mOutBuffer = new byte[32];
        this.initTypeCodeMap(TypeCodeMap.STANDARD);
    }

    final void initTypeCodeMap(TypeCodeMap tcm) {
        this.mTypeCodeMap = tcm;
        VarHandle.storeStoreFence();
    }

    @Override
    public final int read() throws IOException {
        int pos = this.mInPos;
        int avail = this.mInEnd - pos;
        byte[] buf = this.mInBuffer;
        if (avail <= 0) {
            try {
                avail = this.doRead(buf, 0, buf.length);
            }
            catch (IOException e) {
                throw this.inputException(e);
            }
            if (avail <= 0) {
                return -1;
            }
            pos = 0;
            this.mInEnd = avail;
            buf = this.mInBuffer;
        }
        int b = buf[pos++] & 0xFF;
        this.mInPos = pos;
        return b;
    }

    @Override
    public final int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    @Override
    public final int read(byte[] b, int off, int len) throws IOException {
        int avail = this.available();
        byte[] buf = this.mInBuffer;
        if (avail <= 0) {
            try {
                if (len >= buf.length) {
                    return this.doRead(b, off, len);
                }
                if (len <= 0) {
                    return 0;
                }
                avail = this.doRead(buf, 0, buf.length);
            }
            catch (IOException e) {
                throw this.inputException(e);
            }
            if (avail <= 0) {
                return -1;
            }
            this.mInPos = 0;
            this.mInEnd = avail;
            buf = this.mInBuffer;
        }
        len = Math.min(avail, len);
        System.arraycopy(buf, this.mInPos, b, off, len);
        this.mInPos += len;
        return len;
    }

    @Override
    public final long skip(long n) throws IOException {
        if (n <= 0L) {
            return 0L;
        }
        int avail = this.available();
        if (avail > 0) {
            if (n >= (long)avail) {
                this.mInPos = 0;
                this.mInEnd = 0;
                return avail;
            }
            this.mInPos += (int)n;
            return n;
        }
        try {
            return this.mSourceIn.skip(n);
        }
        catch (IOException e) {
            throw this.inputException(e);
        }
    }

    @Override
    public final int available() {
        return this.mInEnd - this.mInPos;
    }

    @Override
    public final void readFully(byte[] b) throws IOException {
        this.readFully(b, 0, b.length);
    }

    @Override
    public final void readFully(byte[] b, int off, int len) throws IOException {
        while (true) {
            int amt;
            if ((amt = this.read(b, off, len)) <= 0) {
                if (len == 0) break;
                throw this.inputException(this.noMoreInput());
            }
            if ((len -= amt) <= 0) break;
            off += amt;
        }
    }

    @Override
    public final int skipBytes(int n) throws IOException {
        return (int)this.skip(n);
    }

    @Override
    public final boolean readBoolean() throws IOException {
        return this.readUnsignedByte() != 0;
    }

    @Override
    public final byte readByte() throws IOException {
        return (byte)this.readUnsignedByte();
    }

    @Override
    public final int readUnsignedByte() throws IOException {
        int b = this.read();
        if (b < 0) {
            throw this.inputException(this.noMoreInput());
        }
        return b;
    }

    @Override
    public final short readShort() throws IOException {
        this.requireInput(2);
        int pos = this.mInPos;
        short value = cShortArrayBEHandle.get(this.mInBuffer, pos);
        this.mInPos = pos + 2;
        return value;
    }

    @Override
    public final int readUnsignedShort() throws IOException {
        return this.readShort() & 0xFFFF;
    }

    @Override
    public final char readChar() throws IOException {
        return (char)this.readShort();
    }

    @Override
    public final int readInt() throws IOException {
        this.requireInput(4);
        int pos = this.mInPos;
        int value = cIntArrayBEHandle.get(this.mInBuffer, pos);
        this.mInPos = pos + 4;
        return value;
    }

    @Override
    public final long readLong() throws IOException {
        this.requireInput(8);
        int pos = this.mInPos;
        long value = cLongArrayBEHandle.get(this.mInBuffer, pos);
        this.mInPos = pos + 8;
        return value;
    }

    @Override
    public final float readFloat() throws IOException {
        return Float.intBitsToFloat(this.readInt());
    }

    @Override
    public final double readDouble() throws IOException {
        return Double.longBitsToDouble(this.readLong());
    }

    @Override
    public final String readLine() throws IOException {
        int c;
        char[] chars = new char[32];
        int cpos = -1;
        while ((c = this.read()) >= 0 && c != 10) {
            if (c == 13) {
                c = this.read();
                if (c < 0 || c == 10) break;
                this.mInBuffer[--this.mInPos] = (byte)c;
                break;
            }
            if (++cpos >= chars.length) {
                chars = Arrays.copyOf(chars, chars.length << 1);
            }
            chars[cpos] = (char)c;
        }
        return cpos < 0 ? null : new String(chars, 0, cpos + 1);
    }

    @Override
    public final String readUTF() throws IOException {
        return this.readUTF(this.readUnsignedShort());
    }

    private String readUTF(int len) throws IOException {
        int c;
        int bpos;
        byte[] bytes;
        if (len <= 0) {
            return "";
        }
        if (len <= 8192) {
            this.requireInput(len);
            bytes = this.mInBuffer;
            bpos = this.mInPos;
            this.mInPos = bpos + len;
        } else {
            bytes = new byte[len];
            this.readFully(bytes);
            bpos = 0;
        }
        int endpos = bpos + len;
        char[] chars = new char[len];
        int cpos = 0;
        while (bpos < endpos && (c = bytes[bpos] & 0xFF) <= 127) {
            ++bpos;
            chars[cpos++] = (char)c;
        }
        block7: while (bpos < endpos) {
            c = bytes[bpos] & 0xFF;
            switch (c >> 4) {
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    ++bpos;
                    chars[cpos++] = (char)c;
                    continue block7;
                }
                case 12: 
                case 13: {
                    if ((bpos += 2) > endpos) {
                        throw this.inputException(new UTFDataFormatException());
                    }
                    byte c2 = bytes[bpos - 1];
                    if ((c2 & 0xC0) != 128) {
                        throw this.inputException(new UTFDataFormatException());
                    }
                    chars[cpos++] = (char)((c & 0x1F) << 6 | c2 & 0x3F);
                    continue block7;
                }
                case 14: {
                    if ((bpos += 3) > endpos) {
                        throw this.inputException(new UTFDataFormatException());
                    }
                    byte c2 = bytes[bpos - 2];
                    byte c3 = bytes[bpos - 1];
                    if ((c2 & 0xC0) != 128 || (c3 & 0xC0) != 128) {
                        throw this.inputException(new UTFDataFormatException());
                    }
                    chars[cpos++] = (char)((c & 0xF) << 12 | (c2 & 0x3F) << 6 | c3 & 0x3F);
                    continue block7;
                }
                case 15: {
                    if ((bpos += 4) > endpos) {
                        throw this.inputException(new UTFDataFormatException());
                    }
                    byte c2 = bytes[bpos - 3];
                    byte c3 = bytes[bpos - 2];
                    byte c4 = bytes[bpos - 1];
                    if ((c2 & 0xC0) != 128 || (c3 & 0xC0) != 128 || (c4 & 0xC0) != 128) {
                        throw this.inputException(new UTFDataFormatException());
                    }
                    int cp = (c & 7) << 18 | (c2 & 0x3F) << 12 | (c3 & 0x3F) << 6 | c4 & 0x3F;
                    if (cp >= 65536) {
                        chars[cpos++] = (char)(0xD800 | (cp -= 65536) >> 10 & 0x3FF);
                        chars[cpos++] = (char)(0xDC00 | cp & 0x3FF);
                        continue block7;
                    }
                    chars[cpos++] = (char)cp;
                    continue block7;
                }
            }
            throw this.inputException(new UTFDataFormatException());
        }
        return new String(chars, 0, cpos);
    }

    @Override
    public final Object readObject() throws IOException {
        Object simple;
        block54: while (true) {
            int typeCode = this.readUnsignedByte();
            switch (typeCode) {
                case 2: {
                    this.mInRefLookup = new ReferenceLookup();
                    continue block54;
                }
                case 3: {
                    this.mInRefLookup = null;
                    continue block54;
                }
                case 4: {
                    return this.readReference(this.readUnsignedByte());
                }
                case 5: {
                    return this.readReference(this.readInt());
                }
                case 6: {
                    simple = this.objectFor(this.readLong());
                    break block54;
                }
                case 7: {
                    simple = this.objectFor(this.readLong(), this.readLong());
                    break block54;
                }
                case 8: {
                    long id = this.readLong();
                    long typeId = this.readLong();
                    RemoteInfo info = RemoteInfo.readFrom(this);
                    simple = this.objectFor(id, typeId, info);
                    break block54;
                }
                case 10: {
                    return null;
                }
                case 11: {
                    simple = Void.TYPE;
                    break block54;
                }
                case 12: {
                    simple = new Object();
                    break block54;
                }
                case 13: {
                    simple = Boolean.TRUE;
                    break block54;
                }
                case 14: {
                    simple = Boolean.FALSE;
                    break block54;
                }
                case 15: {
                    simple = Character.valueOf(this.readChar());
                    break block54;
                }
                case 16: {
                    simple = Float.valueOf(this.readFloat());
                    break block54;
                }
                case 17: {
                    simple = this.readDouble();
                    break block54;
                }
                case 18: {
                    simple = this.readByte();
                    break block54;
                }
                case 19: {
                    simple = this.readShort();
                    break block54;
                }
                case 20: {
                    simple = this.readInt();
                    break block54;
                }
                case 21: {
                    simple = this.readLong();
                    break block54;
                }
                case 22: {
                    simple = this.readString(this.readUnsignedByte());
                    break block54;
                }
                case 23: {
                    simple = this.readString(this.readInt());
                    break block54;
                }
                case 24: {
                    simple = this.readBooleanArray(this.readUnsignedByte());
                    break block54;
                }
                case 25: {
                    simple = this.readBooleanArray(this.readInt());
                    break block54;
                }
                case 26: {
                    simple = this.readCharArray(this.readUnsignedByte());
                    break block54;
                }
                case 27: {
                    simple = this.readCharArray(this.readInt());
                    break block54;
                }
                case 28: {
                    simple = this.readFloatArray(this.readUnsignedByte());
                    break block54;
                }
                case 29: {
                    simple = this.readFloatArray(this.readInt());
                    break block54;
                }
                case 30: {
                    simple = this.readDoubleArray(this.readUnsignedByte());
                    break block54;
                }
                case 31: {
                    simple = this.readDoubleArray(this.readInt());
                    break block54;
                }
                case 32: {
                    simple = this.readByteArray(this.readUnsignedByte());
                    break block54;
                }
                case 33: {
                    simple = this.readByteArray(this.readInt());
                    break block54;
                }
                case 34: {
                    simple = this.readShortArray(this.readUnsignedByte());
                    break block54;
                }
                case 35: {
                    simple = this.readShortArray(this.readInt());
                    break block54;
                }
                case 36: {
                    simple = this.readIntArray(this.readUnsignedByte());
                    break block54;
                }
                case 37: {
                    simple = this.readIntArray(this.readInt());
                    break block54;
                }
                case 38: {
                    simple = this.readLongArray(this.readUnsignedByte());
                    break block54;
                }
                case 39: {
                    simple = this.readLongArray(this.readInt());
                    break block54;
                }
                case 40: {
                    return this.readObjectArray(this.readUnsignedByte());
                }
                case 41: {
                    return this.readObjectArray(this.readInt());
                }
                case 42: {
                    return this.readList(this.readUnsignedByte());
                }
                case 43: {
                    return this.readList(this.readInt());
                }
                case 44: {
                    return this.readSet(this.readUnsignedByte());
                }
                case 45: {
                    return this.readSet(this.readInt());
                }
                case 46: {
                    return this.readMap(this.readUnsignedByte());
                }
                case 47: {
                    return this.readMap(this.readInt());
                }
                case 48: {
                    simple = this.readBigInteger(this.readUnsignedByte());
                    break block54;
                }
                case 49: {
                    simple = this.readBigInteger(this.readInt());
                    break block54;
                }
                case 50: {
                    simple = this.readBigDecimal();
                    break block54;
                }
                case 51: {
                    return this.doReadThrowable();
                }
                case 52: {
                    return this.readStackTraceElement();
                }
                case 53: {
                    return this.mTypeCodeMap.readCustom(this, this.readUnsignedShort());
                }
                case 54: {
                    return this.mTypeCodeMap.readCustom(this, this.readInt());
                }
                default: {
                    return this.mTypeCodeMap.readCustom(this, typeCode);
                }
            }
            break;
        }
        this.stashReference(simple);
        return simple;
    }

    @Override
    public final Object readThrowable() throws IOException {
        Object obj = this.readObject();
        if (obj instanceof Throwable) {
            Throwable e = (Throwable)obj;
            CoreUtils.assignTrace(this, e);
        }
        return obj;
    }

    Object objectFor(long id) throws IOException {
        throw new NoSuchObjectException(id);
    }

    Object objectFor(long id, long typeId) throws IOException {
        throw new NoSuchObjectException(id);
    }

    Object objectFor(long id, long typeId, RemoteInfo info) throws IOException {
        throw new NoSuchObjectException(id);
    }

    private Object readReference(int identifier) throws IOException {
        ReferenceLookup refLookup = this.mInRefLookup;
        if (refLookup == null) {
            throw this.inputException(new StreamCorruptedException("References are disabled"));
        }
        try {
            Object obj = refLookup.find(identifier);
            if (obj != null) {
                return obj;
            }
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        throw this.inputException(new StreamCorruptedException("Unable to find referenced object: " + identifier));
    }

    final int reserveReference() {
        ReferenceLookup refLookup = this.mInRefLookup;
        return refLookup == null ? -1 : refLookup.reserve();
    }

    final void stashReference(int identifier, Object obj) {
        if (identifier != -1) {
            this.mInRefLookup.stash(identifier, obj);
        }
    }

    private void stashReference(Object obj) {
        ReferenceLookup refLookup = this.mInRefLookup;
        if (refLookup != null) {
            refLookup.stash(obj);
        }
    }

    private String readString(int length) throws IOException {
        int pos;
        if (length <= 0) {
            return "";
        }
        char[] chars = new char[length];
        int cpos = 0;
        block6: while (true) {
            int cstart;
            block17: {
                int c;
                this.requireInput(Math.min(length, 8192));
                byte[] buf = this.mInBuffer;
                pos = this.mInPos;
                int end = this.mInEnd;
                cstart = cpos;
                while ((c = buf[pos++] & 0xFF) <= 127) {
                    chars[cpos++] = (char)c;
                    if (cpos >= chars.length) break block6;
                    if (pos < end) continue;
                    break block17;
                }
                block8: while (true) {
                    switch (c >> 4) {
                        case 0: 
                        case 1: 
                        case 2: 
                        case 3: 
                        case 4: 
                        case 5: 
                        case 6: 
                        case 7: {
                            chars[cpos++] = (char)c;
                            break;
                        }
                        case 12: 
                        case 13: {
                            byte c2;
                            if (pos >= end) {
                                ++length;
                                break block8;
                            }
                            if (((c2 = buf[pos++]) & 0xC0) != 128) {
                                throw this.inputException(new UTFDataFormatException());
                            }
                            chars[cpos++] = (char)((c & 0x1F) << 6 | c2 & 0x3F);
                            break;
                        }
                        case 14: {
                            if (pos + 1 >= end) {
                                --pos;
                                length += 2;
                                break block8;
                            }
                            byte c2 = buf[pos++];
                            byte c3 = buf[pos++];
                            if ((c2 & 0xC0) != 128 || (c3 & 0xC0) != 128) {
                                throw this.inputException(new UTFDataFormatException());
                            }
                            chars[cpos++] = (char)((c & 0xF) << 12 | (c2 & 0x3F) << 6 | c3 & 0x3F);
                            break;
                        }
                        case 15: {
                            if (pos + 2 >= end) {
                                --pos;
                                length += 3;
                                break block8;
                            }
                            byte c2 = buf[pos++];
                            byte c3 = buf[pos++];
                            byte c4 = buf[pos++];
                            if ((c2 & 0xC0) != 128 || (c3 & 0xC0) != 128 || (c4 & 0xC0) != 128) {
                                throw this.inputException(new UTFDataFormatException());
                            }
                            int cp = (c & 7) << 18 | (c2 & 0x3F) << 12 | (c3 & 0x3F) << 6 | c4 & 0x3F;
                            if (cp >= 65536) {
                                chars[cpos++] = (char)(0xD800 | (cp -= 65536) >> 10 & 0x3FF);
                                chars[cpos++] = (char)(0xDC00 | cp & 0x3FF);
                                break;
                            }
                            chars[cpos++] = (char)cp;
                            break;
                        }
                        default: {
                            throw this.inputException(new UTFDataFormatException());
                        }
                    }
                    if (cpos >= chars.length) break block6;
                    if (pos >= end) break;
                    c = buf[pos++] & 0xFF;
                }
            }
            this.mInPos = --pos;
            length -= cpos - cstart;
        }
        this.mInPos = pos;
        return new String(chars);
    }

    private boolean[] readBooleanArray(int length) throws IOException {
        boolean[] array = new boolean[length];
        for (int i = 0; i < array.length; ++i) {
            array[i] = this.readBoolean();
        }
        return array;
    }

    private char[] readCharArray(int length) throws IOException {
        char[] array = new char[length];
        for (int i = 0; i < array.length; ++i) {
            array[i] = this.readChar();
        }
        return array;
    }

    private float[] readFloatArray(int length) throws IOException {
        float[] array = new float[length];
        for (int i = 0; i < array.length; ++i) {
            array[i] = this.readFloat();
        }
        return array;
    }

    private double[] readDoubleArray(int length) throws IOException {
        double[] array = new double[length];
        for (int i = 0; i < array.length; ++i) {
            array[i] = this.readDouble();
        }
        return array;
    }

    private byte[] readByteArray(int length) throws IOException {
        byte[] array = new byte[length];
        this.readFully(array);
        return array;
    }

    private short[] readShortArray(int length) throws IOException {
        short[] array = new short[length];
        for (int i = 0; i < array.length; ++i) {
            array[i] = this.readShort();
        }
        return array;
    }

    private int[] readIntArray(int length) throws IOException {
        int[] array = new int[length];
        for (int i = 0; i < array.length; ++i) {
            array[i] = this.readInt();
        }
        return array;
    }

    private long[] readLongArray(int length) throws IOException {
        long[] array = new long[length];
        for (int i = 0; i < array.length; ++i) {
            array[i] = this.readLong();
        }
        return array;
    }

    private Object[] readObjectArray(int length) throws IOException {
        int componentTypeCode = this.readTypeCode();
        Object[] array = switch (componentTypeCode) {
            case 6, 7, 12 -> new Object[length];
            case 13, 14 -> new Boolean[length];
            case 15 -> new Character[length];
            case 16 -> new Float[length];
            case 17 -> new Double[length];
            case 18 -> new Byte[length];
            case 19 -> new Short[length];
            case 20 -> new Integer[length];
            case 21 -> new Long[length];
            case 22, 23 -> new String[length];
            case 24, 25 -> (Object[])new boolean[length][];
            case 26, 27 -> (Object[])new char[length][];
            case 28, 29 -> (Object[])new float[length][];
            case 30, 31 -> (Object[])new double[length][];
            case 32, 33 -> (Object[])new byte[length][];
            case 34, 35 -> (Object[])new short[length][];
            case 36, 37 -> (Object[])new int[length][];
            case 38, 39 -> (Object[])new long[length][];
            case 40, 41 -> {
                componentTypeCode = this.readTypeCode();
                int extraDims = this.read();
                TypeDescriptor.OfField<Class<?>> arrayType = this.mTypeCodeMap.typeClass(componentTypeCode);
                while (--extraDims >= 0) {
                    arrayType = arrayType.arrayType();
                }
                yield (Object[])Array.newInstance(arrayType, length);
            }
            case 42, 43 -> new List[length];
            case 44, 45 -> new Set[length];
            case 46, 47 -> new Map[length];
            case 48, 49 -> new BigInteger[length];
            case 50 -> new BigDecimal[length];
            case 51 -> new Throwable[length];
            case 52 -> new StackTraceElement[length];
            default -> {
                Class<?> arrayType = this.mTypeCodeMap.typeClass(componentTypeCode);
                yield (Object[])Array.newInstance(arrayType, length);
            }
        };
        this.stashReference(array);
        for (int i = 0; i < array.length; ++i) {
            try {
                array[i] = this.readObject();
                continue;
            }
            catch (ArrayStoreException e) {
                InvalidObjectException ex = new InvalidObjectException("Malformed object array");
                ex.initCause(e);
                throw this.inputException(ex);
            }
        }
        return array;
    }

    private int readTypeCode() throws IOException {
        int typeCode = this.readUnsignedByte();
        if (typeCode == 53) {
            typeCode = this.readUnsignedShort();
        } else if (typeCode == 54) {
            typeCode = this.readInt();
        }
        return typeCode;
    }

    private List<?> readList(int length) throws IOException {
        ArrayList<Object> list = new ArrayList<Object>(length);
        this.stashReference(list);
        for (int i = 0; i < length; ++i) {
            list.add(this.readObject());
        }
        return list;
    }

    private Set<?> readSet(int length) throws IOException {
        LinkedHashSet<Object> set = new LinkedHashSet<Object>(BufferedPipe.hashCapacity(length));
        this.stashReference(set);
        for (int i = 0; i < length; ++i) {
            set.add(this.readObject());
        }
        return set;
    }

    private Map<?, ?> readMap(int length) throws IOException {
        LinkedHashMap<Object, Object> map = new LinkedHashMap<Object, Object>(BufferedPipe.hashCapacity(length >> 1));
        this.stashReference(map);
        for (int i = 0; i < length; ++i) {
            map.put(this.readObject(), this.readObject());
        }
        return map;
    }

    private static int hashCapacity(int length) {
        return (int)Math.ceil((float)length / 0.75f);
    }

    private BigInteger readBigInteger(int length) throws IOException {
        return new BigInteger(this.readByteArray(length));
    }

    private BigDecimal readBigDecimal() throws IOException {
        int scale = this.readInt();
        BigInteger unscaled = new BigInteger((byte[])this.readObject());
        return new BigDecimal(unscaled, scale);
    }

    private Throwable doReadThrowable() throws IOException {
        Throwable t;
        Throwable[] suppressed;
        Throwable cause;
        StackTraceElement[] trace;
        int identifier;
        block14: {
            int format = this.readUnsignedByte();
            if (format != 1) {
                throw this.inputException(new InvalidObjectException("Unknown format: " + format));
            }
            identifier = this.reserveReference();
            String className = (String)this.readObject();
            Object message = (String)this.readObject();
            trace = (StackTraceElement[])this.readObject();
            cause = (Throwable)this.readObject();
            suppressed = (Throwable[])this.readObject();
            try {
                Class<?> exClass = this.loadClass(className);
                if (message == null) {
                    try {
                        t = (Throwable)exClass.getConstructor(new Class[0]).newInstance(new Object[0]);
                        break block14;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                try {
                    t = (Throwable)exClass.getConstructor(String.class).newInstance(message);
                }
                catch (Exception exception) {
                    t = (Throwable)exClass.getConstructor(String.class, Throwable.class).newInstance(message, cause);
                    cause = null;
                }
            }
            catch (Exception e) {
                message = message == null ? className : className + ": " + (String)message;
                t = new Exception((String)message);
            }
        }
        this.stashReference(identifier, t);
        if (trace == null) {
            trace = new StackTraceElement[]{};
        }
        t.setStackTrace(trace);
        if (cause != null) {
            try {
                t.initCause(cause);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (suppressed != null) {
            for (Throwable s : suppressed) {
                t.addSuppressed(s);
            }
        }
        return t;
    }

    private StackTraceElement readStackTraceElement() throws IOException {
        int format = this.readUnsignedByte();
        if (format != 1) {
            throw this.inputException(new InvalidObjectException("Unknown format: " + format));
        }
        int identifier = this.reserveReference();
        String classLoaderName = (String)this.readObject();
        String moduleName = (String)this.readObject();
        String moduleVersion = (String)this.readObject();
        String declaringClass = (String)this.readObject();
        String methodName = (String)this.readObject();
        String fileName = (String)this.readObject();
        int lineNumber = this.readInt();
        StackTraceElement trace = new StackTraceElement(classLoaderName, moduleName, moduleVersion, declaringClass, methodName, fileName, lineNumber);
        this.stashReference(identifier, trace);
        return trace;
    }

    Class<?> loadClass(String name) throws ClassNotFoundException {
        return Class.forName(name);
    }

    private void requireInput(int required) throws IOException {
        int avail = this.available();
        if ((required -= avail) > 0) {
            this.requireInput(required, avail);
        }
    }

    private void requireInput(int required, int avail) throws IOException {
        byte[] buf = this.mInBuffer;
        int end = this.mInEnd;
        int tail = buf.length - end;
        if (tail < required) {
            System.arraycopy(buf, this.mInPos, buf, 0, avail);
            this.mInPos = 0;
            this.mInEnd = end = avail;
            tail = buf.length - end;
        }
        try {
            while (true) {
                if ((avail = this.doRead(buf, end, tail)) <= 0) {
                    throw this.noMoreInput();
                }
                this.mInEnd = end += avail;
                if ((required -= avail) > 0) {
                    buf = this.mInBuffer;
                    tail = buf.length - end;
                    continue;
                }
                break;
            }
        }
        catch (IOException e) {
            throw this.inputException(e);
        }
    }

    private int doRead(byte[] buf, int offset, int length) throws IOException {
        int amt = this.mSourceIn.read(buf, offset, length);
        if (amt == length && buf.length < 8192) {
            this.expandInBuffer(buf);
        }
        return amt;
    }

    private void expandInBuffer(byte[] buf) {
        try {
            int newLength = Math.min(buf.length << 1, 8192);
            this.mInBuffer = Arrays.copyOf(buf, newLength);
        }
        catch (OutOfMemoryError outOfMemoryError) {
            // empty catch block
        }
    }

    @Override
    public final void write(int b) throws IOException {
        this.requireOutput(1);
        int end = this.mOutEnd;
        this.mOutBuffer[end++] = (byte)b;
        this.mOutEnd = end;
    }

    @Override
    public final void write(byte[] b) throws IOException {
        this.write(b, 0, b.length);
    }

    @Override
    public final void write(byte[] b, int off, int len) throws IOException {
        int end;
        byte[] buf;
        block6: {
            block5: {
                int avail;
                block7: {
                    buf = this.mOutBuffer;
                    end = this.mOutEnd;
                    if (end == 0) break block5;
                    avail = buf.length - end;
                    if (len <= avail) break block6;
                    if (buf.length >= 8192) break block7;
                    avail = this.expand(end, len);
                    buf = this.mOutBuffer;
                    if (len <= avail) break block6;
                }
                System.arraycopy(b, off, buf, end, avail);
                off += avail;
                len -= avail;
                this.sourceWrite(buf, 0, buf.length);
                end = 0;
                this.mOutEnd = 0;
            }
            if (len >= 8192) {
                this.sourceWrite(b, off, len);
                return;
            }
            if (len > buf.length) {
                this.mOutBuffer = buf = new byte[CoreUtils.roundUpPower2(len)];
            }
        }
        System.arraycopy(b, off, buf, end, len);
        this.mOutEnd = end + len;
    }

    @Override
    public final void writeBoolean(boolean v) throws IOException {
        this.write(v ? 1 : 0);
    }

    @Override
    public final void writeByte(int v) throws IOException {
        this.write(v);
    }

    @Override
    public final void writeShort(int v) throws IOException {
        this.requireOutput(2);
        int end = this.mOutEnd;
        cShortArrayBEHandle.set(this.mOutBuffer, end, (short)v);
        this.mOutEnd = end + 2;
    }

    @Override
    public final void writeChar(int v) throws IOException {
        this.writeShort(v);
    }

    @Override
    public final void writeInt(int v) throws IOException {
        this.requireOutput(4);
        int end = this.mOutEnd;
        cIntArrayBEHandle.set(this.mOutBuffer, end, v);
        this.mOutEnd = end + 4;
    }

    @Override
    public final void writeLong(long v) throws IOException {
        this.requireOutput(8);
        int end = this.mOutEnd;
        cLongArrayBEHandle.set(this.mOutBuffer, end, v);
        this.mOutEnd = end + 8;
    }

    @Override
    public final void writeFloat(float v) throws IOException {
        this.writeInt(Float.floatToRawIntBits(v));
    }

    @Override
    public final void writeDouble(double v) throws IOException {
        this.writeLong(Double.doubleToRawLongBits(v));
    }

    @Override
    public final void writeBytes(String v) throws IOException {
        int len = v.length();
        for (int i = 0; i < len; ++i) {
            this.write(v.charAt(i));
        }
    }

    @Override
    public final void writeChars(String v) throws IOException {
        int len = v.length();
        for (int i = 0; i < len; ++i) {
            this.writeChar(v.charAt(i));
        }
    }

    @Override
    public final void writeUTF(String v) throws IOException {
        int strLen;
        int utfLen = strLen = v.length();
        for (int i = 0; i < strLen; ++i) {
            char c2;
            char c = v.charAt(i);
            if (c < '\u0080') continue;
            if (c <= '\u07ff') {
                ++utfLen;
                continue;
            }
            if (c >= '\ud800' && c <= '\udbff' && i + 1 < strLen && (c2 = v.charAt(i + 1)) >= '\udc00' && c2 <= '\udfff') {
                ++i;
            }
            utfLen += 2;
        }
        if (utfLen > 65535) {
            throw new UTFDataFormatException();
        }
        this.writeShort(utfLen);
        byte[] buf = this.mOutBuffer;
        int end = this.mOutEnd;
        int avail = buf.length - end;
        if (utfLen > avail && buf.length < 8192) {
            avail = this.expand(end, utfLen);
            buf = this.mOutBuffer;
        }
        int pos = 0;
        while (utfLen > avail) {
            if (avail < 100) {
                this.sourceWrite(buf, 0, end);
                end = 0;
                this.mOutEnd = 0;
                avail = buf.length;
                continue;
            }
            pos = this.encodeUTF(v, pos, pos + avail / 3);
            int newEnd = this.mOutEnd;
            utfLen -= newEnd - end;
            end = newEnd;
            avail = buf.length - end;
        }
        this.encodeUTF(v, pos, strLen);
    }

    /*
     * Unable to fully structure code
     */
    private int encodeUTF(String v, int from, int to) {
        buf = this.mOutBuffer;
        end = this.mOutEnd;
        while (from < to && (c = v.charAt(from)) < 128) {
            buf[end++] = (byte)c;
            ++from;
        }
        while (from < to) {
            block5: {
                block6: {
                    block4: {
                        c = v.charAt(from);
                        if (c >= 128) break block4;
                        buf[end++] = (byte)c;
                        break block5;
                    }
                    if (c >= 2048) break block6;
                    buf[end++] = (byte)(192 | c >> 6 & 31);
                    buf[end++] = (byte)(128 | c & 63);
                    break block5;
                }
                if (c < 55296 || c > 56319) ** GOTO lbl-1000
                if (from + 1 >= to) break;
                c2 = v.charAt(from + 1);
                if (c2 >= '\udc00' && c2 <= '\udfff') {
                    c = 65536 + ((c & 1023) << 10 | c2 & 1023);
                    ++from;
                    buf[end++] = (byte)(240 | c >> 18);
                    buf[end++] = (byte)(128 | c >> 12 & 63);
                } else lbl-1000:
                // 2 sources

                {
                    buf[end++] = (byte)(224 | c >> 12);
                }
                buf[end++] = (byte)(128 | c >> 6 & 63);
                buf[end++] = (byte)(128 | c & 63);
            }
            ++from;
        }
        this.mOutEnd = end;
        return from;
    }

    @Override
    public final void writeObject(Object v) throws IOException {
        if (v == null) {
            this.writeNull();
        } else {
            this.mTypeCodeMap.write(this, v);
        }
    }

    static IllegalArgumentException unsupported(Class<?> clazz) {
        return new IllegalArgumentException("Unsupported object type: " + clazz.getName());
    }

    void writeStub(Stub stub) throws IOException {
        throw BufferedPipe.unsupported(stub.getClass());
    }

    void writeSkeleton(Object server) throws IOException {
        throw BufferedPipe.unsupported(server.getClass());
    }

    final void writePlainObject(Object v) throws IOException {
        if (!this.tryWriteReference(v)) {
            this.write(12);
        }
    }

    final void writeBooleanObj(Boolean v) throws IOException {
        this.write(v != false ? 13 : 14);
    }

    final void writeCharObj(Character v) throws IOException {
        if (!this.tryWriteReference(v)) {
            this.requireOutput(3);
            int end = this.mOutEnd;
            byte[] buf = this.mOutBuffer;
            buf[end++] = 15;
            cShortArrayBEHandle.set(buf, end, (short)v.charValue());
            this.mOutEnd = end + 2;
        }
    }

    final void writeFloatObj(Float v) throws IOException {
        if (!this.tryWriteReference(v)) {
            this.requireOutput(5);
            int end = this.mOutEnd;
            byte[] buf = this.mOutBuffer;
            buf[end++] = 16;
            cIntArrayBEHandle.set(buf, end, Float.floatToRawIntBits(v.floatValue()));
            this.mOutEnd = end + 4;
        }
    }

    final void writeDoubleObj(Double v) throws IOException {
        if (!this.tryWriteReference(v)) {
            this.requireOutput(9);
            int end = this.mOutEnd;
            byte[] buf = this.mOutBuffer;
            buf[end++] = 17;
            cLongArrayBEHandle.set(buf, end, Double.doubleToRawLongBits(v));
            this.mOutEnd = end + 8;
        }
    }

    final void writeByteObj(Byte v) throws IOException {
        if (!this.tryWriteReference(v)) {
            this.requireOutput(2);
            int end = this.mOutEnd;
            byte[] buf = this.mOutBuffer;
            buf[end++] = 18;
            buf[end++] = v;
            this.mOutEnd = end;
        }
    }

    final void writeShortObj(Short v) throws IOException {
        if (!this.tryWriteReference(v)) {
            this.requireOutput(3);
            int end = this.mOutEnd;
            byte[] buf = this.mOutBuffer;
            buf[end++] = 19;
            cShortArrayBEHandle.set(buf, end, v);
            this.mOutEnd = end + 2;
        }
    }

    final void writeIntObj(Integer v) throws IOException {
        if (!this.tryWriteReference(v)) {
            this.requireOutput(5);
            int end = this.mOutEnd;
            byte[] buf = this.mOutBuffer;
            buf[end++] = 20;
            cIntArrayBEHandle.set(buf, end, v);
            this.mOutEnd = end + 4;
        }
    }

    final void writeLongObj(Long v) throws IOException {
        if (!this.tryWriteReference(v)) {
            this.requireOutput(9);
            int end = this.mOutEnd;
            byte[] buf = this.mOutBuffer;
            buf[end++] = 21;
            cLongArrayBEHandle.set(buf, end, v);
            this.mOutEnd = end + 8;
        }
    }

    final void writeString(String v) throws IOException {
        if (this.tryWriteReference(v)) {
            return;
        }
        int strLen = v.length();
        if (strLen < 256) {
            this.requireOutput(2 + strLen * 3);
            byte[] buf = this.mOutBuffer;
            int end = this.mOutEnd;
            buf[end++] = 22;
            buf[end++] = (byte)strLen;
            this.mOutEnd = end;
            this.encodeUTF(v, 0, strLen);
            return;
        }
        long maxLen = 5L + (long)strLen * 3L;
        byte[] buf = this.mOutBuffer;
        int end = this.mOutEnd;
        long avail = buf.length - end;
        if (maxLen > avail && buf.length < 8192) {
            this.expand(end, (int)Math.min(maxLen, 8192L));
        }
        this.requireOutput(5);
        end = this.mOutEnd;
        buf = this.mOutBuffer;
        buf[end++] = 23;
        cIntArrayBEHandle.set(buf, end, strLen);
        this.mOutEnd = end += 4;
        avail = buf.length - end;
        maxLen -= 5L;
        int pos = 0;
        while (maxLen > avail) {
            if (avail < 100L) {
                this.sourceWrite(buf, 0, end);
                end = 0;
                this.mOutEnd = 0;
                avail = buf.length;
                continue;
            }
            int chunk = (int)(avail / 3L);
            int start = pos;
            pos = this.encodeUTF(v, pos, pos + chunk);
            maxLen -= (long)(pos - start) * 3L;
            end = this.mOutEnd;
            avail = buf.length - end;
        }
        this.encodeUTF(v, pos, strLen);
    }

    final void writeBooleanA(boolean[] v) throws IOException {
        if (!this.tryWriteReference(v)) {
            this.writeVarTypeCode(24, v.length);
            for (int i = 0; i < v.length; ++i) {
                this.writeBoolean(v[i]);
            }
        }
    }

    final void writeCharA(char[] v) throws IOException {
        if (!this.tryWriteReference(v)) {
            this.writeVarTypeCode(26, v.length);
            for (int i = 0; i < v.length; ++i) {
                this.writeChar(v[i]);
            }
        }
    }

    final void writeFloatA(float[] v) throws IOException {
        if (!this.tryWriteReference(v)) {
            this.writeVarTypeCode(28, v.length);
            for (int i = 0; i < v.length; ++i) {
                this.writeFloat(v[i]);
            }
        }
    }

    final void writeDoubleA(double[] v) throws IOException {
        if (!this.tryWriteReference(v)) {
            this.writeVarTypeCode(30, v.length);
            for (int i = 0; i < v.length; ++i) {
                this.writeDouble(v[i]);
            }
        }
    }

    final void writeByteA(byte[] v) throws IOException {
        if (!this.tryWriteReference(v)) {
            this.writeVarTypeCode(32, v.length);
            this.write(v);
        }
    }

    final void writeShortA(short[] v) throws IOException {
        if (!this.tryWriteReference(v)) {
            this.writeVarTypeCode(34, v.length);
            for (int i = 0; i < v.length; ++i) {
                this.writeShort(v[i]);
            }
        }
    }

    final void writeIntA(int[] v) throws IOException {
        if (!this.tryWriteReference(v)) {
            this.writeVarTypeCode(36, v.length);
            for (int i = 0; i < v.length; ++i) {
                this.writeInt(v[i]);
            }
        }
    }

    final void writeLongA(long[] v) throws IOException {
        if (!this.tryWriteReference(v)) {
            this.writeVarTypeCode(38, v.length);
            for (int i = 0; i < v.length; ++i) {
                this.writeLong(v[i]);
            }
        }
    }

    final void writeObjectA(Object[] v) throws IOException {
        if (!this.tryWriteReference(v)) {
            this.writeVarTypeCode(40, v.length);
            Class<?> componentType = v.getClass().getComponentType();
            int componentTypeCode = this.mTypeCodeMap.writeTypeCode(this, componentType);
            if (componentTypeCode == 40) {
                int extraDims = 0;
                while (true) {
                    Class<?> subType;
                    if (!(subType = componentType.getComponentType()).isArray()) {
                        if (subType.isPrimitive()) break;
                        componentType = subType;
                        ++extraDims;
                        break;
                    }
                    componentType = subType;
                    ++extraDims;
                }
                this.mTypeCodeMap.writeTypeCode(this, componentType);
                this.write(extraDims);
            }
            for (int i = 0; i < v.length; ++i) {
                this.writeObject(v[i]);
            }
        }
    }

    final void writeList(List<?> v) throws IOException {
        if (!this.tryWriteReference(v)) {
            this.writeVarTypeCode(42, v.size());
            for (Object e : v) {
                this.writeObject(e);
            }
        }
    }

    final void writeSet(Set<?> v) throws IOException {
        if (!this.tryWriteReference(v)) {
            this.writeVarTypeCode(44, v.size());
            for (Object e : v) {
                this.writeObject(e);
            }
        }
    }

    final void writeMap(Map<?, ?> v) throws IOException {
        if (!this.tryWriteReference(v)) {
            this.writeVarTypeCode(46, v.size());
            for (Map.Entry<?, ?> e : v.entrySet()) {
                this.writeObject(e.getKey());
                this.writeObject(e.getValue());
            }
        }
    }

    final void writeBigInteger(BigInteger v) throws IOException {
        if (!this.tryWriteReference(v)) {
            byte[] bytes = v.toByteArray();
            this.writeVarTypeCode(48, bytes.length);
            this.write(bytes);
        }
    }

    final void writeBigDecimal(BigDecimal v) throws IOException {
        if (!this.tryWriteReference(v)) {
            this.requireOutput(5);
            int end = this.mOutEnd;
            byte[] buf = this.mOutBuffer;
            buf[end++] = 50;
            cIntArrayBEHandle.set(buf, end, v.scale());
            this.mOutEnd = end + 4;
            this.writeObject(v.unscaledValue().toByteArray());
        }
    }

    final void writeThrowable(Throwable v) throws IOException {
        this.enableReferences();
        try {
            if (!this.tryWriteReference(v)) {
                this.writeShort(13057);
                this.writeObject(v.getClass().getName());
                this.writeObject(v.getMessage());
                this.writeObject(v.getStackTrace());
                this.writeObject(v.getCause());
                this.writeObject(v.getSuppressed());
            }
        }
        finally {
            this.disableReferences();
        }
    }

    final void writeStackTraceElement(StackTraceElement v) throws IOException {
        this.enableReferences();
        try {
            if (!this.tryWriteReference(v)) {
                this.writeShort(13313);
                this.writeObject(v.getClassLoaderName());
                this.writeObject(v.getModuleName());
                this.writeObject(v.getModuleVersion());
                this.writeObject(v.getClassName());
                this.writeObject(v.getMethodName());
                this.writeObject(v.getFileName());
                this.writeInt(v.getLineNumber());
            }
        }
        finally {
            this.disableReferences();
        }
    }

    private void writeVarTypeCode(int typeCode, int value) throws IOException {
        if ((value & 0xFFFFFF00) == 0) {
            this.requireOutput(2);
            int end = this.mOutEnd;
            byte[] buf = this.mOutBuffer;
            buf[end++] = (byte)typeCode;
            buf[end++] = (byte)value;
            this.mOutEnd = end;
        } else {
            this.requireOutput(5);
            int end = this.mOutEnd;
            byte[] buf = this.mOutBuffer;
            buf[end++] = (byte)(typeCode + 1);
            cIntArrayBEHandle.set(buf, end, value);
            this.mOutEnd = end + 4;
        }
    }

    @Override
    public final void writeNull() throws IOException {
        ReferenceMap refMap = this.mOutRefMap;
        if (refMap == null || !refMap.isDisabled()) {
            this.write(10);
        } else {
            this.writeShort(778);
            this.mOutRefMap = null;
        }
    }

    @Override
    public final long transferTo(OutputStream out, long n) throws IOException {
        if (n <= 0L) {
            return 0L;
        }
        int avail = this.available();
        if (avail <= 0) {
            avail = this.doRead(this.mInBuffer, 0, this.mInBuffer.length);
            if (avail <= 0) {
                return 0L;
            }
            this.mInPos = 0;
            this.mInEnd = avail;
        }
        long total = 0L;
        while (true) {
            int len = (int)Math.min((long)avail, n);
            out.write(this.mInBuffer, this.mInPos, len);
            this.mInPos += len;
            total += (long)len;
            if ((n -= (long)len) <= 0L) {
                return total;
            }
            avail = this.doRead(this.mInBuffer, 0, this.mInBuffer.length);
            if (avail <= 0) {
                return total;
            }
            this.mInPos = 0;
            this.mInEnd = avail;
        }
    }

    private boolean tryWriteReference(Object v) throws IOException {
        ReferenceMap refMap = this.mOutRefMap;
        if (refMap == null) {
            return false;
        }
        return this.tryWriteReference(refMap, v);
    }

    private boolean tryWriteReference(ReferenceMap refMap, Object v) throws IOException {
        int identifier;
        if (refMap.isDisabled()) {
            this.write(3);
            this.mOutRefMap = null;
            return false;
        }
        if (refMap.isEmpty()) {
            this.write(2);
        }
        if ((identifier = refMap.add(v)) < 0) {
            return false;
        }
        this.writeVarTypeCode(4, identifier);
        return true;
    }

    @Override
    public final SocketAddress localAddress() {
        return this.mLocalAddress;
    }

    @Override
    public final SocketAddress remoteAddress() {
        return this.mRemoteAddress;
    }

    @Override
    public final void enableReferences() {
        ReferenceMap refMap = this.mOutRefMap;
        if (refMap == null) {
            this.mOutRefMap = new ReferenceMap();
        } else {
            refMap.enable();
        }
    }

    @Override
    public final boolean disableReferences() {
        ReferenceMap refMap = this.mOutRefMap;
        if (refMap == null) {
            throw new IllegalStateException("Not enabled");
        }
        return refMap.disable() == 0;
    }

    @Override
    public final InputStream inputStream() {
        In in = this.mIn;
        if (in == null) {
            this.mIn = in = new In();
        }
        return in;
    }

    @Override
    public final OutputStream outputStream() {
        Out out = this.mOut;
        if (out == null) {
            this.mOut = out = new Out();
        }
        return out;
    }

    @Override
    public final void flush() throws IOException {
        if (this.mOutEnd != 0) {
            this.sourceWrite(this.mOutBuffer, 0, this.mOutEnd);
            this.mOutEnd = 0;
        }
    }

    final void requireOutput(int required) throws IOException {
        int avail = this.mOutBuffer.length - this.mOutEnd;
        if (avail < required) {
            this.expandOrFlush(required);
        }
    }

    private void expandOrFlush(int required) throws IOException {
        byte[] buf = this.mOutBuffer;
        int end = this.mOutEnd;
        if (end + required <= 8192) {
            this.expand(end, required);
        } else {
            this.sourceWrite(buf, 0, end);
            this.mOutEnd = 0;
        }
    }

    private int expand(int end, int amount) {
        int length = end + amount;
        length = length < 0 ? 8192 : Math.min(CoreUtils.roundUpPower2(length), 8192);
        this.mOutBuffer = Arrays.copyOf(this.mOutBuffer, length);
        return length - end;
    }

    private void sourceWrite(byte[] b, int off, int len) throws IOException {
        try {
            OutputStream out = this.mSourceOut;
            out.write(b, off, len);
            out.flush();
        }
        catch (IOException e) {
            throw this.outputException(e);
        }
    }

    final void tryRecycle() {
        if (this.mOutEnd != 0) {
            throw new IllegalStateException("Pipe has unflushed output");
        }
        this.mInRefLookup = null;
        this.mOutRefMap = null;
    }

    @Override
    public void recycle() throws IOException {
        this.close();
    }

    @Override
    public final void close() throws IOException {
        this.close(null);
    }

    void close(IOException ex) throws IOException {
        try {
            this.mSourceOut.close();
        }
        catch (IOException e) {
            ex = BufferedPipe.merge(ex, e);
        }
        try {
            this.mSourceIn.close();
        }
        catch (IOException e) {
            ex = BufferedPipe.merge(ex, e);
        }
        if (ex != null) {
            throw ex;
        }
    }

    public final String toString() {
        return "Pipe@" + Integer.toHexString(System.identityHashCode(this)) + "{localAddress=" + this.localAddress() + ", remoteAddress=" + this.remoteAddress() + "}";
    }

    private ClosedException noMoreInput() {
        ClosedException e = new ClosedException("Pipe is closed by remote endpoint");
        e.remoteAddress(this.remoteAddress());
        return e;
    }

    private IOException inputException(IOException ex) throws IOException {
        this.mInPos = 0;
        this.mInEnd = 0;
        this.close(ex);
        throw ex;
    }

    private IOException outputException(IOException ex) throws IOException {
        this.close(ex);
        throw ex;
    }

    private void closeInput() throws IOException {
        this.mInPos = 0;
        this.mInEnd = 0;
        this.close();
    }

    private void closeOutput() throws IOException {
        try {
            this.flush();
        }
        catch (IOException e) {
            this.close(e);
        }
        this.close();
    }

    static <E extends Throwable> E merge(E e1, E e2) {
        if (e1 == null) {
            return e2;
        }
        e1.addSuppressed(e2);
        return e1;
    }

    static {
        try {
            cShortArrayBEHandle = MethodHandles.byteArrayViewVarHandle(short[].class, ByteOrder.BIG_ENDIAN);
            cIntArrayBEHandle = MethodHandles.byteArrayViewVarHandle(int[].class, ByteOrder.BIG_ENDIAN);
            cLongArrayBEHandle = MethodHandles.byteArrayViewVarHandle(long[].class, ByteOrder.BIG_ENDIAN);
        }
        catch (Exception e) {
            throw CoreUtils.rethrow(e);
        }
    }

    private final class In
    extends InputStream
    implements ObjectInput {
        private In() {
        }

        @Override
        public int read() throws IOException {
            return BufferedPipe.this.read();
        }

        @Override
        public int read(byte[] b, int off, int len) throws IOException {
            return BufferedPipe.this.read(b, off, len);
        }

        @Override
        public long skip(long n) throws IOException {
            return BufferedPipe.this.skip(n);
        }

        @Override
        public int available() {
            return BufferedPipe.this.available();
        }

        @Override
        public void readFully(byte[] b) throws IOException {
            BufferedPipe.this.readFully(b);
        }

        @Override
        public void readFully(byte[] b, int off, int len) throws IOException {
            BufferedPipe.this.readFully(b, off, len);
        }

        @Override
        public int skipBytes(int n) throws IOException {
            return BufferedPipe.this.skipBytes(n);
        }

        @Override
        public boolean readBoolean() throws IOException {
            return BufferedPipe.this.readBoolean();
        }

        @Override
        public byte readByte() throws IOException {
            return BufferedPipe.this.readByte();
        }

        @Override
        public int readUnsignedByte() throws IOException {
            return BufferedPipe.this.readUnsignedByte();
        }

        @Override
        public short readShort() throws IOException {
            return BufferedPipe.this.readShort();
        }

        @Override
        public int readUnsignedShort() throws IOException {
            return BufferedPipe.this.readUnsignedShort();
        }

        @Override
        public char readChar() throws IOException {
            return BufferedPipe.this.readChar();
        }

        @Override
        public int readInt() throws IOException {
            return BufferedPipe.this.readInt();
        }

        @Override
        public long readLong() throws IOException {
            return BufferedPipe.this.readLong();
        }

        @Override
        public float readFloat() throws IOException {
            return BufferedPipe.this.readFloat();
        }

        @Override
        public double readDouble() throws IOException {
            return BufferedPipe.this.readDouble();
        }

        @Override
        public String readLine() throws IOException {
            return BufferedPipe.this.readLine();
        }

        @Override
        public String readUTF() throws IOException {
            return BufferedPipe.this.readUTF();
        }

        @Override
        public Object readObject() throws IOException {
            return BufferedPipe.this.readObject();
        }

        @Override
        public void close() throws IOException {
            BufferedPipe.this.closeInput();
        }
    }

    private final class Out
    extends OutputStream
    implements ObjectOutput {
        private Out() {
        }

        @Override
        public void write(int b) throws IOException {
            BufferedPipe.this.write(b);
        }

        @Override
        public void write(byte[] b, int off, int len) throws IOException {
            BufferedPipe.this.write(b, off, len);
        }

        @Override
        public void writeBoolean(boolean v) throws IOException {
            BufferedPipe.this.writeBoolean(v);
        }

        @Override
        public void writeByte(int v) throws IOException {
            BufferedPipe.this.writeByte(v);
        }

        @Override
        public void writeShort(int v) throws IOException {
            BufferedPipe.this.writeShort(v);
        }

        @Override
        public void writeChar(int v) throws IOException {
            BufferedPipe.this.writeChar(v);
        }

        @Override
        public void writeInt(int v) throws IOException {
            BufferedPipe.this.writeInt(v);
        }

        @Override
        public void writeLong(long v) throws IOException {
            BufferedPipe.this.writeLong(v);
        }

        @Override
        public void writeFloat(float v) throws IOException {
            BufferedPipe.this.writeFloat(v);
        }

        @Override
        public void writeDouble(double v) throws IOException {
            BufferedPipe.this.writeDouble(v);
        }

        @Override
        public void writeBytes(String s) throws IOException {
            BufferedPipe.this.writeBytes(s);
        }

        @Override
        public void writeChars(String s) throws IOException {
            BufferedPipe.this.writeChars(s);
        }

        @Override
        public void writeUTF(String s) throws IOException {
            BufferedPipe.this.writeUTF(s);
        }

        @Override
        public void writeObject(Object obj) throws IOException {
            BufferedPipe.this.writeObject(obj);
        }

        @Override
        public void flush() throws IOException {
            BufferedPipe.this.flush();
        }

        @Override
        public void close() throws IOException {
            BufferedPipe.this.closeOutput();
        }
    }
}

