/*
 * Decompiled with CFR 0.152.
 */
package org.cojen.dirmi.core;

import java.lang.invoke.VarHandle;
import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;

final class CanonicalSet<V>
extends ReferenceQueue<Object> {
    private Entry<V>[] mEntries = new Entry[2];
    private int mSize;

    public synchronized int size() {
        return this.mSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public V add(V value) {
        Reference ref = this.poll();
        if (ref != null) {
            this.cleanup(ref);
        }
        int hash = value.hashCode();
        Entry<V>[] entries = this.mEntries;
        Entry<V> e = entries[hash & entries.length - 1];
        while (e != null) {
            Object v = e.get();
            if (value.equals(v)) {
                return (V)v;
            }
            e = e.mNext;
        }
        CanonicalSet canonicalSet = this;
        synchronized (canonicalSet) {
            entries = this.mEntries;
            int slot = hash & entries.length - 1;
            Entry<V> e2 = entries[slot];
            while (e2 != null) {
                Object v = e2.get();
                if (value.equals(v)) {
                    return (V)v;
                }
                e2 = e2.mNext;
            }
            int size = this.mSize;
            if (size + (size >> 1) >= entries.length && entries.length < 0x40000000) {
                Entry[] newEntries = new Entry[entries.length << 1];
                for (int i = 0; i < entries.length; ++i) {
                    Entry<V> e3 = entries[i];
                    while (e3 != null) {
                        Entry next = e3.mNext;
                        slot = e3.mHash & newEntries.length - 1;
                        e3.mNext = newEntries[slot];
                        newEntries[slot] = e3;
                        e3 = next;
                    }
                }
                entries = newEntries;
                this.mEntries = newEntries;
                slot = hash & entries.length - 1;
            }
            Entry<V> newEntry = new Entry<V>(value, hash, this);
            newEntry.mNext = entries[slot];
            VarHandle.storeStoreFence();
            entries[slot] = newEntry;
            ++this.mSize;
            return value;
        }
    }

    private synchronized void cleanup(Object ref) {
        Entry<V>[] entries = this.mEntries;
        block0: do {
            Entry cleared = (Entry)ref;
            int ix = cleared.mHash & entries.length - 1;
            Entry<V> e = entries[ix];
            Entry<V> prev = null;
            while (e != null) {
                if (e == cleared) {
                    if (prev == null) {
                        entries[ix] = e.mNext;
                    } else {
                        prev.mNext = e.mNext;
                    }
                    --this.mSize;
                    continue block0;
                }
                prev = e;
                e = e.mNext;
            }
        } while ((ref = this.poll()) != null);
    }

    private static final class Entry<V>
    extends WeakReference<V> {
        final int mHash;
        Entry<V> mNext;

        Entry(V value, int hash, CanonicalSet<V> set) {
            super(value, set);
            this.mHash = hash;
        }
    }
}

