/*
 * Decompiled with CFR 0.152.
 */
package org.cojen.dirmi.core;

import org.cojen.dirmi.ClassResolver;
import org.cojen.dirmi.core.SoftCache;

public final class ClassLoaderResolver
implements ClassResolver {
    private final ClassLoader mLoader;
    private final SoftCache<String, Class<?>> mCache;

    public ClassLoaderResolver(ClassLoader loader) {
        this.mLoader = loader;
        this.mCache = new SoftCache();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Class<?> resolveClass(String name) throws ClassNotFoundException {
        Class<?> clazz = this.mCache.get(name);
        if (clazz != null) {
            return clazz;
        }
        SoftCache<String, Class<?>> softCache = this.mCache;
        synchronized (softCache) {
            clazz = this.mCache.get(name);
            if (clazz != null) {
                return clazz;
            }
        }
        clazz = Class.forName(name, false, this.mLoader);
        softCache = this.mCache;
        synchronized (softCache) {
            Class<?> existing = this.mCache.get(name);
            if (existing != null) {
                return existing;
            }
            this.mCache.put(name, clazz);
            return clazz;
        }
    }
}

