/*
 * Decompiled with CFR 0.152.
 */
package org.cojen.dirmi.core;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import java.net.SocketAddress;
import java.util.HashMap;
import java.util.Map;
import org.cojen.dirmi.Pipe;
import org.cojen.dirmi.RemoteException;
import org.cojen.dirmi.Session;
import org.cojen.dirmi.core.CloseTimeout;
import org.cojen.dirmi.core.CorePipe;
import org.cojen.dirmi.core.CoreSession;
import org.cojen.dirmi.core.CoreStubSupport;
import org.cojen.dirmi.core.CoreUtils;
import org.cojen.dirmi.core.DisposedStubSupport;
import org.cojen.dirmi.core.Engine;
import org.cojen.dirmi.core.MethodIdWriter;
import org.cojen.dirmi.core.MethodIdWriterMaker;
import org.cojen.dirmi.core.RemoteExaminer;
import org.cojen.dirmi.core.RemoteInfo;
import org.cojen.dirmi.core.RestorableStubSupport;
import org.cojen.dirmi.core.Settings;
import org.cojen.dirmi.core.Stub;
import org.cojen.dirmi.core.StubFactory;
import org.cojen.dirmi.core.StubMaker;
import org.cojen.dirmi.core.WaitMap;

final class ClientSession<R>
extends CoreSession<R> {
    private static final VarHandle cServerSessionIdHandle;
    private long mServerSessionId;
    private Class<R> mRootType;
    private byte[] mRootName;
    private RemoteInfo mServerRootInfo;
    private R mRoot;

    ClientSession(Engine engine, Settings settings, SocketAddress localAddr, SocketAddress remoteAttr) {
        super(engine, settings);
        this.mState = Session.State.CONNECTED;
        this.controlPipe(CorePipe.newNullPipe(localAddr, remoteAttr));
    }

    void writeHeader(Pipe pipe, long serverSessionId) throws IOException {
        pipe.writeLong(4052788960387224692L);
        pipe.writeLong(this.id);
        pipe.writeLong(serverSessionId);
    }

    void init(long serverId, Class<R> rootType, byte[] bname, long rootTypeId, RemoteInfo rootInfo, long rootId) {
        cServerSessionIdHandle.setRelease(this, serverId);
        this.mRootType = rootType;
        this.mRootName = bname;
        this.mServerRootInfo = rootInfo;
        StubFactory factory = StubMaker.factoryFor(rootType, rootTypeId, rootInfo);
        factory = this.mStubFactories.putIfAbsent(factory);
        this.mStubFactoriesByClass.putIfAbsent(rootType, factory);
        Stub root = factory.newStub(rootId, this.stubSupport());
        this.mStubs.put(root);
        this.mRoot = root;
        Stub.setRootOrigin(root);
    }

    @Override
    boolean close(int reason, CorePipe controlPipe) {
        if (this.mSettings.reconnectDelayMillis < 0 || this.mEngine.isClosed() || this.isClosed() || this.isRootDisposed()) {
            reason |= 1;
        }
        if ((reason & 1) != 0) {
            boolean justClosed = super.close(reason, null);
            this.mEngine.removeSession(this);
            return justClosed;
        }
        boolean justClosed = super.close(reason |= 2, controlPipe);
        if (!justClosed) {
            return false;
        }
        this.mEngine.reconnect(this.mSettings, this.mRootType, this.mRootName, this.remoteAddress(), this::reconnectAttempt);
        this.casStateAndNotify(Session.State.DISCONNECTED, Session.State.RECONNECTING);
        return true;
    }

    private boolean isRootDisposed() {
        Stub stub;
        R r = this.mRoot;
        return r instanceof Stub && Stub.cSupportHandle.getAcquire(stub = (Stub)r) instanceof DisposedStubSupport;
    }

    private boolean reconnectAttempt(Object result) {
        Map typeMap;
        if (this.mEngine.isClosed() || this.isClosed()) {
            if (result instanceof ClientSession) {
                ((ClientSession)result).close(1, null);
            }
            this.close(1, null);
            return false;
        }
        if (result instanceof Throwable) {
            Throwable ex = (Throwable)result;
            this.reconnectFailureNotify(ex);
            return result instanceof IOException;
        }
        ClientSession newSession = (ClientSession)result;
        newSession.initTypeCodeMap(newSession.mTypeCodeMap);
        this.moveConnectionsFrom(newSession);
        this.mEngine.changeIdentity(this, newSession.id);
        Stub newRoot = (Stub)newSession.mRoot;
        Stub removed = newSession.mStubs.remove(newRoot);
        assert (newRoot == removed);
        assert (newSession.mStubs.size() == 0);
        this.mStubFactories.moveAll(newSession.mStubFactories);
        this.mStubFactoriesByClass.putAll(newSession.mStubFactoriesByClass);
        newSession.mStubFactoriesByClass.clear();
        CoreStubSupport newSupport = new CoreStubSupport(this);
        this.stubSupport(newSupport);
        cServerSessionIdHandle.setRelease(this, newSession.mServerSessionId);
        Stub root = (Stub)this.mRoot;
        this.mStubs.changeIdentity(root, newRoot.id);
        try {
            WaitMap<String, RemoteInfo> waitMap;
            this.startTasks();
            RemoteInfo newServerRootInfo = newSession.mServerRootInfo;
            this.mTypeWaitMap = waitMap = new WaitMap<String, RemoteInfo>();
            waitMap.put(RemoteExaminer.remoteType(root).getName(), newServerRootInfo);
            this.mStubs.forEach(stub -> {
                Class<?> type;
                if (stub.isRestorable() && waitMap.add((type = RemoteExaminer.remoteType(stub)).getName())) {
                    try {
                        this.sendInfoRequest(type);
                    }
                    catch (IOException e) {
                        throw CoreUtils.rethrow(e);
                    }
                }
            });
            this.sendInfoRequestTerminator();
            typeMap = waitMap.await();
            this.mTypeWaitMap = null;
            this.flushControlPipe();
        }
        catch (IOException | InterruptedException e) {
            this.close(2, null);
            return false;
        }
        Stub.cSupportHandle.setRelease(this.mRoot, newSupport);
        HashMap writers = new HashMap();
        RestorableStubSupport restorableSupport = new RestorableStubSupport(newSupport);
        this.mStubs.forEach(stub -> {
            if (!stub.isRestorable() && stub != this.mRoot) {
                return;
            }
            RemoteInfo original = RemoteInfo.examineStub(stub);
            MethodIdWriter writer = (MethodIdWriter)writers.get(original);
            Class<?> type = null;
            if (writer == null && !writers.containsKey(original)) {
                type = RemoteExaminer.remoteType(stub);
                RemoteInfo current = (RemoteInfo)typeMap.get(type.getName());
                writer = current == null ? MethodIdWriter.Unimplemented.THE : MethodIdWriterMaker.writerFor(original, current, false);
                writers.put(original, writer);
            }
            if (writer != null) {
                Stub.cWriterHandle.setRelease((Stub)stub, writer);
            } else {
                StubFactory factory;
                if (type == null) {
                    type = RemoteExaminer.remoteType(stub);
                }
                if ((factory = (StubFactory)this.mStubFactoriesByClass.get(type)) != null) {
                    Stub.cWriterHandle.setRelease((Stub)stub, factory);
                }
            }
            if (stub != this.mRoot) {
                Stub.cSupportHandle.setRelease((Stub)stub, restorableSupport);
            }
        });
        this.unclose();
        return false;
    }

    @Override
    public R root() {
        return this.mRoot;
    }

    @Override
    public void connected(SocketAddress localAddr, SocketAddress remoteAttr, InputStream in, OutputStream out) throws IOException {
        CorePipe pipe = new CorePipe(localAddr, remoteAttr, in, out, 1);
        pipe.initTypeCodeMap(this.mTypeCodeMap);
        long serverSessionId = cServerSessionIdHandle.getAcquire(this);
        long cid = 0L;
        if (serverSessionId != 0L) {
            int timeoutMillis = this.mSettings.pingTimeoutMillis;
            CloseTimeout timeoutTask = timeoutMillis < 0 ? null : new CloseTimeout(pipe);
            try {
                if (timeoutTask != null) {
                    this.mEngine.scheduleMillis(timeoutTask, timeoutMillis);
                }
                this.writeHeader(pipe, serverSessionId);
                pipe.flush();
                long version = pipe.readLong();
                if (version != 4052788960387224692L) {
                    throw new RemoteException("Unsupported protocol");
                }
                cid = pipe.readLong();
                if (cid == 0L) {
                    throw new RemoteException("Unsupported protocol");
                }
                long sid = pipe.readLong();
                if (sid != serverSessionId) {
                    if (sid != 0L) {
                        throw new RemoteException("Unsupported protocol");
                    }
                    Object message = pipe.readObject();
                    throw new RemoteException(String.valueOf(message));
                }
                CloseTimeout.cancelOrFail(timeoutTask);
            }
            catch (Throwable e) {
                if (timeoutTask != null) {
                    timeoutTask.cancel();
                }
                CoreUtils.closeQuietly(pipe);
                if (e instanceof RemoteException) {
                    RemoteException re = (RemoteException)e;
                    re.remoteAddress(this.remoteAddress());
                }
                throw e;
            }
        }
        this.registerNewAvailableConnection(pipe, cid);
    }

    @Override
    void startTasks() throws IOException {
        this.mServerRootInfo = null;
        super.startTasks();
    }

    @Override
    CorePipe connect() throws IOException {
        CorePipe pipe;
        while ((pipe = this.tryObtainConnection()) == null) {
            this.mEngine.checkClosed().connect(this);
        }
        return pipe;
    }

    @Override
    void reverseConnect(long id) {
        block2: {
            try {
                CorePipe pipe = this.connect();
                pipe.writeLong(id);
                pipe.flush();
                pipe.mMode = 2;
                this.recycleConnection(pipe);
            }
            catch (IOException e) {
                if (this.isClosedOrDisconnected()) break block2;
                this.uncaught(e);
            }
        }
    }

    static {
        try {
            MethodHandles.Lookup lookup = MethodHandles.lookup();
            cServerSessionIdHandle = lookup.findVarHandle(ClientSession.class, "mServerSessionId", Long.TYPE);
        }
        catch (Throwable e) {
            throw CoreUtils.rethrow(e);
        }
    }
}

