/*
 * Decompiled with CFR 0.152.
 */
package org.cojen.dirmi.core;

import java.io.Closeable;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import org.cojen.dirmi.RemoteException;
import org.cojen.dirmi.core.CoreUtils;
import org.cojen.dirmi.core.Scheduled;

final class CloseTimeout
extends Scheduled {
    private static final VarHandle cConHandle;
    private volatile Closeable mCon;

    CloseTimeout(Closeable c) {
        this.mCon = c;
    }

    boolean cancel() {
        Closeable con = this.mCon;
        return con != null && cConHandle.compareAndSet(this, con, null);
    }

    static void cancelOrFail(CloseTimeout task) throws RemoteException {
        if (task != null && !task.cancel()) {
            throw new RemoteException("Timed out");
        }
    }

    @Override
    public void run() {
        Closeable con = this.mCon;
        if (con != null && cConHandle.compareAndSet(this, con, null)) {
            CoreUtils.closeQuietly(con);
        }
    }

    static {
        try {
            MethodHandles.Lookup lookup = MethodHandles.lookup();
            cConHandle = lookup.findVarHandle(CloseTimeout.class, "mCon", Closeable.class);
        }
        catch (Throwable e) {
            throw CoreUtils.rethrow(e);
        }
    }
}

