/*
 * Decompiled with CFR 0.152.
 */
package org.cojen.dirmi.core;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectStreamClass;
import java.io.OutputStream;
import org.cojen.dirmi.Pipe;
import org.cojen.dirmi.core.BufferedPipe;
import org.cojen.dirmi.core.CorePipe;
import org.cojen.dirmi.core.MarshalledSkeleton;
import org.cojen.dirmi.core.MarshalledStub;
import org.cojen.dirmi.core.RemoteInfo;

public final class CoreObjectInputStream
extends ObjectInputStream {
    private final CorePipe mPipe;

    public CoreObjectInputStream(Pipe pipe) throws IOException {
        this((CorePipe)pipe);
    }

    CoreObjectInputStream(CorePipe pipe) throws IOException {
        super(pipe.inputStream());
        this.enableResolveObject(true);
        this.mPipe = pipe;
    }

    @Override
    protected Class<?> resolveClass(ObjectStreamClass desc) throws IOException, ClassNotFoundException {
        return this.mPipe.mSession.resolveClass(desc.getName());
    }

    @Override
    protected Object resolveObject(Object obj) throws IOException {
        if (obj instanceof MarshalledStub) {
            return this.mPipe.objectFor(((MarshalledStub)obj).id);
        }
        if (obj instanceof MarshalledSkeleton) {
            MarshalledSkeleton ms = (MarshalledSkeleton)obj;
            byte[] infoBytes = ms.infoBytes;
            if (infoBytes == null) {
                return this.mPipe.objectFor(ms.id, ms.typeId);
            }
            ByteArrayInputStream bin = new ByteArrayInputStream(infoBytes);
            BufferedPipe pipe = new BufferedPipe(bin, OutputStream.nullOutputStream());
            RemoteInfo info = RemoteInfo.readFrom(pipe);
            return this.mPipe.objectFor(ms.id, ms.typeId, info);
        }
        return obj;
    }
}

