/*
 * Decompiled with CFR 0.152.
 */
package org.cojen.dirmi.core;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.SocketAddress;
import org.cojen.dirmi.Pipe;
import org.cojen.dirmi.core.BufferedPipe;
import org.cojen.dirmi.core.CoreSession;
import org.cojen.dirmi.core.RemoteInfo;
import org.cojen.dirmi.core.Skeleton;
import org.cojen.dirmi.core.Stub;

final class CorePipe
extends BufferedPipe {
    static final int M_CLIENT = 1;
    static final int M_SERVER = 2;
    static final int M_CLOSED = 3;
    private static final boolean RECYCLE_CLOSE = Boolean.getBoolean(Pipe.class.getName() + ".RECYCLE_CLOSE");
    CoreSession<?> mSession;
    CorePipe mConPrev;
    CorePipe mConNext;
    int mClock;
    int mMode;

    static CorePipe newNullPipe(SocketAddress localAddr, SocketAddress remoteAttr) {
        return new CorePipe(localAddr, remoteAttr, InputStream.nullInputStream(), OutputStream.nullOutputStream(), 3);
    }

    CorePipe(SocketAddress localAddr, SocketAddress remoteAttr, InputStream in, OutputStream out, int mode) {
        super(localAddr, remoteAttr, in, out);
        this.mMode = mode;
    }

    @Override
    Object objectFor(long id) throws IOException {
        return this.mSession.objectFor(id);
    }

    @Override
    Object objectFor(long id, long typeId) throws IOException {
        return this.mSession.objectFor(id, typeId);
    }

    @Override
    Object objectFor(long id, long typeId, RemoteInfo info) {
        return this.mSession.objectFor(id, typeId, info);
    }

    @Override
    Class<?> loadClass(String name) throws ClassNotFoundException {
        return this.mSession.loadClass(name);
    }

    @Override
    void writeStub(Stub stub) throws IOException {
        this.requireOutput(9);
        int end = this.mOutEnd;
        byte[] buf = this.mOutBuffer;
        buf[end++] = 6;
        cLongArrayBEHandle.set(buf, end, stub.id);
        this.mOutEnd = end + 8;
    }

    @Override
    void writeSkeleton(Object server) throws IOException {
        this.mSession.writeSkeleton(this, server);
    }

    void writeSkeletonHeader(byte typeCode, Skeleton skeleton) throws IOException {
        this.requireOutput(17);
        int end = this.mOutEnd;
        byte[] buf = this.mOutBuffer;
        buf[end++] = typeCode;
        cLongArrayBEHandle.set(buf, end, skeleton.id);
        cLongArrayBEHandle.set(buf, end + 8, skeleton.typeId());
        this.mOutEnd = end + 16;
    }

    @Override
    public void recycle() throws IOException {
        if (RECYCLE_CLOSE && this.mMode == 1) {
            this.close();
            return;
        }
        try {
            if (this.mMode == 1 && this.available() != 0) {
                throw new IllegalStateException("Pipe has pending input");
            }
            this.tryRecycle();
        }
        catch (IllegalStateException e) {
            try {
                this.close();
            }
            catch (Exception e2) {
                e.addSuppressed(e2);
            }
            throw e;
        }
        CoreSession<?> session = this.mSession;
        if (session != null) {
            session.recycleConnection(this);
        } else {
            this.close();
        }
    }

    @Override
    void close(IOException ex) throws IOException {
        CoreSession<?> session = this.mSession;
        if (session == null) {
            super.close(ex);
        } else {
            session.closeConnection(this);
            if (ex != null) {
                try {
                    session.checkClosed();
                }
                catch (IOException e2) {
                    e2.addSuppressed(ex);
                    throw e2;
                }
            }
        }
    }

    void doClose() {
        try {
            super.close(null);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

