/*
 * Decompiled with CFR 0.152.
 */
package org.cojen.dirmi.core;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectStreamException;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import java.lang.ref.WeakReference;
import java.net.SocketAddress;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.BiConsumer;
import java.util.function.BiPredicate;
import org.cojen.dirmi.ClassResolver;
import org.cojen.dirmi.ClosedException;
import org.cojen.dirmi.DisconnectedException;
import org.cojen.dirmi.NoSuchObjectException;
import org.cojen.dirmi.Remote;
import org.cojen.dirmi.RemoteException;
import org.cojen.dirmi.Session;
import org.cojen.dirmi.SessionAware;
import org.cojen.dirmi.core.BufferedPipe;
import org.cojen.dirmi.core.CorePipe;
import org.cojen.dirmi.core.CoreSkeletonSupport;
import org.cojen.dirmi.core.CoreStubSupport;
import org.cojen.dirmi.core.CoreUtils;
import org.cojen.dirmi.core.DisposedStubSupport;
import org.cojen.dirmi.core.Engine;
import org.cojen.dirmi.core.IdGenerator;
import org.cojen.dirmi.core.Item;
import org.cojen.dirmi.core.ItemMap;
import org.cojen.dirmi.core.MarshalledSkeleton;
import org.cojen.dirmi.core.RemoteExaminer;
import org.cojen.dirmi.core.RemoteInfo;
import org.cojen.dirmi.core.Scheduled;
import org.cojen.dirmi.core.Settings;
import org.cojen.dirmi.core.Skeleton;
import org.cojen.dirmi.core.SkeletonFactory;
import org.cojen.dirmi.core.SkeletonMaker;
import org.cojen.dirmi.core.SkeletonMap;
import org.cojen.dirmi.core.Stub;
import org.cojen.dirmi.core.StubFactory;
import org.cojen.dirmi.core.StubMaker;
import org.cojen.dirmi.core.StubSupport;
import org.cojen.dirmi.core.TypeCodeMap;
import org.cojen.dirmi.core.UncaughtException;
import org.cojen.dirmi.core.WaitMap;
import org.cojen.dirmi.io.CaptureOutputStream;

abstract class CoreSession<R>
extends Item
implements Session<R> {
    static final int C_PING = 1;
    static final int C_PONG = 2;
    static final int C_MESSAGE = 3;
    static final int C_KNOWN_TYPE = 4;
    static final int C_REQUEST_CONNECTION = 5;
    static final int C_REQUEST_INFO = 6;
    static final int C_REQUEST_INFO_TERM = 7;
    static final int C_INFO_FOUND = 8;
    static final int C_INFO_NOT_FOUND = 9;
    static final int C_SKELETON_DISPOSE = 10;
    static final int C_STUB_DISPOSE = 11;
    static final int R_CLOSED = 1;
    static final int R_DISCONNECTED = 2;
    static final int R_PING_FAILURE = 4;
    static final int R_CONTROL_FAILURE = 8;
    private static final int SPIN_LIMIT = Runtime.getRuntime().availableProcessors() > 1 ? 1024 : 1;
    private static final VarHandle cStubSupportHandle;
    private static final VarHandle cControlPipeHandle;
    private static final VarHandle cConLockHandle;
    private static final VarHandle cPipeClockHandle;
    final Engine mEngine;
    final Settings mSettings;
    final ItemMap<Stub> mStubs;
    final ItemMap<StubFactory> mStubFactories;
    final ConcurrentHashMap<Class<?>, StubFactory> mStubFactoriesByClass;
    final SkeletonMap mSkeletons;
    final ItemMap<Item> mKnownTypes;
    private CoreStubSupport mStubSupport;
    final CoreSkeletonSupport mSkeletonSupport;
    final Lock mControlLock;
    private CorePipe mControlPipe;
    TypeCodeMap mTypeCodeMap;
    private volatile int mConLock;
    private CorePipe mConFirst;
    private CorePipe mConAvail;
    private CorePipe mConLast;
    private int mConClock;
    private volatile BiConsumer<Session<?>, Throwable> mUncaughtExceptionHandler;
    private volatile int mClosed;
    final Lock mStateLock;
    private volatile Object mStateListeners;
    volatile Session.State mState;
    volatile WaitMap<String, RemoteInfo> mTypeWaitMap;

    CoreSession(Engine engine, Settings settings) {
        super(IdGenerator.next());
        this.mEngine = engine;
        this.mSettings = settings;
        this.mStubs = new ItemMap();
        this.mStubFactories = new ItemMap();
        this.mStubFactoriesByClass = new ConcurrentHashMap();
        this.mSkeletons = new SkeletonMap(this);
        this.mKnownTypes = new ItemMap();
        this.stubSupport(new CoreStubSupport(this));
        this.mSkeletonSupport = new CoreSkeletonSupport(this);
        this.mControlLock = new ReentrantLock();
        this.mStateLock = new ReentrantLock();
        this.initTypeCodeMap(TypeCodeMap.STANDARD);
    }

    final void initTypeCodeMap(TypeCodeMap tcm) {
        this.mTypeCodeMap = tcm;
        VarHandle.storeStoreFence();
    }

    final void registerNewConnection(CorePipe pipe) throws RemoteException {
        this.conLockAcquire();
        try {
            this.checkClosed();
            pipe.mSession = this;
            CorePipe first = this.mConFirst;
            if (first == null) {
                this.mConLast = pipe;
            } else {
                pipe.mConNext = first;
                first.mConPrev = pipe;
            }
            this.mConFirst = pipe;
        }
        catch (Throwable e) {
            CoreUtils.closeQuietly(pipe);
            throw e;
        }
        finally {
            this.conLockRelease();
        }
    }

    void registerNewAvailableConnection(CorePipe pipe, long sessionId) throws RemoteException {
        this.conLockAcquire();
        try {
            this.checkClosed();
            if (sessionId != 0L && sessionId != this.id) {
                RemoteException e = new RemoteException("Connection belongs to an old session");
                e.remoteAddress(this.remoteAddress());
                throw e;
            }
            pipe.mSession = this;
            pipe.mClock = this.mConClock;
            CorePipe last = this.mConLast;
            if (last == null) {
                this.mConFirst = pipe;
                this.mConAvail = pipe;
            } else {
                pipe.mConPrev = last;
                last.mConNext = pipe;
                if (this.mConAvail == null) {
                    this.mConAvail = pipe;
                }
            }
            this.mConLast = pipe;
        }
        catch (Throwable e) {
            CoreUtils.closeQuietly(pipe);
            throw e;
        }
        finally {
            this.conLockRelease();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean recycleConnection(CorePipe pipe) {
        block18: {
            block20: {
                this.conLockAcquire();
                try {
                    int mode;
                    if (this.mClosed != 0 || (mode = pipe.mMode) == 3) {
                        this.doRemoveConnection(pipe);
                        pipe.mMode = 3;
                        break block18;
                    }
                    pipe.mClock = this.mConClock;
                    if (mode != 2) {
                        CorePipe last;
                        CorePipe next;
                        CorePipe avail = this.mConAvail;
                        if (avail == pipe) {
                            boolean bl = true;
                            return bl;
                        }
                        if (avail == null) {
                            this.mConAvail = pipe;
                        }
                        if ((next = pipe.mConNext) == null) {
                            assert (pipe == this.mConLast);
                            boolean bl = true;
                            return bl;
                        }
                        CorePipe prev = pipe.mConPrev;
                        if (prev == null) {
                            assert (pipe == this.mConFirst);
                            this.mConFirst = next;
                        } else {
                            prev.mConNext = next;
                        }
                        next.mConPrev = prev;
                        pipe.mConNext = null;
                        pipe.mConPrev = last = this.mConLast;
                        last.mConNext = pipe;
                        this.mConLast = pipe;
                        boolean bl = true;
                        return bl;
                    }
                }
                finally {
                    this.conLockRelease();
                }
                try {
                    this.startRequestProcessor(pipe);
                }
                catch (IOException e) {
                    if (this.isClosedOrDisconnected()) break block20;
                    this.uncaught(e);
                }
            }
            return false;
        }
        pipe.doClose();
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final CorePipe tryObtainConnection() throws RemoteException {
        this.conLockAcquire();
        try {
            CorePipe pipe;
            this.checkClosed();
            CorePipe avail = this.mConAvail;
            if (avail == null || (pipe = this.mConLast) == null) {
                CorePipe corePipe = null;
                return corePipe;
            }
            if (avail == pipe) {
                this.mConAvail = null;
            } else {
                CorePipe first;
                CorePipe prev;
                this.mConLast = prev = pipe.mConPrev;
                prev.mConNext = null;
                pipe.mConPrev = null;
                pipe.mConNext = first = this.mConFirst;
                first.mConPrev = pipe;
                this.mConFirst = pipe;
            }
            CorePipe corePipe = pipe;
            return corePipe;
        }
        finally {
            this.conLockRelease();
        }
    }

    final boolean hasAvailableConnection() {
        this.conLockAcquire();
        try {
            boolean bl = this.mConAvail != null;
            return bl;
        }
        finally {
            this.conLockRelease();
        }
    }

    final void closeConnection(CorePipe pipe) {
        this.conLockAcquire();
        try {
            pipe.mMode = 3;
            this.doRemoveConnection(pipe);
        }
        finally {
            this.conLockRelease();
        }
        pipe.doClose();
    }

    private void doRemoveConnection(CorePipe pipe) {
        CorePipe prev;
        CorePipe next = pipe.mConNext;
        if (pipe == this.mConAvail) {
            this.mConAvail = next;
        }
        if ((prev = pipe.mConPrev) != null) {
            prev.mConNext = next;
        } else if (pipe == this.mConFirst) {
            this.mConFirst = next;
        }
        if (next != null) {
            next.mConPrev = prev;
        } else if (pipe == this.mConLast) {
            this.mConLast = prev;
        }
        pipe.mConPrev = null;
        pipe.mConNext = null;
    }

    @Override
    public final SocketAddress localAddress() {
        CorePipe pipe = this.controlPipe();
        return pipe == null ? null : pipe.localAddress();
    }

    @Override
    public final SocketAddress remoteAddress() {
        CorePipe pipe = this.controlPipe();
        return pipe == null ? null : pipe.remoteAddress();
    }

    @Override
    public final Class<?> resolveClass(String name) throws IOException, ClassNotFoundException {
        ClassResolver resolver = this.mSettings.resolver;
        try {
            Class<?> clazz;
            if (resolver != null && (clazz = resolver.resolveClass(name)) != null) {
                return clazz;
            }
            return this.loadClass(name);
        }
        catch (IOException | ClassNotFoundException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new ClassNotFoundException(name, e);
        }
    }

    @Override
    public final void uncaughtExceptionHandler(BiConsumer<Session<?>, Throwable> h) {
        this.mUncaughtExceptionHandler = h;
    }

    @Override
    public final void uncaught(Throwable e) {
        if (!CoreUtils.acceptException(this.mUncaughtExceptionHandler, this, e)) {
            this.mEngine.uncaught(this, e);
        }
    }

    @Override
    public void execute(Runnable command) {
        this.mEngine.execute(command);
    }

    @Override
    public final Session.State state() {
        return this.mState;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void addStateListener(BiPredicate<Session<?>, Throwable> listener) {
        Objects.requireNonNull(listener);
        this.mStateLock.lock();
        try {
            Object listeners = this.mStateListeners;
            try {
                if (listeners == null) {
                    this.mStateListeners = listener;
                    if (!listener.test(this, null)) {
                        this.mStateListeners = null;
                    }
                } else {
                    IdentityHashMap map;
                    if (listeners instanceof Map) {
                        map = (IdentityHashMap)listeners;
                    } else {
                        map = new IdentityHashMap();
                        map.put((BiPredicate)listeners, true);
                        this.mStateListeners = map;
                    }
                    map.put(listener, true);
                    if (!listener.test(this, null)) {
                        map.remove(listener);
                        if (map.isEmpty()) {
                            this.mStateListeners = null;
                        }
                    }
                }
            }
            catch (Throwable e) {
                this.uncaught(e);
            }
        }
        finally {
            this.mStateLock.unlock();
        }
    }

    private void setStateAndNotify(Session.State state) {
        if (this.mState != state) {
            this.mState = state;
            this.notifyListeners(null);
        }
    }

    void casStateAndNotify(Session.State expect, Session.State newState) {
        this.mStateLock.lock();
        try {
            if (this.mState == expect) {
                this.setStateAndNotify(newState);
            }
        }
        finally {
            this.mStateLock.unlock();
        }
    }

    void reconnectFailureNotify(Throwable ex) {
        if (this.mStateListeners != null) {
            this.mStateLock.lock();
            try {
                this.notifyListeners(ex);
            }
            finally {
                this.mStateLock.unlock();
            }
        }
    }

    private void notifyListeners(Throwable ex) {
        Object listeners = this.mStateListeners;
        if (listeners instanceof Map) {
            Map map = (Map)listeners;
            Iterator it = map.keySet().iterator();
            while (it.hasNext()) {
                BiPredicate listener = (BiPredicate)it.next();
                try {
                    if (listener.test(this, ex)) continue;
                    it.remove();
                }
                catch (Throwable e) {
                    this.uncaught(e);
                }
            }
            if (map.isEmpty()) {
                this.mStateListeners = null;
            }
        } else if (listeners != null) {
            BiPredicate listener = (BiPredicate)listeners;
            try {
                if (!listener.test(this, ex)) {
                    this.mStateListeners = null;
                }
            }
            catch (Throwable e) {
                this.uncaught(e);
            }
        }
    }

    @Override
    public final void close() {
        this.close(1, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean close(int reason, CorePipe controlPipe) {
        CorePipe first;
        if ((reason & 3) == 0) {
            reason |= 1;
        }
        boolean justClosed = false;
        this.mStateLock.lock();
        try {
            if ((reason & 2) != 0 && controlPipe != null && this.mControlPipe != controlPipe) {
                boolean bl = false;
                return bl;
            }
            int closed = this.mClosed;
            if (closed == 0) {
                this.mClosed = reason;
                justClosed = true;
            } else if ((closed & 1) != 0) {
                reason |= 1;
                reason &= 0xFFFFFFFD;
            }
            this.setStateAndNotify((reason & 2) != 0 ? Session.State.DISCONNECTED : Session.State.CLOSED);
            this.conLockAcquire();
            try {
                first = this.mConFirst;
                this.mConFirst = null;
                this.mConAvail = null;
                this.mConLast = null;
                CoreSession.markPipesClosed(first);
            }
            finally {
                this.conLockRelease();
            }
        }
        finally {
            this.mStateLock.unlock();
        }
        CoreSession.closePipes(first);
        this.mStubFactories.clear();
        this.mStubFactoriesByClass.clear();
        CoreStubSupport newSupport = new CoreStubSupport(this);
        this.stubSupport(newSupport);
        if ((reason & 1) != 0) {
            this.mStubs.clear();
        } else {
            assert ((reason & 2) != 0);
            DisposedStubSupport support = DisposedStubSupport.newDisconnected(this);
            this.mStubs.forEachToRemove(stub -> {
                if (stub.isRestorable() || stub == this.root()) {
                    Stub.cSupportHandle.setRelease((Stub)stub, newSupport);
                    return false;
                }
                Stub.cSupportHandle.setRelease((Stub)stub, support);
                return true;
            });
            Object root = this.root();
            if (root instanceof Stub) {
                Stub.setRootOrigin((Stub)root);
            }
        }
        this.mKnownTypes.clear();
        SkeletonMap skeletonMap = this.mSkeletons;
        synchronized (skeletonMap) {
            this.mSkeletons.forEach(this::detached);
            this.mSkeletons.clear();
        }
        this.mTypeWaitMap = null;
        return justClosed;
    }

    private static void markPipesClosed(CorePipe pipe) {
        while (pipe != null) {
            pipe.mMode = 3;
            pipe = pipe.mConNext;
        }
    }

    private static void closePipes(CorePipe pipe) {
        while (pipe != null) {
            CorePipe next = pipe.mConNext;
            pipe.mConPrev = null;
            pipe.mConNext = null;
            pipe.doClose();
            pipe = next;
        }
    }

    final void unclose() {
        this.mStateLock.lock();
        try {
            if (this.mState == Session.State.DISCONNECTED) {
                this.setStateAndNotify(Session.State.RECONNECTING);
            }
            this.setStateAndNotify(Session.State.RECONNECTED);
            this.mClosed = 0;
            this.setStateAndNotify(Session.State.CONNECTED);
        }
        finally {
            this.mStateLock.unlock();
        }
    }

    final void moveConnectionsFrom(CoreSession from) {
        CorePipe first;
        this.conLockAcquire();
        try {
            first = this.mConFirst;
            this.mConFirst = from.mConFirst;
            this.mConAvail = from.mConAvail;
            this.mConLast = from.mConLast;
            CoreSession.markPipesClosed(first);
        }
        finally {
            this.conLockRelease();
        }
        this.controlPipe(from.controlPipe());
        CoreSession.closePipes(first);
    }

    public final String toString() {
        return this.getClass().getSimpleName() + "@" + Integer.toHexString(System.identityHashCode(this)) + "{state=" + this.state() + ", localAddress=" + this.localAddress() + ", remoteAddress=" + this.remoteAddress() + "}";
    }

    final CorePipe controlPipe() {
        return cControlPipeHandle.getAcquire(this);
    }

    final void controlPipe(CorePipe pipe) {
        this.mStateLock.lock();
        pipe.mSession = this;
        cControlPipeHandle.setRelease(this, pipe);
        this.mStateLock.unlock();
    }

    void startTasks() throws IOException {
        int idleMillis;
        CorePipe pipe = this.controlPipe();
        Runnable pongTask = () -> {
            try {
                this.sendByte(2);
            }
            catch (Throwable e) {
                if (!(e instanceof IOException)) {
                    this.uncaught(e);
                }
                this.close(8, pipe);
            }
        };
        this.mEngine.executeTask(() -> {
            try {
                int command;
                block15: while (true) {
                    command = pipe.readUnsignedByte();
                    switch (command) {
                        case 1: {
                            this.mEngine.executeTask(pongTask);
                            continue block15;
                        }
                        case 2: {
                            cPipeClockHandle.setVolatile(pipe, 0);
                            continue block15;
                        }
                        case 3: {
                            Object message = pipe.readObject();
                            continue block15;
                        }
                        case 4: {
                            this.mKnownTypes.putIfAbsent(new Item(pipe.readLong()));
                            continue block15;
                        }
                        case 5: {
                            long id = pipe.readLong();
                            this.mEngine.executeTask(() -> this.reverseConnect(id));
                            continue block15;
                        }
                        case 6: {
                            String typeName = (String)pipe.readObject();
                            this.mEngine.executeTask(() -> this.sendInfoResponse(pipe, typeName));
                            continue block15;
                        }
                        case 7: {
                            this.mEngine.executeTask(() -> this.sendInfoResponseTerminator(pipe));
                            continue block15;
                        }
                        case 8: {
                            long typeId = pipe.readLong();
                            RemoteInfo info = RemoteInfo.readFrom(pipe);
                            this.mEngine.executeTask(() -> this.infoFound(pipe, typeId, info, false));
                            continue block15;
                        }
                        case 9: {
                            String typeName = (String)pipe.readObject();
                            WaitMap<String, RemoteInfo> waitMap = this.mTypeWaitMap;
                            if (waitMap == null) continue block15;
                            waitMap.remove(typeName);
                            continue block15;
                        }
                        case 10: {
                            Skeleton skeleton = this.mSkeletons.remove(pipe.readLong());
                            if (skeleton == null) continue block15;
                            this.detached(skeleton, true);
                            continue block15;
                        }
                        case 11: {
                            long id = pipe.readLong();
                            this.stubDispose(id, "Object is disposed by remote endpoint");
                            this.mEngine.executeTask(() -> this.trySendCommandAndId(10, id));
                            continue block15;
                        }
                    }
                    break;
                }
                throw new IllegalStateException("Unknown command: " + command);
            }
            catch (Throwable e) {
                if (!(e instanceof IOException)) {
                    this.uncaught(e);
                }
                this.close(8, pipe);
                return;
            }
        });
        int pingTimeoutMillis = this.mSettings.pingTimeoutMillis;
        if (pingTimeoutMillis >= 0) {
            long pingDelayNanos = CoreSession.taskDelayNanos(pingTimeoutMillis);
            this.mEngine.scheduleNanos(new Pinger(this, pingDelayNanos), pingDelayNanos);
        }
        if ((idleMillis = this.mSettings.idleConnectionMillis) >= 0) {
            long idleDelayNanos = CoreSession.taskDelayNanos(idleMillis);
            this.mEngine.scheduleNanos(new Closer(this, idleDelayNanos), idleDelayNanos);
        }
    }

    private static long taskDelayNanos(long timeoutMillis) {
        return (long)((double)(timeoutMillis * 1000000L) / 1.5);
    }

    private void sendByte(int which) throws IOException {
        this.mControlLock.lock();
        try {
            CorePipe pipe = this.controlPipe();
            pipe.write(which);
            pipe.flush();
        }
        finally {
            this.mControlLock.unlock();
        }
    }

    void sendInfoRequest(Class<?> type) throws IOException {
        this.mControlLock.lock();
        try {
            CorePipe pipe = this.controlPipe();
            pipe.write(6);
            pipe.writeObject(type.getName());
        }
        finally {
            this.mControlLock.unlock();
        }
    }

    void sendInfoRequestTerminator() throws IOException {
        this.mControlLock.lock();
        try {
            CorePipe pipe = this.controlPipe();
            pipe.write(7);
            pipe.flush();
        }
        finally {
            this.mControlLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendInfoResponse(CorePipe controlPipe, String typeName) {
        Object response;
        long typeId;
        block9: {
            SkeletonFactory<?> factory;
            RemoteInfo info;
            try {
                Class<?> type = this.loadClass(typeName);
                info = RemoteInfo.examine(type);
                factory = SkeletonMaker.factoryFor(type);
            }
            catch (Exception e) {
                typeId = 0L;
                response = typeName;
                break block9;
            }
            typeId = factory.typeId();
            response = info;
        }
        this.mControlLock.lock();
        try {
            if (response instanceof RemoteInfo) {
                controlPipe.write(8);
                controlPipe.writeLong(typeId);
                ((RemoteInfo)response).writeTo(controlPipe);
            } else {
                controlPipe.write(9);
                controlPipe.writeObject(response);
            }
        }
        catch (IOException e) {
            this.close(8, controlPipe);
        }
        finally {
            this.mControlLock.unlock();
        }
    }

    private void sendInfoResponseTerminator(CorePipe controlPipe) {
        this.mControlLock.lock();
        try {
            controlPipe.write(3);
            controlPipe.writeNull();
            controlPipe.flush();
        }
        catch (IOException e) {
            this.close(8, controlPipe);
        }
        finally {
            this.mControlLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void infoFound(CorePipe controlPipe, long typeId, RemoteInfo info, boolean flush) {
        Class<?> type;
        WaitMap<String, RemoteInfo> waitMap = this.mTypeWaitMap;
        try {
            type = this.loadClass(info.name());
        }
        catch (ClassNotFoundException e) {
            waitMap.remove(info.name());
            return;
        }
        StubFactory factory = StubMaker.factoryFor(type, typeId, info);
        factory = this.mStubFactories.putIfAbsent(factory);
        this.mStubFactoriesByClass.putIfAbsent(type, factory);
        if (waitMap != null) {
            waitMap.put(info.name(), info);
        }
        this.mControlLock.lock();
        try {
            controlPipe.write(4);
            controlPipe.writeLong(typeId);
            if (flush) {
                controlPipe.flush();
            }
        }
        catch (IOException e) {
            this.close(8, controlPipe);
        }
        finally {
            this.mControlLock.unlock();
        }
    }

    void flushControlPipe() throws IOException {
        this.mControlLock.lock();
        try {
            this.controlPipe().flush();
        }
        finally {
            this.mControlLock.unlock();
        }
    }

    private boolean closeIdleConnections() {
        block2: {
            this.conLockAcquire();
            if (this.mClosed == 0) {
                CorePipe pipe;
                int clock = this.mConClock;
                while ((pipe = this.mConAvail) != null && pipe.mClock - clock < 0) {
                    this.doRemoveConnection(pipe);
                    pipe.mMode = 3;
                    this.conLockRelease();
                    pipe.doClose();
                    this.conLockAcquire();
                    if (this.mClosed == 0) continue;
                    break block2;
                }
                this.mConClock = clock + 1;
                this.conLockRelease();
                return true;
            }
        }
        this.conLockRelease();
        return false;
    }

    abstract CorePipe connect() throws IOException;

    void reverseConnect(long id) {
    }

    final Object objectFor(long id) throws IOException {
        try {
            return ((Skeleton)this.mSkeletons.get(id)).server();
        }
        catch (NoSuchObjectException e) {
            e.remoteAddress(this.remoteAddress());
            throw e;
        }
    }

    final Object objectFor(long id, long typeId) throws IOException {
        try {
            StubFactory factory = this.mStubFactories.get(typeId);
            return this.mStubs.putIfAbsent(factory.newStub(id, this.stubSupport()));
        }
        catch (NoSuchObjectException e) {
            e.remoteAddress(this.remoteAddress());
            throw e;
        }
    }

    final Object objectFor(long id, long typeId, RemoteInfo info) {
        Class type;
        boolean found = true;
        try {
            type = this.loadClass(info.name());
        }
        catch (ClassNotFoundException e) {
            type = Remote.class;
            found = false;
        }
        StubFactory factory = StubMaker.factoryFor(type, typeId, info);
        factory = this.mStubFactories.putIfAbsent(factory);
        this.mEngine.tryExecuteTask(() -> this.trySendCommandAndId(4, typeId));
        if (found) {
            this.mStubFactoriesByClass.putIfAbsent(type, factory);
        }
        return this.mStubs.putIfAbsent(factory.newStub(id, this.stubSupport()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void trySendCommandAndId(int command, long id) {
        this.mControlLock.lock();
        try {
            CorePipe pipe = this.controlPipe();
            pipe.write(command);
            pipe.writeLong(id);
            pipe.flush();
        }
        catch (IOException iOException) {
        }
        finally {
            this.mControlLock.unlock();
        }
    }

    final Stub newDisconnectedStub(Class<?> type, Throwable cause) {
        StubFactory factory = this.mStubFactoriesByClass.get(type);
        if (factory == null) {
            factory = StubMaker.factoryFor(type, 0L, RemoteInfo.examine(type));
        }
        long id = IdGenerator.nextNegative();
        Stub stub = factory.newStub(id, DisposedStubSupport.newLenientRestorable(this, cause));
        this.mStubs.put(stub);
        return stub;
    }

    final CoreStubSupport stubSupport() {
        return cStubSupportHandle.getAcquire(this);
    }

    final void stubSupport(CoreStubSupport support) {
        cStubSupportHandle.setRelease(this, support);
    }

    final StubSupport stubDispose(Stub stub) {
        this.mStubs.remove(stub);
        return DisposedStubSupport.EXPLICIT;
    }

    final boolean stubDispose(long id, String message) {
        Stub removed = this.mStubs.remove((Stub)id);
        if (removed == null) {
            return false;
        }
        DisposedStubSupport disposed = message == null ? DisposedStubSupport.EXPLICIT : new DisposedStubSupport(message);
        Stub.cSupportHandle.setRelease(removed, disposed);
        return true;
    }

    final boolean stubDisposeAndNotify(Stub stub, String message) {
        long id = stub.id;
        if (this.stubDispose(id, message)) {
            this.trySendCommandAndId(10, id);
            return true;
        }
        return false;
    }

    final boolean serverDispose(Object server) {
        Skeleton<Object> skeleton;
        if (server == null || (skeleton = this.mSkeletons.skeletonFor(server, false)) == null) {
            return false;
        }
        this.trySendCommandAndId(11, skeleton.id);
        return true;
    }

    final Class<?> loadClass(String name) throws ClassNotFoundException {
        return Class.forName(name, false, this.root().getClass().getClassLoader());
    }

    final long remoteTypeId(Class<?> type) {
        StubFactory factory = this.mStubFactoriesByClass.get(type);
        return factory == null ? 0L : factory.id;
    }

    final void writeSkeleton(CorePipe pipe, Object server) throws IOException {
        this.writeSkeleton(pipe, this.mSkeletons.skeletonFor(server));
    }

    final Skeleton createSkeletonAlias(Object server, long aliasId) {
        Skeleton<Object> existing;
        Class<?> type = RemoteExaminer.remoteType(server);
        SkeletonFactory<?> factory = SkeletonMaker.factoryFor(type);
        Skeleton<Object> skeleton = factory.newSkeleton(aliasId, this.mSkeletonSupport, server);
        if (server instanceof SessionAware) {
            SessionAware sa = (SessionAware)server;
            this.attachNotify(sa);
        }
        if ((existing = this.mSkeletons.putIfAbsent(skeleton)) != skeleton && server instanceof SessionAware) {
            try {
                ((SessionAware)server).detached(this);
            }
            catch (Throwable e) {
                this.uncaught(e);
            }
        }
        return existing;
    }

    final Skeleton<?> createBrokenSkeletonAlias(Class<?> type, long aliasId, Throwable exception) {
        SkeletonFactory<?> factory = SkeletonMaker.factoryFor(type);
        Skeleton<?> skeleton = factory.newSkeleton(exception, aliasId, this.mSkeletonSupport);
        return this.mSkeletons.putIfAbsent(skeleton);
    }

    final void writeSkeletonAlias(CorePipe pipe, Object server, long aliasId) throws IOException {
        Skeleton skeleton = this.createSkeletonAlias(server, aliasId);
        try {
            this.writeSkeleton(pipe, skeleton);
        }
        catch (Throwable e) {
            this.removeSkeleton(skeleton);
            throw e;
        }
    }

    final void writeBrokenSkeletonAlias(CorePipe pipe, Class<?> type, long aliasId, Throwable exception) throws IOException {
        Skeleton<?> skeleton = this.createBrokenSkeletonAlias(type, aliasId, exception);
        try {
            this.writeSkeleton(pipe, skeleton);
        }
        catch (Throwable e) {
            this.removeSkeleton(skeleton);
            throw e;
        }
    }

    private void writeSkeleton(CorePipe pipe, Skeleton skeleton) throws IOException {
        if (this.mKnownTypes.tryGet(skeleton.typeId()) != null) {
            pipe.writeSkeletonHeader((byte)7, skeleton);
        } else {
            RemoteInfo info = RemoteInfo.examine(skeleton.type());
            pipe.writeSkeletonHeader((byte)8, skeleton);
            info.writeTo(pipe);
        }
    }

    static MarshalledSkeleton marshallSkeleton(CorePipe pipe, Object server) {
        return pipe.mSession.marshallSkeleton(server);
    }

    private MarshalledSkeleton marshallSkeleton(Object server) {
        byte[] infoBytes;
        Skeleton<Object> skeleton = this.mSkeletons.skeletonFor(server);
        long typeId = skeleton.typeId();
        if (this.mKnownTypes.tryGet(typeId) != null) {
            infoBytes = null;
        } else {
            RemoteInfo info = RemoteInfo.examine(skeleton.type());
            CaptureOutputStream out = new CaptureOutputStream();
            BufferedPipe pipe = new BufferedPipe(InputStream.nullInputStream(), out);
            try {
                info.writeTo(pipe);
                pipe.flush();
            }
            catch (IOException e) {
                throw new AssertionError((Object)e);
            }
            infoBytes = out.getBytes();
        }
        return new MarshalledSkeleton(skeleton.id, typeId, infoBytes);
    }

    final void removeSkeleton(Skeleton<?> skeleton) {
        if (this.mSkeletons.remove(skeleton) != null) {
            this.detached(skeleton);
        }
    }

    private void detached(Skeleton<?> skeleton) {
        this.detached(skeleton, false);
    }

    private void detached(Skeleton<?> skeleton, boolean newTask) {
        Object server = skeleton.server();
        if (server instanceof SessionAware) {
            Runnable task;
            SessionAware sa = (SessionAware)server;
            if (newTask && this.mEngine.tryExecuteTask(task = () -> {
                try {
                    sa.detached(this);
                }
                catch (Throwable e) {
                    this.uncaught(e);
                }
            })) {
                return;
            }
            try {
                sa.detached(this);
            }
            catch (Throwable e) {
                this.uncaught(e);
            }
        }
    }

    final void attachNotify(SessionAware sa) {
        if (this.mState != null) {
            try {
                sa.attached(this);
            }
            catch (Throwable e) {
                this.uncaught(e);
            }
        }
    }

    final boolean isClosed() {
        return (this.mClosed & 1) != 0;
    }

    final boolean isClosedOrDisconnected() {
        return this.mClosed != 0;
    }

    final void checkClosed() throws RemoteException {
        int closed = this.mClosed;
        if (closed != 0) {
            this.throwClosed(closed);
        }
    }

    private void throwClosed(int closed) throws RemoteException {
        StringBuilder b = new StringBuilder(80).append("Session is ");
        b.append((closed & 2) == 0 ? "closed" : "disconnected");
        if ((closed & 4) != 0) {
            b.append(" (ping response timeout)");
        } else if ((closed & 8) != 0) {
            b.append(" (control connection failure)");
        }
        if ((closed & 2) != 0) {
            b.append("; attempting to reconnect");
        }
        String message = b.toString();
        RemoteException e = (closed & 2) != 0 ? new DisconnectedException(message) : new ClosedException(message);
        e.remoteAddress(this.remoteAddress());
        throw e;
    }

    final void conLockAcquire() {
        int trials = 0;
        while (this.mConLock != 0 || !cConLockHandle.compareAndSet(this, 0, 1)) {
            if (++trials >= SPIN_LIMIT) {
                Thread.yield();
                trials = 0;
                continue;
            }
            Thread.onSpinWait();
        }
    }

    final void conLockRelease() {
        this.mConLock = 0;
    }

    final void startRequestProcessor(CorePipe pipe) throws IOException {
        try {
            this.mEngine.executeTask(new Processor(pipe));
        }
        catch (IOException e) {
            this.closeConnection(pipe);
            throw e;
        }
    }

    static {
        try {
            MethodHandles.Lookup lookup = MethodHandles.lookup();
            cStubSupportHandle = lookup.findVarHandle(CoreSession.class, "mStubSupport", CoreStubSupport.class);
            cControlPipeHandle = lookup.findVarHandle(CoreSession.class, "mControlPipe", CorePipe.class);
            cConLockHandle = lookup.findVarHandle(CoreSession.class, "mConLock", Integer.TYPE);
            cPipeClockHandle = lookup.findVarHandle(CorePipe.class, "mClock", Integer.TYPE);
        }
        catch (Throwable e) {
            throw CoreUtils.rethrow(e);
        }
    }

    private static class Pinger
    extends WeakScheduled {
        Pinger(CoreSession session, long delayNanos) {
            super(session, delayNanos);
        }

        @Override
        boolean doRun(CoreSession session) {
            if (session.isClosedOrDisconnected()) {
                return false;
            }
            CorePipe pipe = session.controlPipe();
            int clock = cPipeClockHandle.getVolatile(pipe);
            if (clock == 1) {
                session.close(4, pipe);
                return false;
            }
            cPipeClockHandle.setVolatile(pipe, 1);
            try {
                session.sendByte(1);
            }
            catch (IOException e) {
                session.close(8, pipe);
                return false;
            }
            return true;
        }
    }

    private static class Closer
    extends WeakScheduled {
        Closer(CoreSession session, long delayNanos) {
            super(session, delayNanos);
        }

        @Override
        boolean doRun(CoreSession session) {
            return session.closeIdleConnections();
        }
    }

    private final class Processor
    implements Runnable {
        private final CorePipe mPipe;

        Processor(CorePipe pipe) {
            this.mPipe = pipe;
        }

        @Override
        public void run() {
            try {
                CoreUtils.cCurrentSession.set(CoreSession.this);
                Object context = null;
                do {
                    Skeleton skeleton = (Skeleton)CoreSession.this.mSkeletons.get(this.mPipe.readLong());
                    context = skeleton.invoke(this.mPipe, context);
                    skeleton = null;
                } while (context != Skeleton.STOP_READING);
            }
            catch (Throwable e) {
                if (e instanceof UncaughtException) {
                    CoreSession.this.uncaught(e.getCause());
                } else if (!CoreSession.this.isClosedOrDisconnected()) {
                    if (e instanceof NoSuchObjectException) {
                        NoSuchObjectException nsoe = (NoSuchObjectException)e;
                        nsoe.remoteAddress(CoreSession.this.remoteAddress());
                        CoreSession.this.uncaught(e);
                    } else if (e instanceof ObjectStreamException || e instanceof ClassNotFoundException || !(e instanceof IOException)) {
                        CoreSession.this.uncaught(e);
                    }
                }
                CoreUtils.closeQuietly(this.mPipe);
            }
            finally {
                CoreUtils.cCurrentSession.remove();
            }
        }
    }

    private static abstract class WeakScheduled
    extends Scheduled {
        final WeakReference<CoreSession> mSessionRef;
        final long mDelayNanos;

        WeakScheduled(CoreSession session, long delayNanos) {
            this.mSessionRef = new WeakReference<CoreSession>(session);
            this.mDelayNanos = delayNanos;
        }

        @Override
        public final void run() {
            CoreSession session = (CoreSession)this.mSessionRef.get();
            if (session != null && this.doRun(session)) {
                try {
                    session.mEngine.scheduleNanos(this, this.mDelayNanos);
                }
                catch (IOException e) {
                    session.uncaught(e);
                }
            }
        }

        abstract boolean doRun(CoreSession var1);
    }
}

