/*
 * Decompiled with CFR 0.152.
 */
package org.cojen.dirmi.core;

import java.io.IOException;
import org.cojen.dirmi.Pipe;
import org.cojen.dirmi.core.CoreSession;
import org.cojen.dirmi.core.CoreUtils;
import org.cojen.dirmi.core.Stub;
import org.cojen.dirmi.core.StubSupport;

final class CoreStubSupport
implements StubSupport {
    private final CoreSession<?> mSession;
    private final ThreadLocal<Pipe> mLocalPipe;

    CoreStubSupport(CoreSession<?> session) {
        this.mSession = session;
        this.mLocalPipe = new ThreadLocal();
    }

    @Override
    public CoreSession session() {
        return this.mSession;
    }

    @Override
    public <T extends Throwable> Pipe connect(Stub stub, Class<T> remoteFailureException) throws T {
        Pipe pipe = this.mLocalPipe.get();
        if (pipe != null) {
            return pipe;
        }
        try {
            return this.mSession.connect();
        }
        catch (Throwable e) {
            throw CoreUtils.remoteException(this.mSession, remoteFailureException, e);
        }
    }

    @Override
    public <T extends Throwable> Pipe connectUnbatched(Stub stub, Class<T> remoteFailureException) throws T {
        try {
            return this.mSession.connect();
        }
        catch (Throwable e) {
            throw CoreUtils.remoteException(this.mSession, remoteFailureException, e);
        }
    }

    @Override
    public <T extends Throwable> Pipe tryConnect(Stub stub, Class<T> remoteFailureException) throws T {
        Pipe pipe = this.mLocalPipe.get();
        if (pipe != null) {
            return pipe;
        }
        try {
            return this.mSession.connect();
        }
        catch (IOException e) {
            return null;
        }
        catch (Throwable e) {
            throw CoreUtils.remoteException(this.mSession, remoteFailureException, e);
        }
    }

    @Override
    public <T extends Throwable> Pipe tryConnectUnbatched(Stub stub, Class<T> remoteFailureException) throws T {
        try {
            return this.mSession.connect();
        }
        catch (IOException e) {
            return null;
        }
        catch (Throwable e) {
            throw CoreUtils.remoteException(this.mSession, remoteFailureException, e);
        }
    }

    @Override
    public boolean validate(Stub stub, Pipe pipe) {
        if (Stub.cSupportHandle.getAcquire(stub) == this) {
            return true;
        }
        if (pipe != null) {
            this.discard(pipe);
        }
        return false;
    }

    private void discard(Pipe pipe) {
        if (this.mLocalPipe.get() == pipe) {
            this.mLocalPipe.remove();
            CoreUtils.closeQuietly(pipe);
        } else {
            this.finished(pipe);
        }
    }

    @Override
    public long remoteTypeId(Class<?> type) {
        return this.mSession.remoteTypeId(type);
    }

    @Override
    public <T extends Throwable> Object newAliasStub(Class<T> remoteFailureException, long aliasId, long typeId) throws T {
        try {
            return this.mSession.objectFor(aliasId, typeId);
        }
        catch (Throwable e) {
            throw CoreUtils.remoteException(this.mSession, remoteFailureException, e);
        }
    }

    @Override
    public Stub newDisconnectedStub(Class<?> type, Throwable cause) {
        return this.mSession.newDisconnectedStub(type, cause);
    }

    @Override
    public boolean isBatching(Pipe pipe) {
        return this.mLocalPipe.get() == pipe;
    }

    @Override
    public boolean finishBatch(Pipe pipe) {
        if (this.mLocalPipe.get() != pipe) {
            return false;
        }
        this.mLocalPipe.remove();
        return true;
    }

    @Override
    public Throwable readResponse(Pipe pipe) throws IOException {
        Throwable ex = (Throwable)pipe.readObject();
        if (ex != null) {
            CoreUtils.assignTrace(pipe, ex);
        }
        return ex;
    }

    @Override
    public void finished(Pipe pipe) {
        try {
            pipe.recycle();
        }
        catch (IOException e) {
            this.mSession.uncaught(e);
        }
    }

    @Override
    public void batched(Pipe pipe) {
        this.mLocalPipe.set(pipe);
    }

    @Override
    public <T extends Throwable> T failed(Class<T> remoteFailureException, Pipe pipe, Throwable cause) {
        this.mLocalPipe.remove();
        CoreUtils.closeQuietly(pipe);
        return CoreUtils.remoteException(this.mSession, remoteFailureException, cause);
    }

    @Override
    public void dispose(Stub stub) {
        Stub.cSupportHandle.setRelease(stub, this.mSession.stubDispose(stub));
    }
}

