/*
 * Decompiled with CFR 0.152.
 */
package org.cojen.dirmi.core;

import java.io.Closeable;
import java.io.IOException;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.SocketOption;
import java.net.StandardSocketOptions;
import java.nio.channels.SocketChannel;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.function.BiConsumer;
import org.cojen.dirmi.Pipe;
import org.cojen.dirmi.Remote;
import org.cojen.dirmi.RemoteException;
import org.cojen.dirmi.Session;
import org.cojen.dirmi.core.CoreSession;
import org.cojen.dirmi.core.CoreStubSupport;
import org.cojen.dirmi.core.ExceptionWrapper;
import org.cojen.dirmi.core.SkeletonMaker;
import org.cojen.dirmi.core.Stub;
import org.cojen.dirmi.core.StubMaker;
import org.cojen.dirmi.core.StubSupport;
import org.cojen.maker.ClassMaker;
import org.cojen.maker.Variable;

public final class CoreUtils {
    static final long PROTOCOL_V2 = 4052788960387224692L;
    static final Object MAKER_KEY = new Object();
    static final ThreadLocal<CoreSession> cCurrentSession = new ThreadLocal();

    public static void setOptions(Socket s) throws IOException {
        if (s.supportedOptions().contains(StandardSocketOptions.TCP_NODELAY)) {
            s.setOption(StandardSocketOptions.TCP_NODELAY, true);
        }
    }

    public static void setOptions(SocketChannel s) throws IOException {
        if (s.supportedOptions().contains(StandardSocketOptions.TCP_NODELAY)) {
            s.setOption((SocketOption)StandardSocketOptions.TCP_NODELAY, (Object)true);
        }
        s.configureBlocking(true);
    }

    public static Session accessSession(Object obj) {
        if (!(obj instanceof Stub)) {
            throw new IllegalArgumentException();
        }
        Stub stub = (Stub)obj;
        return Stub.cSupportHandle.getAcquire(stub).session();
    }

    public static Session currentSession() {
        Session session = cCurrentSession.get();
        if (session == null) {
            throw new IllegalStateException();
        }
        return session;
    }

    public static boolean dispose(Object obj) {
        if (!(obj instanceof Stub)) {
            throw new IllegalArgumentException();
        }
        Stub stub = (Stub)obj;
        StubSupport support = Stub.cSupportHandle.getAcquire(stub);
        if (support instanceof CoreStubSupport) {
            CoreStubSupport css = (CoreStubSupport)support;
            return css.session().stubDisposeAndNotify(stub, null);
        }
        return false;
    }

    public static boolean disposeServer(Object server) {
        CoreSession session = cCurrentSession.get();
        if (session == null) {
            throw new IllegalStateException();
        }
        return session.serverDispose(server);
    }

    static void allowAccess(ClassMaker cm) {
        Module thisModule = CoreUtils.class.getModule();
        Module thatModule = cm.classLoader().getUnnamedModule();
        thisModule.addExports("org.cojen.dirmi.core", thatModule);
    }

    static boolean isRemote(Class<?> clazz) {
        try {
            return Remote.class.isAssignableFrom(clazz) || java.rmi.Remote.class.isAssignableFrom(clazz);
        }
        catch (Throwable e) {
            return false;
        }
    }

    static boolean isUnchecked(Class<?> clazz) {
        return RuntimeException.class.isAssignableFrom(clazz) || Error.class.isAssignableFrom(clazz);
    }

    static List<Class<?>> reduceExceptions(Class<?> clazz, Collection<Class<?>> others) {
        ArrayList reduced = new ArrayList();
        reduced.add(clazz);
        if (others != null) {
            for (Class<?> other : others) {
                CoreUtils.reduceExceptions(reduced, other);
            }
        }
        CoreUtils.reduceExceptions(reduced, RuntimeException.class);
        CoreUtils.reduceExceptions(reduced, Error.class);
        return reduced;
    }

    private static void reduceExceptions(List<Class<?>> reduced, Class<?> clazz) {
        Iterator<Class<?>> it = reduced.iterator();
        while (it.hasNext()) {
            Class<?> ex = it.next();
            if (ex.isAssignableFrom(clazz)) {
                return;
            }
            if (!clazz.isAssignableFrom(ex)) continue;
            it.remove();
        }
        reduced.add(clazz);
    }

    static Class<?> loadClassByNameOrDescriptor(String name, ClassLoader loader) throws ClassNotFoundException {
        char first = name.charAt(0);
        if (first == '[') {
            return CoreUtils.loadClassByNameOrDescriptor(name.substring(1), loader).arrayType();
        }
        if (first == 'L' && name.endsWith(";")) {
            name = name.substring(1, name.length() - 1).replace('/', '.');
        } else {
            switch (name) {
                case "Z": {
                    return Boolean.TYPE;
                }
                case "C": {
                    return Character.TYPE;
                }
                case "F": {
                    return Float.TYPE;
                }
                case "D": {
                    return Double.TYPE;
                }
                case "B": {
                    return Byte.TYPE;
                }
                case "S": {
                    return Short.TYPE;
                }
                case "I": {
                    return Integer.TYPE;
                }
                case "J": {
                    return Long.TYPE;
                }
                case "V": {
                    return Void.TYPE;
                }
            }
        }
        return Class.forName(name, false, loader);
    }

    static boolean acceptException(BiConsumer<Session<?>, Throwable> h, Session<?> s, Throwable e) {
        if (h != null) {
            try {
                h.accept(s, e);
                return true;
            }
            catch (Throwable e2) {
                try {
                    e.addSuppressed(e2);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        }
        return false;
    }

    static int roundUpPower2(int i) {
        --i;
        i |= i >> 1;
        i |= i >> 2;
        i |= i >> 4;
        i |= i >> 8;
        return (i | i >> 16) + 1;
    }

    public static void closeQuietly(Closeable c) {
        try {
            if (c != null) {
                c.close();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static <T extends Throwable> T remoteException(Class<T> remoteFailureEx, Throwable cause) {
        return CoreUtils.remoteException((SocketAddress)null, remoteFailureEx, cause);
    }

    public static <T extends Throwable> T remoteException(StubSupport support, Class<T> remoteFailureEx, Throwable cause) {
        Session session = support == null ? null : support.session();
        return CoreUtils.remoteException(session, remoteFailureEx, cause);
    }

    public static <T extends Throwable> T remoteException(Session session, Class<T> remoteFailureEx, Throwable cause) {
        SocketAddress remoteAddress = session == null ? null : session.remoteAddress();
        return CoreUtils.remoteException(remoteAddress, remoteFailureEx, cause);
    }

    public static <T extends Throwable> T remoteException(SocketAddress remoteAddress, Class<T> remoteFailureEx, Throwable cause) {
        if (cause == null) {
            RemoteException re = new RemoteException();
            if (remoteAddress != null) {
                re.remoteAddress(remoteAddress);
            }
            cause = re;
        }
        Throwable actual = remoteFailureEx.isInstance(cause) ? cause : (remoteFailureEx == RemoteException.class ? new RemoteException(cause) : ExceptionWrapper.forClass(remoteFailureEx).wrap(cause, remoteAddress));
        if (remoteAddress != null && actual instanceof RemoteException) {
            RemoteException re = (RemoteException)actual;
            re.remoteAddress(remoteAddress);
        }
        return (T)actual;
    }

    public static RuntimeException rethrow(Throwable e) {
        CoreUtils.castAndThrow(e);
        return null;
    }

    private static <T extends Throwable> void castAndThrow(Throwable e) throws T {
        throw e;
    }

    public static MethodHandle findVirtual(MethodHandles.Lookup lookup, String name, Class type, Class clazz, MethodType mt) throws NoSuchMethodException, IllegalAccessException {
        return lookup.findVirtual(clazz, name, mt);
    }

    static void writeParam(Variable pipeVar, Variable paramVar) {
        Class type = paramVar.classType();
        if (type == null) {
            pipeVar.invoke("writeObject", new Object[]{paramVar});
        } else if (!type.isPrimitive()) {
            pipeVar.invoke("writeObject", new Object[]{paramVar});
        } else {
            String m;
            if (type == Integer.TYPE) {
                m = "writeInt";
            } else if (type == Long.TYPE) {
                m = "writeLong";
            } else if (type == Boolean.TYPE) {
                m = "writeBoolean";
            } else if (type == Double.TYPE) {
                m = "writeDouble";
            } else if (type == Float.TYPE) {
                m = "writeFloat";
            } else if (type == Byte.TYPE) {
                m = "writeByte";
            } else if (type == Character.TYPE) {
                m = "writeChar";
            } else if (type == Short.TYPE) {
                m = "writeShort";
            } else {
                throw new AssertionError();
            }
            pipeVar.invoke(m, new Object[]{paramVar});
        }
    }

    static void readParam(Variable pipeVar, Variable paramVar) {
        Class type = paramVar.classType();
        if (type == null) {
            paramVar.set((Object)pipeVar.invoke("readObject", new Object[0]).cast((Object)paramVar));
        } else if (!type.isPrimitive()) {
            Variable objectVar = pipeVar.invoke("readObject", new Object[0]);
            paramVar.set((Object)(type == Object.class ? objectVar : objectVar.cast((Object)type)));
        } else {
            String m;
            if (type == Integer.TYPE) {
                m = "readInt";
            } else if (type == Long.TYPE) {
                m = "readLong";
            } else if (type == Boolean.TYPE) {
                m = "readBoolean";
            } else if (type == Double.TYPE) {
                m = "readDouble";
            } else if (type == Float.TYPE) {
                m = "readFloat";
            } else if (type == Byte.TYPE) {
                m = "readByte";
            } else if (type == Character.TYPE) {
                m = "readChar";
            } else if (type == Short.TYPE) {
                m = "readShort";
            } else {
                throw new AssertionError();
            }
            paramVar.set((Object)pipeVar.invoke(m, new Object[0]));
        }
    }

    static void writeIntId(Variable pipeVar, int max, Variable idVar) {
        if (max < 256) {
            pipeVar.invoke("writeByte", new Object[]{idVar});
        } else if (max < 65536) {
            pipeVar.invoke("writeShort", new Object[]{idVar});
        } else {
            pipeVar.invoke("writeInt", new Object[]{idVar});
        }
    }

    static Variable readIntId(Variable pipeVar, int max) {
        Variable methodIdVar = pipeVar.methodMaker().var(Integer.TYPE);
        if (max < 256) {
            methodIdVar.set((Object)pipeVar.invoke("readUnsignedByte", new Object[0]));
        } else if (max < 65536) {
            methodIdVar.set((Object)pipeVar.invoke("readUnsignedShort", new Object[0]));
        } else {
            methodIdVar.set((Object)pipeVar.invoke("readInt", new Object[0]));
        }
        return methodIdVar;
    }

    static boolean anyObjectTypes(Object[] ptypes) {
        for (Object ptype : ptypes) {
            if (!CoreUtils.isObjectType(ptype)) continue;
            return true;
        }
        return false;
    }

    static boolean anyObjectTypes(List<?> ptypes) {
        for (Object ptype : ptypes) {
            if (!CoreUtils.isObjectType(ptype)) continue;
            return true;
        }
        return false;
    }

    static boolean isObjectType(Object type) {
        if (type instanceof Class) {
            return !((Class)type).isPrimitive();
        }
        if (type instanceof Variable) {
            Class ctype = ((Variable)type).classType();
            return ctype == null || !ctype.isPrimitive();
        }
        char first = ((String)type).charAt(0);
        return first == 'L' || first == '[';
    }

    static void assignTrace(Pipe pipe, Throwable ex) {
        StackTraceElement[] trace = ex.getStackTrace();
        int traceLength = trace.length;
        String fileName = SkeletonMaker.class.getSimpleName();
        int i = trace.length;
        while (--i >= 0) {
            StackTraceElement element = trace[i];
            if (!fileName.equals(element.getFileName())) continue;
            traceLength = i;
            break;
        }
        StackTraceElement[] stitch = CoreUtils.stitch(pipe);
        StackTraceElement[] local = new Throwable().getStackTrace();
        int localStart = 0;
        if (local.length != 0) {
            localStart = 1;
        }
        fileName = StubMaker.class.getSimpleName();
        for (int i2 = 0; i2 < local.length; ++i2) {
            StackTraceElement element = local[i2];
            if (!fileName.equals(element.getFileName())) continue;
            localStart = i2;
            break;
        }
        int localLength = local.length - localStart;
        StackTraceElement[] combined = new StackTraceElement[traceLength + stitch.length + localLength];
        System.arraycopy(trace, 0, combined, 0, traceLength);
        System.arraycopy(stitch, 0, combined, traceLength, stitch.length);
        System.arraycopy(local, localStart, combined, traceLength + stitch.length, localLength);
        ex.setStackTrace(combined);
    }

    private static StackTraceElement[] stitch(Pipe pipe) {
        StackTraceElement remote = CoreUtils.trace(pipe.remoteAddress());
        StackTraceElement local = CoreUtils.trace(pipe.localAddress());
        if (remote == null) {
            if (local == null) {
                local = new StackTraceElement("...remote method invocation..", "", "no address", -1);
            }
            return new StackTraceElement[]{local};
        }
        if (local == null) {
            return new StackTraceElement[]{remote};
        }
        return new StackTraceElement[]{remote, local};
    }

    private static StackTraceElement trace(SocketAddress address) {
        String str;
        if (address == null || (str = address.toString()).isEmpty()) {
            return null;
        }
        return new StackTraceElement("...remote method invocation..", "", str, -1);
    }
}

