/*
 * Decompiled with CFR 0.152.
 */
package org.cojen.dirmi.core;

import org.cojen.dirmi.DisposedException;
import org.cojen.dirmi.Pipe;
import org.cojen.dirmi.core.CoreSession;
import org.cojen.dirmi.core.CoreUtils;
import org.cojen.dirmi.core.Stub;
import org.cojen.dirmi.core.StubSupport;

final class DisposedStubSupport
implements StubSupport {
    static final String EXPLICIT_MESSAGE = "Object is disposed";
    static final DisposedStubSupport EXPLICIT = new DisposedStubSupport("Object is disposed");
    private final CoreSession<?> mSession;
    private final String mMessage;
    private final Throwable mCause;
    private final boolean mRestorable;

    static DisposedStubSupport newDisconnected(CoreSession<?> session) {
        String message = "Object is disposed due to session disconnect";
        return new DisposedStubSupport(session, message, null, false);
    }

    static DisposedStubSupport newLenientRestorable(CoreSession<?> session, Throwable cause) {
        String message = "Object is disposed due to session disconnect";
        return new DisposedStubSupport(session, message, cause, true);
    }

    DisposedStubSupport(String message) {
        this(null, message, null, false);
    }

    private DisposedStubSupport(CoreSession<?> session, String message, Throwable cause, boolean restorable) {
        this.mSession = session;
        this.mMessage = message;
        this.mCause = cause;
        this.mRestorable = restorable;
    }

    @Override
    public CoreSession<?> session() {
        if (this.mSession == null) {
            throw new IllegalStateException(this.mMessage);
        }
        return this.mSession;
    }

    @Override
    public boolean isLenientRestorable() {
        return this.mSession != null && this.mRestorable;
    }

    @Override
    public void appendInfo(StringBuilder b) {
        b.append(", disposed=").append(true);
    }

    @Override
    public <T extends Throwable> Pipe connect(Stub stub, Class<T> remoteFailureException) throws T {
        DisposedException ex;
        if (this.mCause == null) {
            ex = new DisposedException(this.mMessage);
        } else {
            String causeMessage = this.mCause.getMessage();
            if (causeMessage == null || causeMessage.isEmpty()) {
                causeMessage = this.mCause.toString();
            }
            ex = new DisposedException(this.mMessage + " (" + causeMessage + ")", this.mCause);
        }
        throw CoreUtils.remoteException(remoteFailureException, ex);
    }

    @Override
    public <T extends Throwable> Pipe connectUnbatched(Stub stub, Class<T> remoteFailureException) throws T {
        return this.connect(stub, remoteFailureException);
    }

    @Override
    public <T extends Throwable> Pipe tryConnect(Stub stub, Class<T> remoteFailureException) throws T {
        return this.mSession == null ? this.connect(stub, remoteFailureException) : null;
    }

    @Override
    public <T extends Throwable> Pipe tryConnectUnbatched(Stub stub, Class<T> remoteFailureException) throws T {
        return this.tryConnect(stub, remoteFailureException);
    }

    @Override
    public boolean validate(Stub stub, Pipe pipe) {
        return true;
    }

    @Override
    public long remoteTypeId(Class<?> type) {
        throw new IllegalStateException();
    }

    @Override
    public <T extends Throwable> Object newAliasStub(Class<T> remoteFailureException, long aliasId, long typeId) {
        throw new IllegalStateException();
    }

    @Override
    public Stub newDisconnectedStub(Class<?> type, Throwable cause) {
        return ((CoreSession)this.session()).newDisconnectedStub(type, cause);
    }

    @Override
    public boolean isBatching(Pipe pipe) {
        return false;
    }

    @Override
    public boolean finishBatch(Pipe pipe) {
        return false;
    }

    @Override
    public Throwable readResponse(Pipe pipe) {
        return null;
    }

    @Override
    public void finished(Pipe pipe) {
    }

    @Override
    public void batched(Pipe pipe) {
    }

    @Override
    public <T extends Throwable> T failed(Class<T> remoteFailureException, Pipe pipe, Throwable cause) {
        return CoreUtils.remoteException(remoteFailureException, cause);
    }

    @Override
    public void dispose(Stub stub) {
        Stub.cSupportHandle.setRelease(stub, this);
    }
}

