/*
 * Decompiled with CFR 0.152.
 */
package org.cojen.dirmi.core;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketAddress;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.util.Arrays;
import java.util.IdentityHashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.PriorityQueue;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.BiConsumer;
import java.util.function.Predicate;
import org.cojen.dirmi.ClassResolver;
import org.cojen.dirmi.ClosedException;
import org.cojen.dirmi.Connector;
import org.cojen.dirmi.Environment;
import org.cojen.dirmi.NoSuchObjectException;
import org.cojen.dirmi.RemoteException;
import org.cojen.dirmi.Serializer;
import org.cojen.dirmi.Session;
import org.cojen.dirmi.SessionAware;
import org.cojen.dirmi.core.BufferedPipe;
import org.cojen.dirmi.core.ClientSession;
import org.cojen.dirmi.core.CloseTimeout;
import org.cojen.dirmi.core.CorePipe;
import org.cojen.dirmi.core.CoreSession;
import org.cojen.dirmi.core.CoreUtils;
import org.cojen.dirmi.core.ItemMap;
import org.cojen.dirmi.core.RemoteExaminer;
import org.cojen.dirmi.core.RemoteInfo;
import org.cojen.dirmi.core.Scheduled;
import org.cojen.dirmi.core.ServerSession;
import org.cojen.dirmi.core.Settings;
import org.cojen.dirmi.core.TypeCodeMap;
import org.cojen.dirmi.io.CaptureOutputStream;

public final class Engine
implements Environment {
    private final Lock mMainLock = new ReentrantLock();
    private volatile Settings mSettings = new Settings();
    private final Executor mExecutor;
    private final boolean mOwnsExecutor;
    private final Lock mSchedulerLock;
    private final Condition mSchedulerCondition;
    private final PriorityQueue<Scheduled> mScheduledQueue;
    private boolean mSchedulerRunning;
    private volatile ItemMap<ServerSession> mServerSessions;
    private volatile ItemMap<ClientSession> mClientSessions;
    private volatile ConcurrentSkipListMap<byte[], Object> mExports;
    private Map<Object, Acceptor> mAcceptors;
    private volatile BiConsumer<Session<?>, Throwable> mUncaughtExceptionHandler;
    private Connector mConnector;
    private static final VarHandle cConnectorHandle;
    private static final VarHandle cStateHandle;

    public Engine() {
        this(null);
    }

    public Engine(Executor executor) {
        if (executor == null) {
            this.mExecutor = Executors.newCachedThreadPool(TFactory.THE);
            this.mOwnsExecutor = true;
        } else {
            this.mExecutor = executor;
            this.mOwnsExecutor = false;
        }
        this.mSchedulerLock = new ReentrantLock();
        this.mSchedulerCondition = this.mSchedulerLock.newCondition();
        this.mScheduledQueue = new PriorityQueue();
        cConnectorHandle.setRelease(this, Connector.direct());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object export(Object name, Object obj) throws IOException {
        byte[] bname = Engine.binaryName(name);
        if (obj != null) {
            RemoteExaminer.remoteType(obj);
        }
        this.mMainLock.lock();
        try {
            this.checkClosed();
            ConcurrentSkipListMap<Object, Object> exports = this.mExports;
            if (exports == null) {
                this.mExports = exports = new ConcurrentSkipListMap(Arrays::compare);
            }
            Object object = obj == null ? exports.remove(bname) : exports.put(bname, obj);
            return object;
        }
        finally {
            this.mMainLock.unlock();
        }
    }

    @Override
    public Closeable acceptAll(ServerSocket ss, Predicate<Socket> listener) throws IOException {
        if (!ss.isBound()) {
            throw new IllegalStateException("Socket isn't bound");
        }
        return this.acceptAll((Object)ss, new SocketAcceptor(ss, listener));
    }

    @Override
    public Closeable acceptAll(ServerSocketChannel ss, Predicate<SocketChannel> listener) throws IOException {
        if (ss.getLocalAddress() == null) {
            throw new IllegalStateException("Socket isn't bound");
        }
        return this.acceptAll((Object)ss, new ChannelAcceptor(ss, listener));
    }

    private Closeable acceptAll(Object ss, Acceptor acceptor) throws IOException {
        this.mMainLock.lock();
        try {
            this.checkClosed();
            if (this.mAcceptors == null) {
                this.mAcceptors = new IdentityHashMap<Object, Acceptor>();
            }
            if (this.mAcceptors.putIfAbsent(ss, acceptor) != null) {
                throw new IllegalStateException("Already accepting connections from " + ss);
            }
        }
        finally {
            this.mMainLock.unlock();
        }
        try {
            Thread t = new Thread(acceptor);
            t.setName("DirmiAcceptor-" + t.getId());
            t.start();
        }
        catch (Throwable e) {
            acceptor.close();
            throw e;
        }
        return acceptor;
    }

    private void unregister(Object ss, Acceptor acceptor) {
        this.mMainLock.lock();
        try {
            if (this.mAcceptors != null) {
                this.mAcceptors.remove(ss, acceptor);
            }
        }
        finally {
            this.mMainLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Session<?> accepted(SocketAddress localAddr, SocketAddress remoteAddr, InputStream in, OutputStream out) throws IOException {
        ServerSession<Object> session;
        RemoteInfo serverInfo;
        int firstCustomTypeCode;
        this.checkClosed();
        CorePipe pipe = new CorePipe(localAddr, remoteAddr, in, out, 2);
        Settings settings = this.mSettings;
        int timeoutMillis = settings.pingTimeoutMillis;
        CloseTimeout timeoutTask = timeoutMillis < 0 ? null : new CloseTimeout(pipe);
        long clientSessionId = 0L;
        LinkedHashMap<String, Object> clientCustomTypes = null;
        try {
            Object root;
            long version;
            if (timeoutTask != null) {
                this.scheduleMillis(timeoutTask, timeoutMillis);
            }
            if ((version = pipe.readLong()) != 4052788960387224692L || (clientSessionId = pipe.readLong()) == 0L) {
                throw new RemoteException("Unsupported protocol");
            }
            long serverSessionId = pipe.readLong();
            if (serverSessionId != 0L) {
                ServerSession session2;
                block28: {
                    CloseTimeout.cancelOrFail(timeoutTask);
                    ItemMap<ServerSession> sessions = this.mServerSessions;
                    if (sessions != null) {
                        try {
                            session2 = sessions.get(serverSessionId);
                            break block28;
                        }
                        catch (NoSuchObjectException noSuchObjectException) {
                            // empty catch block
                        }
                    }
                    this.checkClosed();
                    throw new RemoteException("Unable to find existing session");
                }
                long csid = clientSessionId;
                clientSessionId = 0L;
                pipe.writeLong(4052788960387224692L);
                pipe.writeLong(csid);
                pipe.writeLong(serverSessionId);
                pipe.flush();
                session2.accepted(pipe);
                return session2;
            }
            Object name = pipe.readObject();
            RemoteInfo clientInfo = RemoteInfo.readFrom(pipe);
            firstCustomTypeCode = pipe.readUnsignedByte();
            if (firstCustomTypeCode != 0) {
                clientCustomTypes = Settings.readSerializerTypes(pipe);
            }
            Object metadata = pipe.readObject();
            ConcurrentSkipListMap<byte[], Object> exports = this.mExports;
            if (exports == null || (root = exports.get(Engine.binaryName(name))) == null) {
                throw new RemoteException("Unable to find exported object");
            }
            Class<?> rootType = RemoteExaminer.remoteType(root);
            serverInfo = RemoteInfo.examine(rootType);
            if (!clientInfo.isAssignableFrom(serverInfo)) {
                throw new RemoteException("Mismatched root object type");
            }
            session = new ServerSession<Object>(this, settings, root, pipe);
        }
        catch (Throwable e) {
            if (timeoutTask != null) {
                timeoutTask.cancel();
            }
            try {
                if (e instanceof RemoteException) {
                    RemoteException re = (RemoteException)e;
                    String message = re.getMessage();
                    re.remoteAddress(remoteAddr);
                    if (clientSessionId != 0L) {
                        pipe.writeLong(4052788960387224692L);
                        pipe.writeLong(clientSessionId);
                        pipe.writeLong(0L);
                        pipe.writeObject(message);
                        pipe.flush();
                    }
                }
                pipe.close();
            }
            catch (Throwable re) {
                // empty catch block
            }
            throw e;
        }
        session.mStateLock.lock();
        try {
            this.mMainLock.lock();
            try {
                this.checkClosed();
                ItemMap<ServerSession<Object>> sessions = this.mServerSessions;
                if (sessions == null) {
                    this.mServerSessions = sessions = new ItemMap();
                }
                sessions.put(session);
            }
            finally {
                this.mMainLock.unlock();
            }
            session.writeHeader(pipe, clientSessionId);
            serverInfo.writeTo(pipe);
            LinkedHashMap<String, Object> serverCustomTypes = settings.writeSerializerTypes(pipe);
            pipe.writeNull();
            pipe.flush();
            CloseTimeout.cancelOrFail(timeoutTask);
            TypeCodeMap tcm = settings.mergeSerializerTypes(firstCustomTypeCode, serverCustomTypes, clientCustomTypes);
            session.initTypeCodeMap(tcm);
            session.mState = Session.State.CONNECTED;
            session.controlPipe(pipe);
            session.startTasks();
            Object object = session.root();
            if (object instanceof SessionAware) {
                SessionAware sa = (SessionAware)object;
                session.attachNotify(sa);
            }
            ServerSession<Object> serverSession = session;
            return serverSession;
        }
        catch (Throwable e) {
            if (timeoutTask != null) {
                timeoutTask.cancel();
            }
            CoreUtils.closeQuietly(session);
            if (e instanceof RemoteException) {
                RemoteException re = (RemoteException)e;
                re.remoteAddress(remoteAddr);
            }
            throw e;
        }
        finally {
            session.mStateLock.unlock();
        }
    }

    @Override
    public <R> Session<R> connect(Class<R> type, Object name, SocketAddress addr) throws IOException {
        this.checkClosed();
        return this.doConnect(this.mSettings, true, type, Engine.binaryName(name), addr);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    <R> ClientSession<R> doConnect(Settings settings, boolean register, Class<R> type, byte[] bname, SocketAddress addr) throws IOException {
        this.checkClosed();
        RemoteInfo info = RemoteInfo.examine(type);
        ClientSession<R> session = new ClientSession<R>(this, settings, null, addr);
        CorePipe pipe = session.connect();
        int timeoutMillis = settings.pingTimeoutMillis;
        CloseTimeout timeoutTask = timeoutMillis < 0 ? null : new CloseTimeout(pipe);
        LinkedHashMap<String, Object> serverCustomTypes = null;
        try {
            if (timeoutTask != null) {
                this.scheduleMillis(timeoutTask, timeoutMillis);
            }
            session.writeHeader(pipe, 0L);
            pipe.write(bname);
            info.writeTo(pipe);
            LinkedHashMap<String, Object> clientCustomTypes = settings.writeSerializerTypes(pipe);
            pipe.writeNull();
            pipe.flush();
            long version = pipe.readLong();
            if (version != 4052788960387224692L || pipe.readLong() != session.id) {
                throw new RemoteException("Unsupported protocol");
            }
            long serverSessionId = pipe.readLong();
            if (serverSessionId == 0L) {
                Object message = pipe.readObject();
                throw new RemoteException(String.valueOf(message));
            }
            long rootId = pipe.readLong();
            long rootTypeId = pipe.readLong();
            RemoteInfo serverInfo = RemoteInfo.readFrom(pipe);
            int firstCustomTypeCode = pipe.readUnsignedByte();
            if (firstCustomTypeCode != 0) {
                serverCustomTypes = Settings.readSerializerTypes(pipe);
            }
            Object metadata = pipe.readObject();
            CloseTimeout.cancelOrFail(timeoutTask);
            session.init(serverSessionId, type, bname, rootTypeId, serverInfo, rootId);
            TypeCodeMap tcm = settings.mergeSerializerTypes(firstCustomTypeCode, clientCustomTypes, serverCustomTypes);
            session.initTypeCodeMap(tcm);
            session.controlPipe(pipe);
            if (register) {
                session.startTasks();
                this.mMainLock.lock();
                try {
                    this.checkClosed();
                    ItemMap<ClientSession<Object>> sessions = this.mClientSessions;
                    if (sessions == null) {
                        this.mClientSessions = sessions = new ItemMap();
                    }
                    sessions.put(session);
                }
                finally {
                    this.mMainLock.unlock();
                }
            }
            return session;
        }
        catch (Throwable e) {
            try {
                CloseTimeout.cancelOrFail(timeoutTask);
            }
            catch (Throwable e2) {
                e2.addSuppressed(e);
                e = e2;
            }
            session.close();
            CoreUtils.closeQuietly(pipe);
            if (e instanceof RemoteException) {
                RemoteException re = (RemoteException)e;
                re.remoteAddress(addr);
            }
            throw CoreUtils.rethrow(e);
        }
    }

    void reconnect(final Settings settings, final Class<?> type, final byte[] bname, final SocketAddress addr, final Predicate<Object> callback) {
        var task = new Scheduled(){
            private final Random mRnd = new Random();

            @Override
            public void run() {
                Object result;
                ClientSession session = null;
                try {
                    session = Engine.this.doConnect(settings, false, type, bname, addr);
                    result = session;
                }
                catch (Throwable e) {
                    try {
                        Engine.this.checkClosed();
                    }
                    catch (Throwable e2) {
                        callback.test(e2);
                        return;
                    }
                    result = e;
                }
                try {
                    if (!callback.test(result)) {
                        return;
                    }
                }
                catch (Throwable e) {
                    CoreUtils.closeQuietly(session);
                    throw e;
                }
                try {
                    this.schedule();
                }
                catch (Throwable e) {
                    callback.test(e);
                }
            }

            void schedule() throws IOException {
                long delay = settings.reconnectDelayMillis;
                long range = delay / 5L;
                if (range > 1L) {
                    long jitter = this.mRnd.nextLong(range);
                    jitter -= delay / 10L;
                    delay += jitter;
                }
                if (!Engine.this.scheduleMillis(this, delay)) {
                    Engine.this.checkClosed();
                    Engine.this.executeTask(this);
                }
            }
        };
        try {
            task.schedule();
        }
        catch (Throwable e) {
            callback.test(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Connector connector(Connector c) throws IOException {
        this.mMainLock.lock();
        try {
            Objects.requireNonNull(c);
            Connector old = this.checkClosed();
            cConnectorHandle.setRelease(this, c);
            Connector connector = old;
            return connector;
        }
        finally {
            this.mMainLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void customSerializers(Serializer ... serializers) {
        LinkedHashMap map;
        if (serializers == null || serializers.length == 0) {
            map = null;
        } else {
            map = new LinkedHashMap(serializers.length);
            for (Serializer serializer : serializers) {
                Set<Class<?>> types = serializer.supportedTypes();
                for (Class<?> type : types) {
                    Objects.requireNonNull(type);
                    map.putIfAbsent(type, serializer);
                }
            }
        }
        this.mMainLock.lock();
        try {
            this.mSettings = this.mSettings.withSerializers(map);
        }
        finally {
            this.mMainLock.unlock();
        }
    }

    @Override
    public void reconnectDelayMillis(int millis) {
        this.mMainLock.lock();
        try {
            this.mSettings = this.mSettings.withReconnectDelayMillis(millis);
        }
        finally {
            this.mMainLock.unlock();
        }
    }

    @Override
    public void pingTimeoutMillis(int millis) {
        this.mMainLock.lock();
        try {
            this.mSettings = this.mSettings.withPingTimeoutMillis(millis);
        }
        finally {
            this.mMainLock.unlock();
        }
    }

    @Override
    public void idleConnectionMillis(int millis) {
        this.mMainLock.lock();
        try {
            this.mSettings = this.mSettings.withIdleConnectionMillis(millis);
        }
        finally {
            this.mMainLock.unlock();
        }
    }

    @Override
    public void classResolver(ClassResolver resolver) {
        this.mMainLock.lock();
        try {
            this.mSettings = this.mSettings.withClassResolver(resolver);
        }
        finally {
            this.mMainLock.unlock();
        }
    }

    @Override
    public void uncaughtExceptionHandler(BiConsumer<Session<?>, Throwable> h) {
        this.mUncaughtExceptionHandler = h;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        Map<Object, Acceptor> acceptors;
        ItemMap<ClientSession> clientSessions;
        ItemMap<ServerSession> serverSessions;
        this.mMainLock.lock();
        try {
            if (this.mConnector == null) {
                return;
            }
            cConnectorHandle.setRelease(this, null);
            serverSessions = this.mServerSessions;
            this.mServerSessions = null;
            clientSessions = this.mClientSessions;
            this.mClientSessions = null;
            this.mExports = null;
            acceptors = this.mAcceptors;
            this.mAcceptors = null;
        }
        finally {
            this.mMainLock.unlock();
        }
        this.mSchedulerLock.lock();
        try {
            this.mScheduledQueue.clear();
            this.mSchedulerCondition.signal();
        }
        finally {
            this.mSchedulerLock.unlock();
        }
        if (acceptors != null) {
            for (Acceptor acceptor : acceptors.values()) {
                CoreUtils.closeQuietly(acceptor);
            }
        }
        Engine.closeAll(serverSessions);
        Engine.closeAll(clientSessions);
        if (this.mOwnsExecutor && this.mExecutor instanceof ExecutorService) {
            ((ExecutorService)this.mExecutor).shutdown();
        }
    }

    private static void closeAll(ItemMap<? extends CoreSession> sessions) {
        if (sessions != null) {
            sessions.forEach(CoreSession::close);
        }
    }

    void removeSession(ServerSession session) {
        ItemMap<ServerSession> sessions = this.mServerSessions;
        if (sessions != null) {
            sessions.remove(session);
        }
    }

    void removeSession(ClientSession session) {
        ItemMap<ClientSession> sessions = this.mClientSessions;
        if (sessions != null) {
            sessions.remove(session);
        }
    }

    void changeIdentity(ClientSession session, long newSessionId) {
        ItemMap<ClientSession> sessions = this.mClientSessions;
        if (sessions != null) {
            sessions.changeIdentity(session, newSessionId);
        }
    }

    @Override
    public void execute(Runnable command) {
        this.mExecutor.execute(command);
    }

    void executeTask(Runnable task) throws IOException {
        try {
            this.mExecutor.execute(task);
        }
        catch (Throwable e) {
            if (task instanceof Closeable) {
                CoreUtils.closeQuietly((Closeable)((Object)task));
            }
            this.checkClosed();
            throw new RemoteException(e);
        }
    }

    boolean tryExecuteTask(Runnable task) {
        try {
            this.mExecutor.execute(task);
            return true;
        }
        catch (Throwable e) {
            if (task instanceof Closeable) {
                CoreUtils.closeQuietly((Closeable)((Object)task));
            }
            return false;
        }
    }

    boolean scheduleMillis(Scheduled task, long delayMillis) throws IOException {
        return this.scheduleNanos(task, delayMillis * 1000000L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean scheduleNanos(Scheduled task, long delayNanos) throws IOException {
        task.mAtNanos = System.nanoTime() + delayNanos;
        this.mSchedulerLock.lock();
        try {
            if (this.isClosed()) {
                boolean bl = false;
                return bl;
            }
            this.mScheduledQueue.add(task);
            if (!this.mSchedulerRunning) {
                this.executeTask(this::runScheduledTasks);
                this.mSchedulerRunning = true;
            } else if (this.mScheduledQueue.peek() == task) {
                this.mSchedulerCondition.signal();
            }
            boolean bl = true;
            return bl;
        }
        finally {
            this.mSchedulerLock.unlock();
        }
    }

    private void runScheduledTasks() {
        while (true) {
            Scheduled task;
            this.mSchedulerLock.lock();
            try {
                while (true) {
                    if ((task = this.mScheduledQueue.peek()) == null) {
                        this.mSchedulerRunning = false;
                        return;
                    }
                    long delayNanos = task.mAtNanos - System.nanoTime();
                    if (delayNanos <= 0L) break;
                    try {
                        this.mSchedulerCondition.awaitNanos(delayNanos);
                    }
                    catch (InterruptedException interruptedException) {}
                }
                if (task != this.mScheduledQueue.remove()) {
                    throw new AssertionError();
                }
            }
            catch (Throwable e) {
                this.mSchedulerRunning = false;
                throw e;
            }
            finally {
                this.mSchedulerLock.unlock();
            }
            try {
                this.mExecutor.execute(task);
            }
            catch (Throwable e) {
                if (task instanceof Closeable) {
                    CoreUtils.closeQuietly((Closeable)((Object)task));
                }
                if (!this.isClosed()) {
                    this.uncaught(null, e);
                }
                return;
            }
        }
    }

    Connector checkClosed() throws IOException {
        Connector c = cConnectorHandle.getAcquire(this);
        if (c == null) {
            throw new ClosedException("Environment is closed");
        }
        return c;
    }

    boolean isClosed() {
        return cConnectorHandle.getAcquire(this) == null;
    }

    void uncaught(Session<?> s, Throwable e) {
        if (!CoreUtils.acceptException(this.mUncaughtExceptionHandler, s, e)) {
            try {
                Thread t = Thread.currentThread();
                t.getUncaughtExceptionHandler().uncaughtException(t, e);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    private void acceptFailed(Throwable e) {
        if (!this.isClosed()) {
            this.uncaught(null, e);
        }
    }

    private static byte[] binaryName(Object name) {
        try {
            CaptureOutputStream capture = new CaptureOutputStream();
            BufferedPipe pipe = new BufferedPipe(InputStream.nullInputStream(), capture);
            pipe.writeObject(name);
            pipe.flush();
            return capture.getBytes();
        }
        catch (IOException e) {
            throw new AssertionError((Object)e);
        }
    }

    static {
        MethodHandles.Lookup lookup;
        try {
            lookup = MethodHandles.lookup();
            cConnectorHandle = lookup.findVarHandle(Engine.class, "mConnector", Connector.class);
        }
        catch (Throwable e) {
            throw CoreUtils.rethrow(e);
        }
        try {
            lookup = MethodHandles.lookup();
            cStateHandle = lookup.findVarHandle(Acceptor.class, "mState", Integer.TYPE);
        }
        catch (Throwable e) {
            throw CoreUtils.rethrow(e);
        }
    }

    private static final class TFactory
    implements ThreadFactory {
        static final TFactory THE = new TFactory();

        private TFactory() {
        }

        @Override
        public Thread newThread(Runnable r) {
            Thread t = new Thread(r);
            t.setDaemon(true);
            t.setName("Dirmi-" + t.getId());
            return t;
        }
    }

    private final class SocketAcceptor
    extends Acceptor {
        private final ServerSocket mSocket;
        private final Predicate<Socket> mListener;

        SocketAcceptor(ServerSocket socket, Predicate<Socket> listener) {
            this.mSocket = socket;
            this.mListener = listener;
        }

        @Override
        public void run() {
            if (!this.start()) {
                return;
            }
            while (!this.isClosed()) {
                try {
                    Socket s = this.mSocket.accept();
                    this.acceptedTask(s);
                    s = null;
                }
                catch (Throwable e) {
                    if (this.isClosed()) {
                        return;
                    }
                    Engine.this.acceptFailed(e);
                    if (this.mSocket.isClosed()) {
                        this.close();
                        return;
                    }
                    Thread.yield();
                }
            }
        }

        private void acceptedTask(Socket s) throws IOException {
            Engine.this.executeTask(() -> {
                block4: {
                    try {
                        if (this.mListener == null || this.mListener.test(s)) {
                            Engine.this.accepted(s);
                        } else {
                            CoreUtils.closeQuietly(s);
                        }
                    }
                    catch (Throwable e) {
                        CoreUtils.closeQuietly(s);
                        if (e instanceof IOException) break block4;
                        Engine.this.acceptFailed(e);
                    }
                }
            });
        }

        @Override
        public void close() {
            this.doClose(this.mSocket);
        }
    }

    private abstract class Acceptor
    implements Closeable,
    Runnable {
        private volatile int mState;

        private Acceptor() {
        }

        final boolean start() {
            return cStateHandle.compareAndSet(this, 0, 1);
        }

        final boolean isClosed() {
            if (this.mState < 0) {
                return true;
            }
            if (Engine.this.isClosed()) {
                CoreUtils.closeQuietly(this);
                return true;
            }
            return false;
        }

        final void doClose(Closeable ss) {
            this.mState = -1;
            Engine.this.unregister(ss, this);
            CoreUtils.closeQuietly(ss);
        }
    }

    private final class ChannelAcceptor
    extends Acceptor {
        private final ServerSocketChannel mChannel;
        private final Predicate<SocketChannel> mListener;

        ChannelAcceptor(ServerSocketChannel channel, Predicate<SocketChannel> listener) throws IOException {
            this.mChannel = channel;
            channel.configureBlocking(true);
            this.mListener = listener;
        }

        @Override
        public void run() {
            if (!this.start()) {
                return;
            }
            while (!this.isClosed()) {
                try {
                    SocketChannel s = this.mChannel.accept();
                    this.acceptedTask(s);
                    s = null;
                }
                catch (Throwable e) {
                    if (this.isClosed()) {
                        return;
                    }
                    Engine.this.acceptFailed(e);
                    if (!this.mChannel.isOpen()) {
                        this.close();
                        return;
                    }
                    Thread.yield();
                }
            }
        }

        private void acceptedTask(SocketChannel s) throws IOException {
            Engine.this.executeTask(() -> {
                block4: {
                    try {
                        if (this.mListener == null || this.mListener.test(s)) {
                            Engine.this.accepted(s);
                        } else {
                            CoreUtils.closeQuietly(s);
                        }
                    }
                    catch (Throwable e) {
                        CoreUtils.closeQuietly(s);
                        if (e instanceof IOException) break block4;
                        Engine.this.acceptFailed(e);
                    }
                }
            });
        }

        @Override
        public void close() {
            this.doClose(this.mChannel);
        }
    }
}

