/*
 * Decompiled with CFR 0.152.
 */
package org.cojen.dirmi.core;

import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.reflect.Modifier;
import java.lang.reflect.UndeclaredThrowableException;
import org.cojen.dirmi.core.SoftCache;
import org.cojen.maker.ClassMaker;
import org.cojen.maker.Label;
import org.cojen.maker.MethodMaker;
import org.cojen.maker.Variable;

abstract class ExceptionWrapper {
    private static final SoftCache<Class<?>, ExceptionWrapper> cCache = new SoftCache();

    ExceptionWrapper() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static ExceptionWrapper forClass(Class<?> exceptionType) {
        ExceptionWrapper wrapper = cCache.get(exceptionType);
        if (wrapper == null) {
            SoftCache<Class<?>, ExceptionWrapper> softCache = cCache;
            synchronized (softCache) {
                wrapper = cCache.get(exceptionType);
                if (wrapper == null) {
                    wrapper = ExceptionWrapper.makeWrapper(exceptionType);
                    cCache.put(exceptionType, wrapper);
                }
            }
        }
        return wrapper;
    }

    abstract <T extends Throwable> T wrap(Throwable var1, Object var2);

    private static ExceptionWrapper makeWrapper(Class<?> exceptionType) {
        int style;
        block17: {
            if (Modifier.isPublic(exceptionType.getModifiers())) {
                try {
                    exceptionType.getConstructor(String.class, Throwable.class);
                    style = 1;
                    break block17;
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    try {
                        exceptionType.getConstructor(String.class);
                        style = 2;
                        break block17;
                    }
                    catch (NoSuchMethodException noSuchMethodException2) {
                        try {
                            exceptionType.getConstructor(Throwable.class);
                            style = 3;
                            break block17;
                        }
                        catch (NoSuchMethodException noSuchMethodException3) {
                            try {
                                exceptionType.getConstructor(new Class[0]);
                                style = 4;
                                break block17;
                            }
                            catch (NoSuchMethodException noSuchMethodException4) {
                                // empty catch block
                            }
                        }
                    }
                }
            }
            return Rethrow.THE;
        }
        ClassMaker cm = ClassMaker.begin(null, (MethodHandles.Lookup)MethodHandles.lookup());
        cm.extend(ExceptionWrapper.class).addConstructor(new Object[0]);
        MethodMaker mm = cm.addMethod(Throwable.class, "wrap", new Object[]{Throwable.class, Object.class});
        switch (style) {
            case 1: {
                Variable messageVar = mm.var(String.class).invoke("valueOf", new Object[]{mm.param(0)});
                ExceptionWrapper.appendToMessage(messageVar, mm.param(1));
                mm.return_((Object)mm.new_(exceptionType, new Object[]{messageVar, mm.param(0)}));
                break;
            }
            case 2: {
                Variable messageVar = mm.var(String.class).invoke("valueOf", new Object[]{mm.param(0)});
                ExceptionWrapper.appendToMessage(messageVar, mm.param(1));
                ExceptionWrapper.initCauseAndReturn(mm.new_(exceptionType, new Object[]{messageVar}));
                break;
            }
            case 3: {
                mm.return_((Object)mm.new_(exceptionType, new Object[]{mm.param(0)}));
                break;
            }
            case 4: {
                ExceptionWrapper.initCauseAndReturn(mm.new_(exceptionType, new Object[0]));
                break;
            }
            default: {
                throw new AssertionError();
            }
        }
        MethodHandles.Lookup lookup = cm.finishHidden();
        Class<?> clazz = lookup.lookupClass();
        try {
            return lookup.findConstructor(clazz, MethodType.methodType(Void.TYPE)).invoke();
        }
        catch (Throwable e) {
            throw new AssertionError((Object)e);
        }
    }

    private static void appendToMessage(Variable messageVar, Variable extraMessageVar) {
        MethodMaker mm = extraMessageVar.methodMaker();
        Label noMessage = mm.label();
        extraMessageVar.ifEq(null, noMessage);
        messageVar.set((Object)mm.concat(new Object[]{messageVar, " (", extraMessageVar, Character.valueOf(')')}));
        noMessage.here();
    }

    private static void initCauseAndReturn(Variable exVar) {
        MethodMaker mm = exVar.methodMaker();
        Label tryStart = mm.label().here();
        exVar.invoke("initCause", new Object[]{mm.param(0)});
        mm.return_((Object)exVar);
        Label tryEnd = mm.label().here();
        mm.catch_(tryStart, tryEnd, Throwable.class);
        mm.return_((Object)exVar);
    }

    private static final class Rethrow
    extends ExceptionWrapper {
        static final Rethrow THE = new Rethrow();

        private Rethrow() {
        }

        @Override
        <T extends Throwable> T wrap(Throwable cause, Object extraMessage) {
            if (cause instanceof RuntimeException | cause instanceof Error) {
                return (T)cause;
            }
            Object message = cause.toString();
            if (extraMessage != null) {
                message = (String)message + " (" + extraMessage + ")";
            }
            return (T)new UndeclaredThrowableException(cause, (String)message);
        }
    }
}

