/*
 * Decompiled with CFR 0.152.
 */
package org.cojen.dirmi.core;

import java.security.SecureRandom;

final class IdGenerator {
    private static final long sequenceMask;
    private static long sequence;

    IdGenerator() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    static long next() {
        long id;
        do {
            Class<IdGenerator> clazz = IdGenerator.class;
            // MONITORENTER : org.cojen.dirmi.core.IdGenerator.class
            id = sequence;
            sequence = id + 1L;
            // MONITOREXIT : clazz
        } while ((id = IdGenerator.scramble(id) ^ sequenceMask) == 0L);
        return id;
    }

    static long nextPositive() {
        long id;
        while ((id = IdGenerator.next()) <= 0L) {
        }
        return id;
    }

    static long nextNegative() {
        long id;
        while ((id = IdGenerator.next()) >= 0L) {
        }
        return id;
    }

    private static long scramble(long v) {
        v = (v << 21) - v - 1L;
        v ^= v >>> 24;
        v = v + (v << 3) + (v << 8);
        v ^= v >>> 14;
        v = v + (v << 2) + (v << 4);
        v ^= v >>> 28;
        return v + (v << 31);
    }

    static {
        SecureRandom rnd = new SecureRandom();
        sequenceMask = rnd.nextLong();
        sequence = rnd.nextLong();
    }
}

