/*
 * Decompiled with CFR 0.152.
 */
package org.cojen.dirmi.core;

import java.lang.invoke.VarHandle;
import java.util.Arrays;
import java.util.function.Consumer;
import java.util.function.Predicate;
import org.cojen.dirmi.NoSuchObjectException;
import org.cojen.dirmi.core.Item;

class ItemMap<I extends Item> {
    static final int INITIAL_CAPACITY = 8;
    protected Item[] mItems = new Item[8];
    protected int mSize;

    ItemMap() {
    }

    synchronized int size() {
        return this.mSize;
    }

    synchronized void clear() {
        Arrays.fill(this.mItems, null);
        this.mSize = 0;
    }

    final synchronized I put(I item) {
        Item[] items = this.mItems;
        int slot = (int)((Item)item).id & items.length - 1;
        Item it = items[slot];
        Item prev = null;
        while (it != null) {
            if (it == item) {
                return item;
            }
            Item next = it.mNext;
            if (it.id == ((Item)item).id) {
                if (prev == null) {
                    ((Item)item).mNext = next;
                } else {
                    prev.mNext = next;
                    ((Item)item).mNext = items[slot];
                }
                VarHandle.storeStoreFence();
                items[slot] = item;
                it.mNext = null;
                return (I)it;
            }
            prev = it;
            it = next;
        }
        this.doPut(items, item, slot);
        return null;
    }

    final synchronized I putIfAbsent(I item) {
        Item[] items = this.mItems;
        int slot = (int)((Item)item).id & items.length - 1;
        Item it = items[slot];
        while (it != null) {
            if (it == item) {
                return item;
            }
            if (it.id == ((Item)item).id) {
                return (I)it;
            }
            it = it.mNext;
        }
        this.doPut(items, item, slot);
        return item;
    }

    protected final void doPut(Item[] items, I item, int slot) {
        int size = this.mSize;
        if (size + (size >> 1) >= items.length && this.grow()) {
            items = this.mItems;
            slot = (int)((Item)item).id & items.length - 1;
        }
        ((Item)item).mNext = items[slot];
        VarHandle.storeStoreFence();
        items[slot] = item;
        this.mSize = size + 1;
    }

    final I tryGet(long id) {
        Item[] items = this.mItems;
        Item it = items[(int)id & items.length - 1];
        while (it != null) {
            if (it.id == id) {
                return (I)it;
            }
            it = it.mNext;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final I get(long id) throws NoSuchObjectException {
        Item[] items = this.mItems;
        Item it = items[(int)id & items.length - 1];
        while (it != null) {
            if (it.id == id) {
                return (I)it;
            }
            it = it.mNext;
        }
        ItemMap itemMap = this;
        synchronized (itemMap) {
            items = this.mItems;
            Item it2 = items[(int)id & items.length - 1];
            while (it2 != null) {
                if (it2.id == id) {
                    return (I)it2;
                }
                it2 = it2.mNext;
            }
        }
        throw new NoSuchObjectException(id);
    }

    synchronized I remove(long id) {
        Item[] items = this.mItems;
        int slot = (int)id & items.length - 1;
        Item it = items[slot];
        Item prev = null;
        while (it != null) {
            Item next = it.mNext;
            if (it.id == id) {
                if (prev == null) {
                    items[slot] = next;
                } else {
                    prev.mNext = next;
                }
                --this.mSize;
                it.mNext = null;
                return (I)it;
            }
            prev = it;
            it = next;
        }
        return null;
    }

    final I remove(I item) {
        return this.remove((I)((Item)item).id);
    }

    final synchronized I changeIdentity(I item, long newId) {
        this.remove(item);
        Item.cIdHandle.setRelease((Item)item, newId);
        return this.putIfAbsent(item);
    }

    final synchronized I stealIdentity(I item, I from) {
        this.remove(from);
        return this.changeIdentity(item, ((Item)from).id);
    }

    final synchronized void moveAll(ItemMap<I> from) {
        from.forEachToRemove(item -> {
            this.putIfAbsent(item);
            return true;
        });
    }

    final synchronized void forEach(Consumer<I> action) {
        Item[] items = this.mItems;
        for (int i = 0; i < items.length; ++i) {
            Item it = items[i];
            while (it != null) {
                action.accept(it);
                it = it.mNext;
            }
        }
    }

    final synchronized void forEachToRemove(Predicate<I> action) {
        Item[] items = this.mItems;
        for (int i = 0; i < items.length; ++i) {
            Item it = items[i];
            Item prev = null;
            while (it != null) {
                Item next = it.mNext;
                if (action.test(it)) {
                    if (prev == null) {
                        items[i] = next;
                    } else {
                        prev.mNext = next;
                    }
                    --this.mSize;
                } else {
                    prev = it;
                }
                it = next;
            }
        }
    }

    private boolean grow() {
        Item[] items = this.mItems;
        int capacity = items.length << 1;
        if (capacity < 0) {
            return false;
        }
        Item[] newItems = new Item[capacity];
        for (int i = 0; i < items.length; ++i) {
            Item it = items[i];
            while (it != null) {
                Item next = it.mNext;
                int slot = (int)it.id & newItems.length - 1;
                it.mNext = newItems[slot];
                newItems[slot] = it;
                it = next;
            }
        }
        this.mItems = newItems;
        return true;
    }
}

