/*
 * Decompiled with CFR 0.152.
 */
package org.cojen.dirmi.core;

import java.util.Iterator;
import java.util.NoSuchElementException;

final class JoinedIterator<E extends Comparable<E>>
implements Iterator<Pair<E>> {
    private final Iterator<E> aIt;
    private final Iterator<E> bIt;
    private E aElement;
    private E bElement;
    private Pair<E> pair;

    JoinedIterator(Iterator<E> a, Iterator<E> b) {
        this.aIt = a;
        this.bIt = b;
    }

    JoinedIterator(Iterable<E> a, Iterable<E> b) {
        this(a.iterator(), b.iterator());
    }

    @Override
    public boolean hasNext() {
        return this.pair != null || this.prepareNext();
    }

    private boolean prepareNext() {
        int cmp;
        Object ae = this.aElement;
        Object be = this.bElement;
        if (ae == null && this.aIt.hasNext()) {
            this.aElement = ae = (Comparable)this.aIt.next();
        }
        if (be == null && this.bIt.hasNext()) {
            this.bElement = be = (Comparable)this.bIt.next();
        }
        if (ae == null) {
            if (be == null) {
                return false;
            }
            cmp = 1;
        } else {
            cmp = be == null ? -1 : ae.compareTo(be);
        }
        this.pair = new Pair();
        if (cmp <= 0) {
            this.pair.a = ae;
            this.aElement = null;
        }
        if (cmp >= 0) {
            this.pair.b = be;
            this.bElement = null;
        }
        return true;
    }

    @Override
    public Pair<E> next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        Pair<E> pair = this.pair;
        this.pair = null;
        return pair;
    }

    static final class Pair<E extends Comparable<E>> {
        E a;
        E b;

        Pair() {
        }
    }
}

