/*
 * Decompiled with CFR 0.152.
 */
package org.cojen.dirmi.core;

import java.io.IOException;
import org.cojen.dirmi.Connector;
import org.cojen.dirmi.Environment;
import org.cojen.dirmi.Session;
import org.cojen.dirmi.core.CoreSession;
import org.cojen.dirmi.core.CoreUtils;
import org.cojen.dirmi.core.Engine;
import org.cojen.dirmi.io.PipedInputStream;
import org.cojen.dirmi.io.PipedOutputStream;

public final class LocalConnector
implements Connector {
    private final Environment mEnv;

    public LocalConnector(Environment env) {
        this.mEnv = env;
    }

    public void connect(Session session) throws IOException {
        PipedInputStream clientIn = new PipedInputStream();
        PipedOutputStream serverOut = new PipedOutputStream(clientIn);
        PipedOutputStream clientOut = new PipedOutputStream();
        PipedInputStream serverIn = new PipedInputStream(clientOut);
        session.execute(() -> {
            try {
                this.mEnv.accepted(null, null, serverIn, serverOut);
            }
            catch (Throwable e) {
                if (session instanceof CoreSession) {
                    ((CoreSession)session).uncaught(e);
                }
                if (this.mEnv instanceof Engine) {
                    ((Engine)this.mEnv).uncaught(null, e);
                }
                CoreUtils.rethrow(e);
            }
        });
        session.connected(null, null, clientIn, clientOut);
    }
}

