/*
 * Decompiled with CFR 0.152.
 */
package org.cojen.dirmi.core;

import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import org.cojen.dirmi.Pipe;
import org.cojen.dirmi.UnimplementedException;
import org.cojen.dirmi.core.CoreUtils;
import org.cojen.dirmi.core.IntArrayKey;
import org.cojen.dirmi.core.MethodIdWriter;
import org.cojen.dirmi.core.RemoteInfo;
import org.cojen.dirmi.core.SoftCache;
import org.cojen.maker.ClassMaker;
import org.cojen.maker.Label;
import org.cojen.maker.MethodMaker;
import org.cojen.maker.Variable;

final class MethodIdWriterMaker {
    private static final SoftCache<IntArrayKey, MethodIdWriter> cCache = new SoftCache();

    MethodIdWriterMaker() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static MethodIdWriter writerFor(RemoteInfo original, RemoteInfo current, boolean force) {
        if (original == current && !force) {
            return null;
        }
        int[] mapping = original.methodIdMap(current);
        boolean diffs = false;
        int max = Integer.MIN_VALUE;
        for (int i = 0; i < mapping.length; ++i) {
            diffs |= mapping[i] != i;
            max = Math.max(max, mapping[i]);
        }
        if (!force && !diffs) {
            return null;
        }
        if (max == Integer.MIN_VALUE) {
            return MethodIdWriter.Unimplemented.THE;
        }
        IntArrayKey key = new IntArrayKey(mapping);
        MethodIdWriter writer = cCache.get(key);
        if (writer == null) {
            SoftCache<IntArrayKey, MethodIdWriter> softCache = cCache;
            synchronized (softCache) {
                writer = cCache.get(key);
                if (writer == null) {
                    writer = MethodIdWriterMaker.makeWriter(mapping);
                    cCache.put(key, writer);
                }
            }
        }
        return writer;
    }

    private static MethodIdWriter makeWriter(int[] mapping) {
        ClassMaker cm = ClassMaker.begin(null, (MethodHandles.Lookup)MethodHandles.lookup()).implement(MethodIdWriter.class).final_();
        cm.addConstructor(new Object[0]);
        MethodMaker mm = cm.addMethod(null, "writeMethodId", new Object[]{Pipe.class, Integer.TYPE, String.class});
        mm.public_();
        if (mapping.length > 0) {
            Label defaultLabel = mm.label();
            int[] cases = new int[mapping.length];
            Label[] labels = new Label[mapping.length];
            int maxCurrentId = 0;
            int numMatches = 0;
            for (int i = 0; i < mapping.length; ++i) {
                cases[i] = i;
                int idCurrent = mapping[i];
                if (idCurrent == Integer.MIN_VALUE) {
                    labels[i] = defaultLabel;
                    continue;
                }
                labels[i] = mm.label();
                maxCurrentId = Math.max(maxCurrentId, idCurrent);
                ++numMatches;
            }
            if (numMatches > 0) {
                Variable idCurrentVar;
                Variable pipeVar;
                block10: {
                    pipeVar = mm.param(0);
                    Variable idOriginalVar = mm.param(1);
                    Label writeLabel = mm.label();
                    idCurrentVar = mm.var(Integer.TYPE);
                    if (numMatches == 1) {
                        int i = 0;
                        while (true) {
                            int idCurrent;
                            if ((idCurrent = mapping[i]) != Integer.MIN_VALUE) {
                                idOriginalVar.ifNe((Object)cases[i], defaultLabel);
                                idCurrentVar.set((Object)idCurrent);
                                break block10;
                            }
                            ++i;
                        }
                    }
                    idOriginalVar.switch_(defaultLabel, cases, labels);
                    for (int i = 0; i < mapping.length; ++i) {
                        int idCurrent = mapping[i];
                        if (idCurrent == Integer.MIN_VALUE) continue;
                        labels[i].here();
                        idCurrentVar.set((Object)idCurrent);
                        mm.goto_(writeLabel);
                    }
                    writeLabel.here();
                }
                CoreUtils.writeIntId(pipeVar, maxCurrentId, idCurrentVar);
                mm.return_();
                defaultLabel.here();
            }
        }
        Variable messageVar = mm.concat(new Object[]{"Unimplemented on the remote side: ", mm.param(2)});
        mm.new_(UnimplementedException.class, new Object[]{messageVar}).throw_();
        mm = cm.addMethod(null, "writeSyntheticMethodId", new Object[]{Pipe.class, Integer.TYPE, String.class});
        mm.public_();
        mm.invoke("writeMethodId", new Object[]{mm.param(0), mm.param(1), mm.param(2)});
        MethodHandles.Lookup lookup = cm.finishHidden();
        try {
            return lookup.findConstructor(lookup.lookupClass(), MethodType.methodType(Void.TYPE)).invoke();
        }
        catch (Throwable e) {
            throw new AssertionError((Object)e);
        }
    }
}

