/*
 * Decompiled with CFR 0.152.
 */
package org.cojen.dirmi.core;

import java.util.Arrays;

final class ReferenceLookup {
    private Object[] mReferences = new Object[16];
    private int mSize;

    ReferenceLookup() {
    }

    int reserve() {
        int identifier = this.mSize;
        Object[] refs = this.mReferences;
        if (identifier >= refs.length) {
            this.mReferences = Arrays.copyOf(refs, refs.length << 1);
        }
        this.mSize = identifier + 1;
        return identifier;
    }

    void stash(int identifier, Object object) {
        this.mReferences[identifier] = object;
    }

    void stash(Object object) {
        int identifier = this.mSize;
        Object[] refs = this.mReferences;
        if (identifier >= refs.length) {
            this.mReferences = refs = Arrays.copyOf(refs, refs.length << 1);
        }
        refs[identifier] = object;
        this.mSize = identifier + 1;
    }

    Object find(int identifier) {
        return this.mReferences[identifier];
    }
}

