/*
 * Decompiled with CFR 0.152.
 */
package org.cojen.dirmi.core;

final class ReferenceMap {
    private Entry[] mEntries = new Entry[16];
    private int mSize;
    private int mEnableCount;

    ReferenceMap() {
    }

    boolean isDisabled() {
        return this.mEnableCount == -1;
    }

    void enable() {
        int count = this.mEnableCount + 1;
        if (count == -1) {
            throw new IllegalStateException("Enable limit exceeded");
        }
        if (count == 0) {
            assert (this.mEntries == null);
            assert (this.mSize == 0);
            this.mEntries = new Entry[16];
        }
        this.mEnableCount = count;
    }

    int disable() {
        int count = this.mEnableCount;
        if (count == -1) {
            throw new IllegalStateException("Not enabled");
        }
        if (count == 0) {
            this.mEntries = null;
            this.mSize = 0;
        }
        this.mEnableCount = count - 1;
        return count;
    }

    boolean isEmpty() {
        return this.mSize == 0;
    }

    int add(Object object) {
        Entry[] entries = this.mEntries;
        int hash = System.identityHashCode(object);
        int slot = hash & entries.length - 1;
        Entry e = entries[slot];
        while (e != null) {
            if (object == e.mObject) {
                return e.mIdentifier;
            }
            e = e.mNext;
        }
        int size = this.mSize;
        if (size + (size >> 1) >= entries.length) {
            if (size == Integer.MAX_VALUE) {
                throw new IllegalStateException("Reference limit reached");
            }
            if (size < 0x40000000) {
                Entry[] newEntries = new Entry[entries.length << 1];
                for (int i = 0; i < entries.length; ++i) {
                    Entry e2 = entries[i];
                    while (e2 != null) {
                        Entry next = e2.mNext;
                        slot = e2.mHash & newEntries.length - 1;
                        e2.mNext = newEntries[slot];
                        newEntries[slot] = e2;
                        e2 = next;
                    }
                }
                entries = newEntries;
                this.mEntries = newEntries;
                slot = hash & entries.length - 1;
            }
        }
        Entry newEntry = new Entry(object, hash, size);
        newEntry.mNext = entries[slot];
        entries[slot] = newEntry;
        this.mSize = size + 1;
        return ~size;
    }

    private static final class Entry {
        final Object mObject;
        final int mHash;
        final int mIdentifier;
        Entry mNext;

        Entry(Object object, int hash, int identifier) {
            this.mObject = object;
            this.mHash = hash;
            this.mIdentifier = identifier;
        }
    }
}

