/*
 * Decompiled with CFR 0.152.
 */
package org.cojen.dirmi.core;

import java.io.IOException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import org.cojen.dirmi.Pipe;
import org.cojen.dirmi.Remote;
import org.cojen.dirmi.RemoteException;
import org.cojen.dirmi.RemoteFailure;
import org.cojen.dirmi.core.CanonicalSet;
import org.cojen.dirmi.core.CoreUtils;
import org.cojen.dirmi.core.JoinedIterator;
import org.cojen.dirmi.core.RemoteExaminer;
import org.cojen.dirmi.core.RemoteMethod;
import org.cojen.dirmi.core.SoftCache;

final class RemoteInfo {
    private static final int F_UNDECLARED_EX = 1;
    private static final SoftCache<Class<?>, RemoteInfo> cCache = new SoftCache();
    private static final CanonicalSet<RemoteInfo> cCanonical = new CanonicalSet();
    private final int mFlags;
    private final String mName;
    private final String mRemoteFailureException;
    private final Set<String> mInterfaceNames;
    private final SortedSet<RemoteMethod> mRemoteMethods;
    private int mHashCode;

    public static RemoteInfo examine(Class<?> type) {
        return RemoteInfo.examine(type, true);
    }

    public static RemoteInfo examineStub(Object stub) {
        RemoteExaminer.remoteType(stub);
        return RemoteInfo.examine(stub.getClass(), false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static RemoteInfo examine(Class<?> type, boolean strict) {
        RemoteInfo info = cCache.get(type);
        if (info == null) {
            SoftCache<Class<?>, RemoteInfo> softCache = cCache;
            synchronized (softCache) {
                info = cCache.get(type);
                if (info == null) {
                    info = RemoteInfo.doExamine(type, strict);
                    cCache.put(type, info);
                }
            }
        }
        return info;
    }

    private static RemoteInfo doExamine(Class<?> type, boolean strict) {
        Class remoteFailureException;
        if (strict) {
            if (!type.isInterface()) {
                throw new IllegalArgumentException("Remote type must be an interface: " + type);
            }
            if (!Modifier.isPublic(type.getModifiers())) {
                throw new IllegalArgumentException("Remote interface must be public: " + type.getName());
            }
            if (!CoreUtils.isRemote(type)) {
                throw new IllegalArgumentException("Remote interface must extend " + Remote.class.getName() + ": " + type.getName());
            }
        }
        int flags = 0;
        RemoteFailure ann = type.getAnnotation(RemoteFailure.class);
        if (ann == null) {
            remoteFailureException = RemoteException.class;
        } else {
            remoteFailureException = ann.exception();
            if (remoteFailureException == null) {
                remoteFailureException = RemoteException.class;
            }
            if (!ann.declared() || CoreUtils.isUnchecked(remoteFailureException)) {
                flags |= 1;
            }
        }
        TreeMap<RemoteMethod, RemoteMethod> methodMap = new TreeMap<RemoteMethod, RemoteMethod>();
        SortedSet<RemoteMethod> methodSet = null;
        for (Method m : type.getMethods()) {
            RemoteMethod candidate;
            if (RemoteInfo.isObjectMethod(m) || strict && !m.getDeclaringClass().isInterface()) continue;
            try {
                candidate = new RemoteMethod(m, ann);
            }
            catch (IllegalArgumentException e) {
                if (m.isDefault()) continue;
                throw e;
            }
            RemoteMethod existing = methodMap.putIfAbsent(candidate, candidate);
            if (existing != null) {
                if (!type.isInterface()) continue;
                existing.conflictCheck(m, candidate);
                continue;
            }
            if (!candidate.isBatched() || !CoreUtils.isRemote(m.getReturnType())) continue;
            if (methodSet == null) {
                methodSet = new TreeSet<RemoteMethod>();
            }
            methodSet.add(candidate.asBatchedImmediate());
        }
        if (methodMap.isEmpty()) {
            methodSet = Collections.emptySortedSet();
        } else if (methodSet == null) {
            methodSet = new TreeSet(methodMap.keySet());
        } else {
            methodSet.addAll(methodMap.keySet());
        }
        Set<String> interfaces = new TreeSet<String>();
        RemoteInfo.gatherRemoteInterfaces(interfaces, type);
        interfaces.remove(type.getName());
        if (interfaces.isEmpty()) {
            interfaces = Collections.emptySet();
        }
        String name = type.getName().intern();
        String remoteFailureString = remoteFailureException.getName().intern();
        RemoteInfo info = new RemoteInfo(flags, name, remoteFailureString, interfaces, methodSet);
        return cCanonical.add(info);
    }

    private static void gatherRemoteInterfaces(Set<String> interfaces, Class<?> clazz) {
        for (Class<?> i : clazz.getInterfaces()) {
            if (!CoreUtils.isRemote(i) || !interfaces.add(i.getName().intern())) continue;
            RemoteInfo.gatherRemoteInterfaces(interfaces, i);
        }
        if (clazz.isInterface() && CoreUtils.isRemote(clazz)) {
            interfaces.add(clazz.getName().intern());
        }
    }

    private static boolean isObjectMethod(Method m) {
        try {
            return Object.class.getMethod(m.getName(), m.getParameterTypes()) != null;
        }
        catch (NoSuchMethodException e) {
            return false;
        }
    }

    private RemoteInfo(int flags, String name, String remoteFailureException, Set<String> interfaceNames, SortedSet<RemoteMethod> remoteMethods) {
        this.mFlags = flags;
        this.mName = name;
        this.mRemoteFailureException = remoteFailureException;
        this.mInterfaceNames = interfaceNames;
        this.mRemoteMethods = remoteMethods;
    }

    boolean isRemoteFailureExceptionUndeclared() {
        return (this.mFlags & 1) != 0;
    }

    String name() {
        return this.mName;
    }

    String remoteFailureException() {
        return this.mRemoteFailureException;
    }

    Set<String> interfaceNames() {
        return this.mInterfaceNames;
    }

    SortedSet<RemoteMethod> remoteMethods() {
        return this.mRemoteMethods;
    }

    boolean isAssignableFrom(RemoteInfo other) {
        String name = this.name();
        if (name.equals(other.name()) || other.interfaceNames().contains(name)) {
            return true;
        }
        if (name.equals(Remote.class.getName())) {
            return true;
        }
        try {
            if (name.equals(java.rmi.Remote.class.getName())) {
                return true;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return false;
    }

    int[] methodIdMap(RemoteInfo to) {
        int[] mapping = new int[this.mRemoteMethods.size()];
        Arrays.fill(mapping, Integer.MIN_VALUE);
        JoinedIterator<RemoteMethod> it = new JoinedIterator<RemoteMethod>(this.mRemoteMethods, to.mRemoteMethods);
        RemoteMethod lastFromMethod = null;
        int fromMethodId = -1;
        RemoteMethod lastToMethod = null;
        int toMethodId = -1;
        int fromSyntheticMethodId = -1;
        for (RemoteMethod m : this.mRemoteMethods) {
            if (m.isUnimplemented()) continue;
            ++fromSyntheticMethodId;
        }
        while (it.hasNext()) {
            RemoteMethod toMethod;
            Object pair = it.next();
            RemoteMethod fromMethod = (RemoteMethod)((JoinedIterator.Pair)pair).a;
            if (fromMethod != lastFromMethod && fromMethod != null) {
                if (fromMethod.isUnimplemented()) {
                    ++fromSyntheticMethodId;
                } else {
                    ++fromMethodId;
                    lastFromMethod = fromMethod;
                }
            }
            if ((toMethod = (RemoteMethod)((JoinedIterator.Pair)pair).b) != lastToMethod && toMethod != null) {
                ++toMethodId;
                lastToMethod = toMethod;
            }
            if (fromMethod == null || toMethod == null || !fromMethod.isCompatibleWith(toMethod)) continue;
            int fromId = fromMethod.isUnimplemented() ? fromSyntheticMethodId : fromMethodId;
            mapping[fromId] = toMethodId;
        }
        return mapping;
    }

    public int hashCode() {
        int hash = this.mHashCode;
        if (hash == 0) {
            hash = this.mFlags;
            hash = hash * 31 + this.mName.hashCode();
            hash = hash * 31 + this.mRemoteFailureException.hashCode();
            hash = hash * 31 + this.mInterfaceNames.hashCode();
            this.mHashCode = hash = hash * 31 + this.mRemoteMethods.hashCode();
        }
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof RemoteInfo) {
            RemoteInfo other = (RemoteInfo)obj;
            return this.mFlags == other.mFlags && this.mName.equals(other.mName) && this.mRemoteFailureException.equals(other.mRemoteFailureException) && this.mInterfaceNames.equals(other.mInterfaceNames) && this.mRemoteMethods.equals(other.mRemoteMethods);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void writeTo(Pipe pipe) throws IOException {
        pipe.enableReferences();
        try {
            pipe.writeInt(this.mFlags);
            pipe.writeObject(this.mName);
            pipe.writeObject(this.mRemoteFailureException);
            RemoteInfo.writeStrings(pipe, this.mInterfaceNames);
            int size = this.mRemoteMethods.size();
            RemoteInfo.writeSize(pipe, size);
            for (RemoteMethod m : this.mRemoteMethods) {
                m.writeTo(pipe);
            }
        }
        finally {
            pipe.disableReferences();
        }
    }

    static void writeSize(Pipe pipe, int size) throws IOException {
        if (size < 128) {
            pipe.write(size);
        } else {
            pipe.writeInt(size | Integer.MIN_VALUE);
        }
    }

    static void writeStrings(Pipe pipe, Collection<String> c) throws IOException {
        RemoteInfo.writeSize(pipe, c.size());
        for (String s : c) {
            pipe.writeObject(s);
        }
    }

    static RemoteInfo readFrom(Pipe pipe) throws IOException {
        SortedSet<RemoteMethod> remoteMethods;
        int flags = pipe.readInt();
        String name = ((String)pipe.readObject()).intern();
        String remoteFailureException = ((String)pipe.readObject()).intern();
        Set<String> interfaceNames = RemoteInfo.readInternedStringSet(pipe);
        int size = RemoteInfo.readSize(pipe);
        if (size == 0) {
            remoteMethods = Collections.emptySortedSet();
        } else {
            remoteMethods = new TreeSet();
            for (int i = 0; i < size; ++i) {
                remoteMethods.add(RemoteMethod.readFrom(pipe));
            }
        }
        return cCanonical.add(new RemoteInfo(flags, name, remoteFailureException, interfaceNames, remoteMethods));
    }

    static List<String> readInternedStringList(Pipe pipe) throws IOException {
        int size = RemoteInfo.readSize(pipe);
        if (size == 0) {
            return Collections.emptyList();
        }
        ArrayList<String> list = new ArrayList<String>(size);
        for (int i = 0; i < size; ++i) {
            list.add(((String)pipe.readObject()).intern());
        }
        return list;
    }

    static Set<String> readInternedStringSet(Pipe pipe) throws IOException {
        int size = RemoteInfo.readSize(pipe);
        if (size == 0) {
            return Collections.emptySet();
        }
        TreeSet<String> set = new TreeSet<String>();
        for (int i = 0; i < size; ++i) {
            set.add(((String)pipe.readObject()).intern());
        }
        return set;
    }

    static int readSize(Pipe pipe) throws IOException {
        int size = pipe.readByte();
        if (size < 0) {
            size &= 0x7F;
            size = size << 24 | pipe.readUnsignedByte() << 16 | pipe.readUnsignedShort();
        }
        return size;
    }
}

