/*
 * Decompiled with CFR 0.152.
 */
package org.cojen.dirmi.core;

import java.io.IOException;
import java.io.ObjectInputFilter;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;
import org.cojen.dirmi.Batched;
import org.cojen.dirmi.Disposer;
import org.cojen.dirmi.NoReply;
import org.cojen.dirmi.Pipe;
import org.cojen.dirmi.RemoteException;
import org.cojen.dirmi.RemoteFailure;
import org.cojen.dirmi.Restorable;
import org.cojen.dirmi.Serialized;
import org.cojen.dirmi.Unbatched;
import org.cojen.dirmi.core.CoreUtils;
import org.cojen.dirmi.core.RemoteInfo;
import org.cojen.dirmi.core.SerializedFilter;
import org.cojen.dirmi.core.Unimplemented;

final class RemoteMethod
implements Comparable<RemoteMethod> {
    private static final int F_UNDECLARED_EX = 1;
    private static final int F_DISPOSER = 2;
    private static final int F_BATCHED = 4;
    private static final int F_UNBATCHED = 8;
    private static final int F_RESTORABLE = 16;
    private static final int F_PIPED = 32;
    private static final int F_NOREPLY = 64;
    private static final int F_SERIALIZED = 128;
    private static final int F_UNIMPLEMENTED = 256;
    private static final int F_LENIENT = 512;
    private final int mFlags;
    private final String mName;
    private final String mRemoteFailureException;
    private final String mReturnType;
    private final List<String> mParameterTypes;
    private final Set<String> mExceptionTypes;
    private final ObjectInputFilter mObjectInputFilter;
    private int mHashCode;

    private RemoteMethod(int flags, String name, String remoteFailureException, String returnType, List<String> parameterTypes, Set<String> exceptionTypes, ObjectInputFilter objectInputFilter) {
        this.mFlags = flags;
        this.mName = name;
        this.mRemoteFailureException = remoteFailureException;
        this.mReturnType = returnType;
        this.mParameterTypes = parameterTypes;
        this.mExceptionTypes = exceptionTypes;
        this.mObjectInputFilter = objectInputFilter;
    }

    /*
     * WARNING - void declaration
     */
    RemoteMethod(Method m, RemoteFailure defaultFailure) {
        Class remoteFailureException;
        Serialized serializedAnn;
        int flags;
        block52: {
            Class<?>[] exceptionTypes;
            void var11_22;
            Restorable restorableAnn;
            if (!Modifier.isPublic(m.getModifiers())) {
                throw new IllegalArgumentException("Remote method must be public: " + m);
            }
            this.mName = m.getName().intern();
            flags = 0;
            if (m.isAnnotationPresent(Disposer.class)) {
                flags |= 2;
            }
            if (m.isAnnotationPresent(Batched.class)) {
                flags |= 4;
            }
            if (m.isAnnotationPresent(Unbatched.class)) {
                flags |= 8;
            }
            if ((restorableAnn = m.getAnnotation(Restorable.class)) != null) {
                flags |= 0x10;
                if (restorableAnn.lenient()) {
                    flags |= 0x200;
                }
            }
            if (m.isAnnotationPresent(NoReply.class)) {
                flags |= 0x40;
            }
            if ((serializedAnn = m.getAnnotation(Serialized.class)) != null) {
                flags |= 0x80;
            }
            if (m.isAnnotationPresent(Unimplemented.class) && !m.getDeclaringClass().isInterface()) {
                flags |= 0x100;
            }
            if ((flags & 4) != 0 && (flags & 8) != 0) {
                throw new IllegalArgumentException("Method cannot be annotated as both @Batched and @Unbatched: " + m);
            }
            RemoteFailure ann = m.getAnnotation(RemoteFailure.class);
            if (ann == null) {
                ann = defaultFailure;
            }
            if (ann == null) {
                remoteFailureException = RemoteException.class;
            } else {
                remoteFailureException = ann.exception();
                if (remoteFailureException == null) {
                    remoteFailureException = RemoteException.class;
                } else {
                    if (!Modifier.isPublic(remoteFailureException.getModifiers())) {
                        throw new IllegalArgumentException("Remote failure exception must be public: " + remoteFailureException.getName());
                    }
                    try {
                        remoteFailureException.getConstructor(Throwable.class);
                    }
                    catch (NoSuchMethodException noSuchMethodException) {
                        try {
                            remoteFailureException.getConstructor(String.class, Throwable.class);
                        }
                        catch (NoSuchMethodException noSuchMethodException2) {
                            throw new IllegalArgumentException("Remote failure exception must have a public constructor which accepts a Throwable cause: " + remoteFailureException.getName());
                        }
                    }
                }
                if (!ann.declared() || CoreUtils.isUnchecked(remoteFailureException)) {
                    flags |= 1;
                }
            }
            Class<?> returnType = m.getReturnType();
            if (!Modifier.isPublic(returnType.getModifiers())) {
                throw new IllegalArgumentException("Remote method return type must be public: " + m);
            }
            if ((flags & 4) == 0) {
                if (returnType == Pipe.class) {
                    flags |= 0x20;
                }
            } else if (returnType != Void.TYPE && !CoreUtils.isRemote(returnType)) {
                throw new IllegalArgumentException("Batched method must return void or a remote object: " + m);
            }
            if ((flags & 0x10) != 0) {
                if (!CoreUtils.isRemote(returnType)) {
                    throw new IllegalArgumentException("Restorable method must return a remote object: " + m);
                }
                if ((flags & 0x202) == 514) {
                    throw new IllegalArgumentException("Lenient restorable method cannot also be a disposer: " + m);
                }
            }
            if ((flags & 0x40) != 0 && returnType != Void.TYPE) {
                throw new IllegalArgumentException("NoReply method must return void: " + m);
            }
            this.mReturnType = returnType.descriptorString().intern();
            Class<?>[] paramTypes = m.getParameterTypes();
            if (paramTypes.length == 0) {
                this.mParameterTypes = Collections.emptyList();
            } else {
                this.mParameterTypes = new ArrayList<String>(paramTypes.length);
                for (Class<?> clazz : paramTypes) {
                    if (!Modifier.isPublic(clazz.getModifiers())) {
                        throw new IllegalArgumentException("Remote method parameter types must be public: " + m);
                    }
                    this.mParameterTypes.add(clazz.descriptorString().intern());
                }
            }
            int numPipes = 0;
            Class<?>[] classArray = paramTypes;
            int n = classArray.length;
            boolean bl = false;
            while (var11_22 < n) {
                Class<?> paramType2 = classArray[var11_22];
                if (paramType2 == Pipe.class) {
                    ++numPipes;
                }
                ++var11_22;
            }
            if ((flags & 0x20) != 0) {
                if (numPipes != 1) {
                    throw new IllegalArgumentException("Piped method must have exactly one Pipe parameter: " + m);
                }
                if (serializedAnn != null) {
                    throw new IllegalArgumentException("Piped method cannot have @Serialized annotation: " + m);
                }
            } else if (numPipes != 0) {
                throw new IllegalArgumentException("Piped method must return a Pipe: " + m);
            }
            if ((exceptionTypes = m.getExceptionTypes()).length == 0) {
                this.mExceptionTypes = Collections.emptySet();
            } else {
                this.mExceptionTypes = new TreeSet<String>();
                Class<?>[] classArray2 = exceptionTypes;
                int n2 = classArray2.length;
                for (n = 0; n < n2; ++n) {
                    Class<?> clazz = classArray2[n];
                    if (!Modifier.isPublic(clazz.getModifiers())) {
                        throw new IllegalArgumentException("Remote exception type must be public: " + m + " throws " + clazz);
                    }
                    this.mExceptionTypes.add(clazz.getName().intern());
                }
            }
            if ((flags & 1) == 0) {
                for (Class<?> clazz : exceptionTypes) {
                    if (!clazz.isAssignableFrom(remoteFailureException)) {
                        continue;
                    }
                    break block52;
                }
                if (remoteFailureException == RemoteException.class) {
                    try {
                        for (Class<java.rmi.RemoteException> clazz : exceptionTypes) {
                            if (!clazz.isAssignableFrom(java.rmi.RemoteException.class)) continue;
                            remoteFailureException = java.rmi.RemoteException.class;
                            break block52;
                        }
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
                throw new IllegalArgumentException("Method must declare throwing " + remoteFailureException.getName() + " (or a superclass): " + m);
            }
        }
        this.mFlags = flags;
        this.mRemoteFailureException = remoteFailureException.getName().intern();
        this.mObjectInputFilter = serializedAnn == null ? null : SerializedFilter.filterFor(serializedAnn);
    }

    RemoteMethod asBatchedImmediate() {
        int flags = (this.mFlags | 0xC) & 0xFFFFFFBF;
        return new RemoteMethod(flags, this.mName, this.mRemoteFailureException, this.mReturnType, this.mParameterTypes, this.mExceptionTypes, this.mObjectInputFilter);
    }

    boolean isRemoteFailureExceptionUndeclared() {
        return (this.mFlags & 1) != 0;
    }

    boolean isDisposer() {
        return (this.mFlags & 2) != 0;
    }

    boolean isBatched() {
        return (this.mFlags & 4) != 0;
    }

    boolean isBatchedImmediate() {
        return (this.mFlags & 0xC) == 12;
    }

    boolean isUnbatched() {
        return (this.mFlags & 0xC) == 8;
    }

    boolean isRestorable() {
        return (this.mFlags & 0x10) != 0;
    }

    boolean isLenient() {
        return (this.mFlags & 0x200) != 0;
    }

    boolean isPiped() {
        return (this.mFlags & 0x20) != 0;
    }

    boolean isNoReply() {
        return (this.mFlags & 0x40) != 0;
    }

    boolean isSerialized() {
        return (this.mFlags & 0x80) != 0;
    }

    ObjectInputFilter objectInputFilter() {
        return this.mObjectInputFilter;
    }

    boolean isUnimplemented() {
        return (this.mFlags & 0x100) != 0;
    }

    String name() {
        return this.mName;
    }

    String remoteFailureException() {
        return this.mRemoteFailureException;
    }

    String returnType() {
        return this.mReturnType;
    }

    List<String> parameterTypes() {
        return this.mParameterTypes;
    }

    Set<String> exceptionTypes() {
        return this.mExceptionTypes;
    }

    boolean isCompatibleWith(RemoteMethod other) {
        int mask = 196;
        return (this.mFlags & mask) == (other.mFlags & mask);
    }

    void conflictCheck(Method m, RemoteMethod other) {
        String prefix = "Method is inherited multiple times with conflicting ";
        if (this.mFlags != other.mFlags) {
            throw new IllegalArgumentException(prefix + "annotations: " + m);
        }
        if (!this.mRemoteFailureException.equals(other.mRemoteFailureException)) {
            throw new IllegalArgumentException(prefix + "remote failure exceptions: " + m);
        }
    }

    public int hashCode() {
        int hash = this.mHashCode;
        if (hash == 0) {
            hash = this.mFlags;
            hash = hash * 31 + this.mName.hashCode();
            hash = hash * 31 + this.mRemoteFailureException.hashCode();
            hash = hash * 31 + this.mReturnType.hashCode();
            hash = hash * 31 + this.mParameterTypes.hashCode();
            hash = hash * 31 + this.mExceptionTypes.hashCode();
            if (this.mObjectInputFilter != null) {
                hash = hash * 31 + this.mObjectInputFilter.hashCode();
            }
            this.mHashCode = hash;
        }
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof RemoteMethod) {
            RemoteMethod other = (RemoteMethod)obj;
            return this.mFlags == other.mFlags && this.mName.equals(other.mName) && this.mRemoteFailureException.equals(other.mRemoteFailureException) && this.mReturnType.equals(other.mReturnType) && this.mParameterTypes.equals(other.mParameterTypes) && this.mExceptionTypes.equals(other.mExceptionTypes) && Objects.equals(this.mObjectInputFilter, other.mObjectInputFilter);
        }
        return false;
    }

    @Override
    public int compareTo(RemoteMethod other) {
        int cmp = this.mName.compareTo(other.mName);
        if (cmp != 0) {
            return cmp;
        }
        cmp = this.mReturnType.compareTo(other.mReturnType);
        if (cmp != 0) {
            return cmp;
        }
        cmp = RemoteMethod.compare(this.mParameterTypes, other.mParameterTypes);
        if (cmp != 0) {
            return cmp;
        }
        return Boolean.compare(other.isBatchedImmediate(), this.isBatchedImmediate());
    }

    static <E extends Comparable<E>> int compare(Collection<E> a, Collection<E> b) {
        int sizeb;
        int sizea = a.size();
        int size = Math.min(sizea, sizeb = b.size());
        if (size != 0) {
            Iterator<E> ita = a.iterator();
            Iterator<E> itb = b.iterator();
            for (int i = 0; i < size; ++i) {
                int cmp = ((Comparable)ita.next()).compareTo((Comparable)itb.next());
                if (cmp == 0) continue;
                return cmp;
            }
        }
        return Integer.compare(sizea, sizeb);
    }

    void writeTo(Pipe pipe) throws IOException {
        pipe.writeInt(this.mFlags);
        pipe.writeObject(this.mName);
        pipe.writeObject(this.mRemoteFailureException);
        pipe.writeObject(this.mReturnType);
        RemoteInfo.writeStrings(pipe, this.mParameterTypes);
        RemoteInfo.writeStrings(pipe, this.mExceptionTypes);
    }

    static RemoteMethod readFrom(Pipe pipe) throws IOException {
        int flags = pipe.readInt();
        String name = ((String)pipe.readObject()).intern();
        String remoteFailureException = ((String)pipe.readObject()).intern();
        String returnType = ((String)pipe.readObject()).intern();
        List<String> parameterTypes = RemoteInfo.readInternedStringList(pipe);
        Set<String> exceptionTypes = RemoteInfo.readInternedStringSet(pipe);
        return new RemoteMethod(flags, name, remoteFailureException, returnType, parameterTypes, exceptionTypes, null);
    }
}

