/*
 * Decompiled with CFR 0.152.
 */
package org.cojen.dirmi.core;

import java.io.IOException;
import java.lang.invoke.MethodHandle;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import org.cojen.dirmi.DisposedException;
import org.cojen.dirmi.Pipe;
import org.cojen.dirmi.Session;
import org.cojen.dirmi.core.CoreStubSupport;
import org.cojen.dirmi.core.CoreUtils;
import org.cojen.dirmi.core.DisposedStubSupport;
import org.cojen.dirmi.core.Stub;
import org.cojen.dirmi.core.StubSupport;

final class RestorableStubSupport
extends ConcurrentHashMap<Stub, CountDownLatch>
implements StubSupport {
    private final CoreStubSupport mNewSupport;

    RestorableStubSupport(CoreStubSupport support) {
        this.mNewSupport = support;
    }

    @Override
    public Session session() {
        return this.mNewSupport.session();
    }

    @Override
    public void appendInfo(StringBuilder b) {
        b.append(", unrestored=").append(true);
    }

    @Override
    public <T extends Throwable> Pipe connect(Stub stub, Class<T> remoteFailureException) throws T {
        this.restore(stub, remoteFailureException);
        return null;
    }

    @Override
    public <T extends Throwable> Pipe connectUnbatched(Stub stub, Class<T> remoteFailureException) throws T {
        return this.connect(stub, remoteFailureException);
    }

    @Override
    public <T extends Throwable> Pipe tryConnect(Stub stub, Class<T> remoteFailureException) throws T {
        return this.connect(stub, remoteFailureException);
    }

    @Override
    public <T extends Throwable> Pipe tryConnectUnbatched(Stub stub, Class<T> remoteFailureException) throws T {
        return this.tryConnect(stub, remoteFailureException);
    }

    @Override
    public boolean validate(Stub stub, Pipe pipe) {
        return false;
    }

    @Override
    public long remoteTypeId(Class<?> type) {
        throw new IllegalStateException();
    }

    @Override
    public <T extends Throwable> Object newAliasStub(Class<T> remoteFailureException, long aliasId, long typeId) throws T {
        throw new IllegalStateException();
    }

    @Override
    public Stub newDisconnectedStub(Class<?> type, Throwable cause) {
        throw new IllegalStateException();
    }

    @Override
    public boolean isBatching(Pipe pipe) {
        throw new IllegalStateException();
    }

    @Override
    public boolean finishBatch(Pipe pipe) {
        throw new IllegalStateException();
    }

    @Override
    public Throwable readResponse(Pipe pipe) throws IOException {
        throw new IllegalStateException();
    }

    @Override
    public void finished(Pipe pipe) {
        throw new IllegalStateException();
    }

    @Override
    public void batched(Pipe pipe) {
        throw new IllegalStateException();
    }

    @Override
    public <T extends Throwable> T failed(Class<T> remoteFailureException, Pipe pipe, Throwable cause) {
        throw new IllegalStateException();
    }

    @Override
    public void dispose(Stub stub) {
        throw new IllegalStateException();
    }

    private <T extends Throwable> void restore(Stub stub, Class<T> remoteFailureException) throws T {
        StubSupport newSupport;
        CountDownLatch existing;
        CountDownLatch latch = new CountDownLatch(1);
        while ((existing = this.putIfAbsent(stub, latch)) != null) {
            try {
                existing.await();
            }
            catch (InterruptedException e) {
                throw CoreUtils.remoteException(this, remoteFailureException, (Throwable)e);
            }
            newSupport = Stub.cSupportHandle.getAcquire(stub);
            if (newSupport == this) continue;
            return;
        }
        MethodHandle origin = Stub.cOriginHandle.getAcquire(stub);
        try {
            Stub newStub = origin.invoke();
            this.mNewSupport.session().mStubs.stealIdentity(stub, newStub);
            newSupport = Stub.cSupportHandle.getAcquire(newStub);
            StubSupport result = Stub.cSupportHandle.compareAndExchange(stub, this, newSupport);
            if (result != newSupport && result instanceof DisposedStubSupport) {
                this.dispose(stub);
            }
            return;
        }
        catch (Error | RuntimeException e) {
            throw e;
        }
        catch (Throwable e2) {
            DisposedException e2;
            if (e2 instanceof DisposedException) {
                Object message = e2.getMessage();
                String prefix = "Object and origin are disposed";
                if (message == null || !((String)message).startsWith(prefix)) {
                    message = message == null || message == "Object is disposed" ? prefix : prefix + ": " + (String)message;
                }
                DisposedException de = new DisposedException((String)message);
                de.setStackTrace(e2.getStackTrace());
                e2 = de;
                this.mNewSupport.session().stubDispose(stub.id, (String)message);
            }
            throw CoreUtils.remoteException(this, remoteFailureException, (Throwable)e2);
        }
        finally {
            latch.countDown();
            this.remove(stub, latch);
        }
    }
}

